/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.content.Context;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import tech.linjiang.pandora.inspector.ElementHoldView;
import tech.linjiang.pandora.inspector.canvas.ClickInfoCanvas;
import tech.linjiang.pandora.inspector.canvas.SelectCanvas;
import tech.linjiang.pandora.inspector.model.Element;

public class SelectableView
extends ElementHoldView {
    private Element targetElement;
    private SelectCanvas selectCanvas;
    private ClickInfoCanvas clickInfoCanvas;
    private int touchSlop;
    private float downX;
    private float downY;
    private boolean isTouching;
    private View.OnClickListener clickListener;

    public SelectableView(Context context) {
        super(context);
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.touchSlop = vc.getScaledTouchSlop();
        this.selectCanvas = new SelectCanvas(this);
        this.clickInfoCanvas = new ClickInfoCanvas(this, true);
    }

    @Override
    protected String getViewHint() {
        return "\u2460 singleTap to select views.\n\u2461 tap the selected view again to see attributes.";
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.downX = event.getX();
                this.downY = event.getY();
                return true;
            }
            case 2: {
                float dy;
                float dx;
                if (this.isTouching || !((dx = event.getX() - this.downX) * dx + (dy = event.getY() - this.downY) * dy > (float)(this.touchSlop * this.touchSlop))) break;
                this.isTouching = true;
                break;
            }
            case 1: 
            case 3: {
                if (!this.isTouching) {
                    this.handleClick(event.getX(), event.getY());
                }
                this.isTouching = false;
            }
        }
        return super.onTouchEvent(event);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.selectCanvas.draw(canvas, this.targetElement);
        this.clickInfoCanvas.draw(canvas);
    }

    private void handleClick(float x, float y) {
        this.resetAll();
        Element element = this.getTargetElement(x, y);
        if (element != null) {
            if (this.targetElement == element) {
                if (this.clickListener != null) {
                    this.clickListener.onClick(element.getView());
                }
                this.invalidate();
                return;
            }
            this.targetElement = element;
            this.clickInfoCanvas.setInfoElement(element);
        }
        this.invalidate();
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.clickListener = l;
    }
}

