/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.treenode;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.linjiang.pandora.inspector.treenode.INode;

class Algorithm {
    private int MARGIN_SIBLING = 100;
    private int MARGIN_SUBTREE = 100;
    private Map<INode, NodeData> mNodeData = new HashMap<INode, NodeData>();

    public Algorithm() {
    }

    public Algorithm(int siblingMargin, int subtreeMargin) {
        this.MARGIN_SIBLING = siblingMargin;
        this.MARGIN_SUBTREE = subtreeMargin;
    }

    private NodeData createNodeData(INode node) {
        NodeData nodeData = new NodeData();
        nodeData.mAncestor = node;
        this.mNodeData.put(node, nodeData);
        return nodeData;
    }

    private NodeData getNodeData(INode node) {
        return this.mNodeData.get(node);
    }

    private void firstWalk(INode node, int depth, int number) {
        NodeData nodeData = this.createNodeData(node);
        nodeData.mDepth = depth;
        nodeData.mNumber = number;
        if (this.isLeaf(node)) {
            if (this.hasLeftSibling(node)) {
                INode leftSibling = this.getLeftSibling(node);
                nodeData.mPrelim = this.getPrelim(leftSibling) + (double)this.getSpacing(leftSibling, node);
            }
        } else {
            INode leftMost = this.getLeftMostChild(node);
            INode rightMost = this.getRightMostChild(node);
            INode defaultAncestor = leftMost;
            INode next = leftMost;
            int i = 1;
            while (next != null) {
                this.firstWalk(next, depth + 1, i++);
                defaultAncestor = this.apportion(next, defaultAncestor);
                next = this.getRightSibling(next);
            }
            this.executeShifts(node);
            double midPoint = 0.5 * (this.getPrelim(leftMost) + this.getPrelim(rightMost) + (double)rightMost.getWidth() - (double)node.getWidth());
            if (this.hasLeftSibling(node)) {
                INode leftSibling = this.getLeftSibling(node);
                nodeData.mPrelim = this.getPrelim(leftSibling) + (double)this.getSpacing(leftSibling, node);
                nodeData.mModifier = nodeData.mPrelim - midPoint;
            } else {
                nodeData.mPrelim = midPoint;
            }
        }
    }

    private void secondWalk(INode node, double modifier) {
        NodeData nodeData = this.getNodeData(node);
        node.setX((int)(nodeData.mPrelim + modifier));
        node.setY(nodeData.mDepth * (this.MARGIN_SUBTREE + node.getHeight()));
        node.setLevel(nodeData.mDepth);
        for (INode iNode : node.getChildren()) {
            this.secondWalk(iNode, modifier + nodeData.mModifier);
        }
    }

    private void executeShifts(INode node) {
        double shift = 0.0;
        double change = 0.0;
        INode w = this.getRightMostChild(node);
        while (w != null) {
            NodeData nodeData = this.getNodeData(w);
            nodeData.mPrelim = nodeData.mPrelim + shift;
            nodeData.mModifier = nodeData.mModifier + shift;
            shift += nodeData.mShift + (change += nodeData.mChange);
            w = this.getLeftSibling(w);
        }
    }

    private INode apportion(INode node, INode defaultAncestor) {
        if (this.hasLeftSibling(node)) {
            INode leftSibling = this.getLeftSibling(node);
            INode vip = node;
            INode vop = node;
            INode vim = leftSibling;
            INode vom = this.getLeftMostChild(vip.getParent());
            double sip = this.getModifier(vip);
            double sop = this.getModifier(vop);
            double sim = this.getModifier(vim);
            double som = this.getModifier(vom);
            INode nextRight = this.nextRight(vim);
            INode nextLeft = this.nextLeft(vip);
            while (nextRight != null && nextLeft != null) {
                vim = nextRight;
                vip = nextLeft;
                vom = this.nextLeft(vom);
                vop = this.nextRight(vop);
                this.setAncestor(vop, node);
                double shift = this.getPrelim(vim) + sim - (this.getPrelim(vip) + sip) + (double)this.getSpacing(vim, vip);
                if (shift > 0.0) {
                    this.moveSubtree(this.ancestor(vim, node, defaultAncestor), node, shift);
                    sip += shift;
                    sop += shift;
                }
                sim += this.getModifier(vim);
                sip += this.getModifier(vip);
                som += this.getModifier(vom);
                sop += this.getModifier(vop);
                nextRight = this.nextRight(vim);
                nextLeft = this.nextLeft(vip);
            }
            if (nextRight != null && this.nextRight(vop) == null) {
                this.setThread(vop, nextRight);
                this.setModifier(vop, this.getModifier(vop) + sim - sop);
            }
            if (nextLeft != null && this.nextLeft(vom) == null) {
                this.setThread(vom, nextLeft);
                this.setModifier(vom, this.getModifier(vom) + sip - som);
                defaultAncestor = node;
            }
        }
        return defaultAncestor;
    }

    private void setAncestor(INode v, INode ancestor) {
        this.getNodeData(v).mAncestor = ancestor;
    }

    private void setModifier(INode v, double modifier) {
        this.getNodeData(v).mModifier = modifier;
    }

    private void setThread(INode v, INode thread) {
        this.getNodeData(v).mThread = thread;
    }

    private double getPrelim(INode v) {
        return this.getNodeData(v).mPrelim;
    }

    private double getModifier(INode vip) {
        return this.getNodeData(vip).mModifier;
    }

    private void moveSubtree(INode wm, INode wp, double shift) {
        NodeData wpNodeData = this.getNodeData(wp);
        NodeData wmNodeData = this.getNodeData(wm);
        int subtrees = wpNodeData.mNumber - wmNodeData.mNumber;
        wpNodeData.mChange = wpNodeData.mChange - shift / (double)subtrees;
        wpNodeData.mShift = wpNodeData.mShift + shift;
        wmNodeData.mChange = wmNodeData.mChange + shift / (double)subtrees;
        wpNodeData.mPrelim = wpNodeData.mPrelim + shift;
        wpNodeData.mModifier = wpNodeData.mModifier + shift;
    }

    private INode ancestor(INode vim, INode node, INode defaultAncestor) {
        NodeData vipNodeData = this.getNodeData(vim);
        if (vipNodeData.mAncestor.getParent() == node.getParent()) {
            return vipNodeData.mAncestor;
        }
        return defaultAncestor;
    }

    private INode nextRight(INode node) {
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            return this.getRightMostChild(node);
        }
        return this.getNodeData(node).mThread;
    }

    private INode nextLeft(INode node) {
        if (node.getChildren() != null && node.getChildren().size() > 0) {
            return this.getLeftMostChild(node);
        }
        return this.getNodeData(node).mThread;
    }

    private int getSpacing(INode leftNode, INode rightNode) {
        return this.MARGIN_SIBLING + leftNode.getWidth();
    }

    private boolean isLeaf(INode node) {
        return node.getChildren().isEmpty();
    }

    private INode getLeftSibling(INode node) {
        if (!this.hasLeftSibling(node)) {
            return null;
        }
        INode parent = node.getParent();
        List<? extends INode> children = parent.getChildren();
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex - 1);
    }

    private boolean hasLeftSibling(INode node) {
        INode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        int nodeIndex = parent.getChildren().indexOf(node);
        return nodeIndex > 0;
    }

    private INode getRightSibling(INode node) {
        if (!this.hasRightSibling(node)) {
            return null;
        }
        INode parent = node.getParent();
        List<? extends INode> children = parent.getChildren();
        int nodeIndex = children.indexOf(node);
        return children.get(nodeIndex + 1);
    }

    private boolean hasRightSibling(INode node) {
        INode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        List<? extends INode> children = parent.getChildren();
        int nodeIndex = children.indexOf(node);
        return nodeIndex < children.size() - 1;
    }

    private INode getLeftMostChild(INode node) {
        return node.getChildren().get(0);
    }

    private INode getRightMostChild(INode node) {
        List<? extends INode> children = node.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        return children.get(children.size() - 1);
    }

    public void calc(INode root) {
        this.mNodeData.clear();
        this.firstWalk(root, 0, 0);
        this.secondWalk(root, -this.getPrelim(root));
    }

    private static class NodeData {
        private INode mAncestor;
        private INode mThread;
        private int mNumber;
        private int mDepth;
        private double mPrelim;
        private double mModifier;
        private double mShift;
        private double mChange;

        private NodeData() {
        }
    }
}

