/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.connector.EditCallback;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.EditFragment;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class SPFragment
extends BaseListFragment {
    private File descriptor;
    private String clickKey;
    private EditCallback callback = new EditCallback(){

        @Override
        public void onValueChanged(final String value) {
            if (!TextUtils.isEmpty((CharSequence)SPFragment.this.clickKey)) {
                new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

                    public String doInBackground(Void[] params) {
                        return Pandora.get().getSharedPref().updateSharedPref(SPFragment.this.descriptor, SPFragment.this.clickKey, value);
                    }

                    @Override
                    public void onPostExecute(String result) {
                        SPFragment.this.hideLoading();
                        if (TextUtils.isEmpty((CharSequence)result)) {
                            Utils.toast(R.string.pd_success);
                        } else {
                            Utils.toast(result);
                        }
                        SPFragment.this.loadData();
                    }
                }).execute(new Void[0]);
                SPFragment.this.showLoading();
            }
        }
    };

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.descriptor = (File)this.getArguments().getSerializable("param1");
        this.getToolbar().setTitle((CharSequence)this.descriptor.getName());
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof KeyValueItem) {
                    if (((KeyValueItem)item).isTitle) {
                        return;
                    }
                    SPFragment.this.clickKey = ((String[])((KeyValueItem)item).data)[0];
                    Bundle bundle = new Bundle();
                    bundle.putString("param1", ((String[])((KeyValueItem)item).data)[1]);
                    bundle.putSerializable("param2", (Serializable)SPFragment.this.callback);
                    SPFragment.this.launch(EditFragment.class, bundle);
                }
            }
        });
        this.loadData();
    }

    private void loadData() {
        Map<String, String> contents = Pandora.get().getSharedPref().getSharedPrefContent(this.descriptor);
        if (contents != null && !contents.isEmpty()) {
            ArrayList<BaseItem> data = new ArrayList<BaseItem>();
            data.add(new TitleItem(String.format(Locale.getDefault(), "%d ITEMS", contents.size())));
            data.add(new KeyValueItem(new String[]{"KEY", "VALUE"}, true));
            for (Map.Entry<String, String> entry : contents.entrySet()) {
                data.add(new KeyValueItem(new String[]{entry.getKey(), entry.getValue()}, false, true));
            }
            this.getAdapter().setItems(data);
        } else {
            this.showError(null);
        }
    }
}

