/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.RouteParamFragment;
import tech.linjiang.pandora.ui.item.RouteItem;
import tech.linjiang.pandora.util.Utils;

public class RouteFragment
extends BaseListFragment {
    private final RouteItem.Callback callback = new RouteItem.Callback(){

        @Override
        public void onClick(String simpleName, String clazz, boolean needParam) {
            if (needParam) {
                Bundle bundle = new Bundle();
                bundle.putString("param1", simpleName);
                bundle.putString("param2", clazz);
                RouteFragment.this.launch(RouteParamFragment.class, bundle, 1);
                return;
            }
            try {
                Intent intent = new Intent(RouteFragment.this.getContext(), Class.forName(clazz));
                RouteFragment.this.go(intent);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    };

    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle(R.string.pd_name_navigate);
        List<String> activities = Utils.getActivities();
        ArrayList<RouteItem> data = new ArrayList<RouteItem>();
        for (int i = 0; i < activities.size(); ++i) {
            data.add(new RouteItem(activities.get(i), this.callback));
        }
        this.getAdapter().setItems(data);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            this.go(data);
        }
    }

    private void go(Intent intent) {
        this.startActivity(intent);
        this.getActivity().finish();
    }
}

