/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.annotation.SuppressLint;
import android.app.AppOpsManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.util.Config;

public class Utils {
    public static final DateFormat DEFAULT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS", Locale.getDefault());
    public static final DateFormat NO_MILLIS = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
    public static final DateFormat HHMMSS = new SimpleDateFormat("HH:mm:ss SSS", Locale.getDefault());
    private static Context CONTEXT;
    private static Handler mainHandler;

    private Utils() {
    }

    public static void init(Context context) {
        CONTEXT = context.getApplicationContext();
        mainHandler = new Handler(Looper.getMainLooper());
    }

    @SuppressLint(value={"PrivateApi"})
    @NonNull
    public static Context getContext() {
        return CONTEXT;
    }

    public static <V> boolean isNotEmpty(List<V> sourceList) {
        return sourceList != null && sourceList.size() != 0;
    }

    public static <V> int getCount(V[] sourceList) {
        return sourceList != null && sourceList.length != 0 ? sourceList.length : 0;
    }

    public static <T> T[] newArray(T ... value) {
        return value;
    }

    public static String millis2String(long millis) {
        return Utils.millis2String(millis, DEFAULT);
    }

    public static String millis2String(long millis, DateFormat format) {
        return format.format(new Date(millis));
    }

    public static void toast(@StringRes int resId) {
        Toast.makeText((Context)CONTEXT, (int)resId, (int)1).show();
    }

    public static void toast(String msg) {
        Toast.makeText((Context)CONTEXT, (CharSequence)msg, (int)0).show();
    }

    public static void copy2ClipBoard(String msg) {
        ClipboardManager cm = (ClipboardManager)CONTEXT.getSystemService("clipboard");
        try {
            ClipData mClipData = ClipData.newPlainText((CharSequence)"text", (CharSequence)msg);
            cm.setPrimaryClip(mClipData);
            Utils.toast(R.string.pd_copy_2_clipboard);
        }
        catch (Throwable t) {
            Utils.toast(t.getMessage());
        }
    }

    public static void post(Runnable runnable) {
        mainHandler.post(runnable);
    }

    public static void postDelayed(Runnable runnable, long delayMillis) {
        mainHandler.postDelayed(runnable, delayMillis);
    }

    public static void cancelTask(Runnable runnable) {
        mainHandler.removeCallbacks(runnable);
    }

    public static String formatSize(long origin) {
        BigDecimal size = new BigDecimal(Long.toString(origin));
        String value = size.compareTo(new BigDecimal("1024")) < 0 ? size + "B" : ((size = size.divide(new BigDecimal("1024"))).compareTo(new BigDecimal("1024")) > 0 ? size.divide(new BigDecimal("1024"), 2, 1) + "MB" : size.setScale(2, 1) + "KB");
        return value;
    }

    public static String formatDuration(long ms) {
        String time = "";
        long hour = (ms /= 1000L) / 3600L;
        long mint = ms % 3600L / 60L;
        long sed = ms % 60L;
        if (hour > 0L) {
            String hourStr = String.valueOf(hour);
            time = time + hourStr + "h ";
        }
        if (mint > 0L) {
            String mintStr = String.valueOf(mint);
            time = time + mintStr + "m ";
        }
        if (sed > 0L) {
            String sedStr = String.valueOf(sed);
            time = time + sedStr + "s";
        }
        return time;
    }

    public static void removeViewFromWindow(View v) {
        try {
            WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
            windowManager.removeView(v);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean addViewToWindow(View v, WindowManager.LayoutParams params) {
        try {
            if (Utils.isPermissionDenied()) {
                return false;
            }
            WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
            windowManager.addView(v, (ViewGroup.LayoutParams)params);
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Utils.removeViewFromWindow(v);
            return false;
        }
    }

    public static void updateViewLayoutInWindow(View v, WindowManager.LayoutParams params) {
        try {
            WindowManager windowManager = (WindowManager)Utils.getContext().getSystemService("window");
            windowManager.updateViewLayout(v, (ViewGroup.LayoutParams)params);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean isPermissionDenied() {
        if (Build.VERSION.SDK_INT >= 23) {
            return !Settings.canDrawOverlays((Context)Utils.getContext());
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOpsMgr = (AppOpsManager)CONTEXT.getSystemService("appops");
            try {
                int mode = appOpsMgr.checkOpNoThrow("android:system_alert_window", Process.myUid(), CONTEXT.getPackageName());
                if (mode == 2) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!Config.ifPermissionChecked()) {
            Config.setPermissionChecked();
            return true;
        }
        return false;
    }

    public static List<String> getActivities() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            PackageManager packageManager = CONTEXT.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(CONTEXT.getPackageName(), 1);
            for (ActivityInfo activity : packageInfo.activities) {
                result.add(activity.name);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        Collections.sort(result);
        return result;
    }

    public static String collectThrow(Throwable ex) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        return ((Object)writer).toString();
    }
}

