/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseArray;
import android.view.View;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.sandbox.Sandbox;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.DBFragment;
import tech.linjiang.pandora.ui.fragment.FileAttrFragment;
import tech.linjiang.pandora.ui.fragment.FileFragment;
import tech.linjiang.pandora.ui.fragment.SPFragment;
import tech.linjiang.pandora.ui.item.DBItem;
import tech.linjiang.pandora.ui.item.FileItem;
import tech.linjiang.pandora.ui.item.SPItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.SimpleTask;

public class SandboxFragment
extends BaseListFragment {
    @Override
    protected boolean enableSwipeBack() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle(R.string.pd_name_sandbox);
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                Bundle bundle = new Bundle();
                if (item instanceof DBItem) {
                    bundle.putInt("param1", ((DBItem)item).key);
                    SandboxFragment.this.launch(DBFragment.class, (String)item.data, bundle);
                } else if (item instanceof SPItem) {
                    bundle.putSerializable("param1", (Serializable)((SPItem)item).descriptor);
                    SandboxFragment.this.launch(SPFragment.class, bundle);
                } else if (item instanceof FileItem) {
                    bundle.putSerializable("param1", (Serializable)((File)item.data));
                    if (((File)item.data).isDirectory()) {
                        SandboxFragment.this.launch(FileFragment.class, bundle, 1);
                    } else {
                        SandboxFragment.this.launch(FileAttrFragment.class, bundle);
                    }
                }
            }
        });
        this.loadData();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 1) {
            this.loadData();
        }
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, List<BaseItem>>(new SimpleTask.Callback<Void, List<BaseItem>>(){

            public List<BaseItem> doInBackground(Void[] params) {
                SparseArray<String> databaseNames = Pandora.get().getDatabases().getDatabaseNames();
                ArrayList<BaseItem> data = new ArrayList<BaseItem>(databaseNames.size());
                data.add(new TitleItem(SandboxFragment.this.getString(R.string.pd_name_database)));
                for (int i = 0; i < databaseNames.size(); ++i) {
                    data.add(new DBItem((String)databaseNames.valueAt(i), databaseNames.keyAt(i)));
                }
                data.add(new TitleItem(SandboxFragment.this.getString(R.string.pd_name_sp)));
                List<File> spFiles = Pandora.get().getSharedPref().getSharedPrefDescs();
                for (int i = 0; i < spFiles.size(); ++i) {
                    data.add(new SPItem(spFiles.get(i).getName(), spFiles.get(i)));
                }
                data.add(new TitleItem(SandboxFragment.this.getString(R.string.pd_name_file)));
                List<File> descriptors = Sandbox.getRootFiles();
                for (int i = 0; i < descriptors.size(); ++i) {
                    data.add(new FileItem(descriptors.get(i)));
                }
                if (Config.getSANDBOX_DPM() && Build.VERSION.SDK_INT >= 24) {
                    data.add(new TitleItem("Device-protect-mode Files"));
                    List<File> dpm = Sandbox.getDPMFiles();
                    for (int i = 0; i < dpm.size(); ++i) {
                        data.add(new FileItem(dpm.get(i)));
                    }
                }
                return data;
            }

            @Override
            public void onPostExecute(List<BaseItem> result) {
                SandboxFragment.this.hideLoading();
                SandboxFragment.this.getAdapter().setItems(result);
            }
        }).execute(new Void[0]);
    }
}

