/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.GeneralDialog;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.EditFragment;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.ui.view.MenuRecyclerView;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class SPFragment
extends BaseListFragment {
    private File descriptor;
    private String clickKey;

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.descriptor = (File)this.getArguments().getSerializable("param1");
        this.getToolbar().setTitle((CharSequence)this.descriptor.getName());
        this.getToolbar().getMenu().add(0, 0, 0, R.string.pd_name_help).setIcon(R.drawable.pd_help).setShowAsAction(2);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getOrder() == 0) {
                    GeneralDialog.build(-1).title(R.string.pd_help_title).message(R.string.pd_help_sp).positiveButton(R.string.pd_ok).show(SPFragment.this);
                }
                return false;
            }
        });
        this.registerForContextMenu((View)this.getRecyclerView());
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof KeyValueItem) {
                    if (((KeyValueItem)item).isTitle) {
                        return;
                    }
                    SPFragment.this.clickKey = ((String[])((KeyValueItem)item).data)[0];
                    Bundle bundle = new Bundle();
                    bundle.putString("param1", ((String[])((KeyValueItem)item).data)[1]);
                    SPFragment.this.launch(EditFragment.class, bundle, 1);
                }
            }
        });
        this.loadData();
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        if (menuInfo instanceof MenuRecyclerView.RvContextMenuInfo) {
            MenuRecyclerView.RvContextMenuInfo info = (MenuRecyclerView.RvContextMenuInfo)menuInfo;
            if (this.getAdapter().getItems().get(info.position) instanceof KeyValueItem && !((KeyValueItem)this.getAdapter().getItems().get((int)info.position)).isTitle) {
                menu.add(-1, 0, 0, R.string.pd_name_copy_value);
                menu.add(-1, 0, 1, R.string.pd_name_delete_key);
            }
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        if (item.getMenuInfo() instanceof MenuRecyclerView.RvContextMenuInfo) {
            MenuRecyclerView.RvContextMenuInfo info = (MenuRecyclerView.RvContextMenuInfo)item.getMenuInfo();
            BaseItem baseItem = this.getAdapter().getItems().get(info.position);
            if (baseItem instanceof KeyValueItem) {
                KeyValueItem keyValueItem = (KeyValueItem)baseItem;
                if (keyValueItem.isTitle) {
                    return true;
                }
                if (item.getOrder() == 0) {
                    Utils.copy2ClipBoard("KEY :: " + ((String[])keyValueItem.data)[0] + "\nVALUE  :: " + ((String[])keyValueItem.data)[1]);
                    return true;
                }
                if (item.getOrder() == 1) {
                    String clickedKey = ((String[])keyValueItem.data)[0];
                    Pandora.get().getSharedPref().removeSharedPrefKey(this.descriptor, clickedKey);
                    this.getAdapter().removeItem(info.position);
                    return true;
                }
            }
        }
        return super.onContextItemSelected(item);
    }

    private void loadData() {
        Map<String, String> contents = Pandora.get().getSharedPref().getSharedPrefContent(this.descriptor);
        if (contents != null && !contents.isEmpty()) {
            ArrayList<BaseItem> data = new ArrayList<BaseItem>();
            data.add(new TitleItem(String.format(Locale.getDefault(), "%d ITEMS", contents.size())));
            data.add(new KeyValueItem(new String[]{"KEY", "VALUE"}, true));
            for (Map.Entry<String, String> entry : contents.entrySet()) {
                data.add(new KeyValueItem(new String[]{entry.getKey(), entry.getValue()}, false, true));
            }
            this.getAdapter().setItems(data);
        } else {
            this.showError(null);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            final String value = data.getStringExtra("value");
            if (!TextUtils.isEmpty((CharSequence)this.clickKey)) {
                new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

                    public String doInBackground(Void[] params) {
                        return Pandora.get().getSharedPref().updateSharedPref(SPFragment.this.descriptor, SPFragment.this.clickKey, value);
                    }

                    @Override
                    public void onPostExecute(String result) {
                        SPFragment.this.hideLoading();
                        if (TextUtils.isEmpty((CharSequence)result)) {
                            Utils.toast(R.string.pd_success);
                        } else {
                            Utils.toast(result);
                        }
                        SPFragment.this.loadData();
                    }
                }).execute(new Void[0]);
                this.showLoading();
            }
        }
    }
}

