/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import java.io.File;
import java.util.ArrayList;
import tech.linjiang.pandora.cache.Crash;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.item.ExceptionItem;
import tech.linjiang.pandora.ui.item.KeyValueItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class CrashStackFragment
extends BaseListFragment {
    private StringBuilder formatText = new StringBuilder();

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Crash crash = (Crash)this.getArguments().getSerializable("param1");
        String time = Utils.millis2String(crash.createTime, Utils.NO_MILLIS);
        this.getToolbar().setTitle((CharSequence)time);
        this.getToolbar().getMenu().add(-1, 0, 0, R.string.pd_name_copy_value);
        this.getToolbar().getMenu().add(-1, 0, 1, R.string.pd_name_share);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getOrder() == 0) {
                    Utils.copy2ClipBoard(CrashStackFragment.this.formatText.toString());
                } else if (item.getOrder() == 1) {
                    CrashStackFragment.this.saveAsFileAndShare(CrashStackFragment.this.formatText.toString());
                }
                return true;
            }
        });
        this.formatText.append("time: ").append(time).append("\n");
        ArrayList<BaseItem> items = new ArrayList<BaseItem>();
        this.formatText.append(crash.stack).append("\n");
        items.add(new ExceptionItem(crash.stack));
        this.formatText.append("duration: ").append(Utils.formatDuration(crash.createTime - crash.startTime)).append("\n");
        items.add(new KeyValueItem(new String[]{"duration", Utils.formatDuration(crash.createTime - crash.startTime)}, false));
        this.formatText.append("versionCode: ").append(String.valueOf(crash.versionCode)).append("\n");
        items.add(new KeyValueItem(new String[]{"versionCode", String.valueOf(crash.versionCode)}, false));
        this.formatText.append("versionName: ").append(String.valueOf(crash.versionName)).append("\n");
        items.add(new KeyValueItem(new String[]{"versionName", String.valueOf(crash.versionName)}, false));
        this.formatText.append("androidSDK: ").append(String.valueOf(crash.systemSDK)).append("\n");
        items.add(new KeyValueItem(new String[]{"androidSDK", String.valueOf(crash.systemSDK)}, false));
        this.formatText.append("androidVersion: ").append(String.valueOf(crash.systemVersion)).append("\n");
        items.add(new KeyValueItem(new String[]{"androidVersion", String.valueOf(crash.systemVersion)}, false));
        this.formatText.append("rom: ").append(String.valueOf(crash.rom)).append("\n");
        items.add(new KeyValueItem(new String[]{"rom", String.valueOf(crash.rom)}, false));
        this.formatText.append("cpuABI: ").append(String.valueOf(crash.cpuABI)).append("\n");
        items.add(new KeyValueItem(new String[]{"cpuABI", String.valueOf(crash.cpuABI)}, false));
        this.formatText.append("phoneName: ").append(String.valueOf(crash.phoneName)).append("\n");
        items.add(new KeyValueItem(new String[]{"phoneName", String.valueOf(crash.phoneName)}, false));
        this.formatText.append("locale: ").append(String.valueOf(crash.locale)).append("\n");
        items.add(new KeyValueItem(new String[]{"locale", String.valueOf(crash.locale)}, false));
        this.getAdapter().setItems(items);
    }

    private void saveAsFileAndShare(String msg) {
        this.showLoading();
        new SimpleTask<String, Intent>(new SimpleTask.Callback<String, Intent>(){

            public Intent doInBackground(String[] params) {
                String path = FileUtil.saveFile(params[0].getBytes(), "crash", "txt");
                String newPath = FileUtil.fileCopy2Tmp(new File(path));
                if (!TextUtils.isEmpty((CharSequence)newPath)) {
                    return FileUtil.getFileIntent(newPath);
                }
                return null;
            }

            @Override
            public void onPostExecute(Intent result) {
                CrashStackFragment.this.hideLoading();
                if (result != null) {
                    try {
                        CrashStackFragment.this.startActivity(result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Utils.toast(t.getMessage());
                    }
                } else {
                    Utils.toast(R.string.pd_failed);
                }
            }
        }).execute(new String[]{msg});
    }
}

