/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;
import androidx.core.view.ViewCompat;
import tech.linjiang.pandora.util.Config;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class GridLineView
extends View {
    private int LINE_INTERVAL;
    private Paint paint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(0x30000000);
            this.setStrokeWidth(1.0f);
        }
    };

    public GridLineView(Context context) {
        super(context);
    }

    private void open() {
        this.LINE_INTERVAL = ViewKnife.dip2px(Config.getUI_GRID_INTERVAL());
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.width = -1;
        params.height = -1;
        params.type = Build.VERSION.SDK_INT < 26 ? 2003 : 2038;
        params.flags = 24;
        params.format = -3;
        Utils.addViewToWindow(this, params);
    }

    private void close() {
        Utils.removeViewFromWindow(this);
    }

    public void toggle() {
        if (this.isOpen()) {
            this.close();
        } else {
            this.open();
        }
    }

    public boolean isOpen() {
        return ViewCompat.isAttachedToWindow((View)this);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int startX = 0; startX < this.getMeasuredWidth(); startX += this.LINE_INTERVAL) {
            canvas.drawLine((float)startX, 0.0f, (float)startX, (float)this.getMeasuredHeight(), this.paint);
        }
        for (int startY = 0; startY < this.getMeasuredHeight(); startY += this.LINE_INTERVAL) {
            canvas.drawLine(0.0f, (float)startY, (float)this.getMeasuredWidth(), (float)startY, this.paint);
        }
    }
}

