/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.GeneralDialog;
import tech.linjiang.pandora.ui.fragment.BaseListFragment;
import tech.linjiang.pandora.ui.fragment.EditFragment;
import tech.linjiang.pandora.ui.item.ContentItem;
import tech.linjiang.pandora.ui.item.TitleItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.util.FileUtil;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class FileAttrFragment
extends BaseListFragment {
    private File file;

    @Override
    protected boolean needDefaultDivider() {
        return false;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.file = (File)this.getArguments().getSerializable("param1");
        if (!this.file.exists()) {
            this.showError(null);
            return;
        }
        this.getToolbar().setTitle((CharSequence)this.file.getName());
        this.getToolbar().getMenu().add(-1, 0, 0, R.string.pd_name_open);
        this.getToolbar().getMenu().add(-1, 0, 1, R.string.pd_name_open_as_text);
        this.getToolbar().getMenu().add(-1, 0, 2, R.string.pd_name_rename);
        this.getToolbar().getMenu().add(-1, 0, 3, R.string.pd_name_delete_key);
        this.getToolbar().getMenu().add(-1, 0, 4, R.string.pd_name_copy_to_sdcard);
        this.getToolbar().getMenu().add(0, 0, 5, R.string.pd_name_help).setIcon(R.drawable.pd_help).setShowAsAction(2);
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getOrder() == 0) {
                    FileAttrFragment.this.tryOpen();
                } else if (item.getOrder() == 1) {
                    FileAttrFragment.this.tryOpenAsText();
                } else if (item.getOrder() == 2) {
                    Bundle bundle = new Bundle();
                    bundle.putString("param1", FileAttrFragment.this.file.getName());
                    FileAttrFragment.this.launch(EditFragment.class, bundle, 1);
                } else if (item.getOrder() == 3) {
                    FileAttrFragment.this.tryDel();
                } else if (item.getOrder() == 4) {
                    FileAttrFragment.this.copyTo();
                } else if (item.getOrder() == 5) {
                    GeneralDialog.build(-1).title(R.string.pd_help_title).message(R.string.pd_help_file).positiveButton(R.string.pd_ok).show(FileAttrFragment.this);
                }
                return true;
            }
        });
        this.getAdapter().setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof ContentItem) {
                    Utils.copy2ClipBoard((String)item.data);
                }
            }
        });
        this.loadData();
    }

    private void loadData() {
        ArrayList<BaseItem> data = new ArrayList<BaseItem>();
        data.add(new TitleItem("NAME"));
        data.add(new ContentItem(this.file.getName()));
        data.add(new TitleItem("SIZE"));
        data.add(new ContentItem(FileUtil.fileSize(this.file)));
        data.add(new TitleItem("MODIFIED"));
        data.add(new ContentItem(Utils.millis2String(this.file.lastModified(), Utils.NO_MILLIS)));
        data.add(new TitleItem("AUTHORITY"));
        data.add(new ContentItem(String.format("X: %b    W: %b    R: %b", this.file.canExecute(), this.file.canWrite(), this.file.canRead())));
        data.add(new TitleItem("HASH"));
        data.add(new ContentItem(FileUtil.bytesToHexString(String.valueOf(this.file.hashCode()).getBytes())));
        data.add(new TitleItem("TYPE"));
        String type = FileUtil.getFileType(this.file.getPath());
        data.add(new ContentItem(TextUtils.isEmpty((CharSequence)type) ? "other" : type));
        data.add(new TitleItem("PATH"));
        data.add(new ContentItem(this.file.getPath()));
        this.getAdapter().setItems(data);
        new SimpleTask<File, List<BaseItem>>(new SimpleTask.Callback<File, List<BaseItem>>(){

            public List<BaseItem> doInBackground(File[] params) {
                ArrayList<BaseItem> data = new ArrayList<BaseItem>();
                data.add(new TitleItem("MD5"));
                data.add(new ContentItem(FileUtil.md5File(params[0])));
                return data;
            }

            @Override
            public void onPostExecute(List<BaseItem> result) {
                if (Utils.isNotEmpty(result)) {
                    FileAttrFragment.this.getAdapter().insertItems(result, 10);
                }
            }
        }).execute(new File[]{this.file});
    }

    private void copyTo() {
        new SimpleTask<File, String>(new SimpleTask.Callback<File, String>(){

            public String doInBackground(File[] params) {
                String result = FileUtil.fileCopy2Tmp(params[0]);
                return result;
            }

            @Override
            public void onPostExecute(String result) {
                FileAttrFragment.this.hideLoading();
                GeneralDialog.build(-1).title(R.string.pd_success).message(R.string.pd_copy_hint, result).positiveButton(R.string.pd_ok).show(FileAttrFragment.this);
            }
        }).execute(new File[]{this.file});
        this.showLoading();
    }

    private void tryOpen() {
        new SimpleTask<File, Intent>(new SimpleTask.Callback<File, Intent>(){

            public Intent doInBackground(File[] params) {
                String result = FileUtil.fileCopy2Tmp(params[0]);
                if (!TextUtils.isEmpty((CharSequence)result)) {
                    return FileUtil.getFileIntent(result);
                }
                return null;
            }

            @Override
            public void onPostExecute(Intent result) {
                FileAttrFragment.this.hideLoading();
                if (result != null) {
                    try {
                        FileAttrFragment.this.startActivity(result);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Utils.toast(t.getMessage());
                    }
                } else {
                    Utils.toast(R.string.pd_not_support);
                }
            }
        }).execute(new File[]{this.file});
        this.showLoading();
    }

    private void tryOpenAsText() {
        new SimpleTask<File, List<String>>(new SimpleTask.Callback<File, List<String>>(){

            public List<String> doInBackground(File[] params) {
                return FileUtil.readAsPlainText(params[0]);
            }

            @Override
            public void onPostExecute(List<String> result) {
                FileAttrFragment.this.hideLoading();
                if (result != null) {
                    ArrayList<ContentItem> items = new ArrayList<ContentItem>();
                    for (int i = 0; i < result.size(); ++i) {
                        items.add(new ContentItem(result.get(i)));
                    }
                    FileAttrFragment.this.getAdapter().setItems(items);
                } else {
                    Utils.toast(R.string.pd_not_support);
                }
            }
        }).execute(new File[]{this.file});
        this.showLoading();
    }

    private void tryDel() {
        new SimpleTask<File, Boolean>(new SimpleTask.Callback<File, Boolean>(){

            public Boolean doInBackground(File[] params) {
                return params[0].delete();
            }

            @Override
            public void onPostExecute(Boolean result) {
                FileAttrFragment.this.hideLoading();
                Utils.toast(result != false ? R.string.pd_success : R.string.pd_failed);
                FileAttrFragment.this.getTargetFragment().onActivityResult(FileAttrFragment.this.getTargetRequestCode(), -1, null);
                FileAttrFragment.this.onBackPressed();
            }
        }).execute(new File[]{this.file});
        this.showLoading();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            final String value = data.getStringExtra("value");
            new SimpleTask<Void, Boolean>(new SimpleTask.Callback<Void, Boolean>(){

                public Boolean doInBackground(Void[] params) {
                    return FileUtil.renameTo(FileAttrFragment.this.file, value);
                }

                @Override
                public void onPostExecute(Boolean result) {
                    FileAttrFragment.this.hideLoading();
                    Utils.toast(result != false ? R.string.pd_success : R.string.pd_failed);
                    FileAttrFragment.this.loadData();
                    FileAttrFragment.this.getTargetFragment().onActivityResult(FileAttrFragment.this.getTargetRequestCode(), -1, null);
                }
            }).execute(new Void[0]);
            this.showLoading();
        }
    }
}

