/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import java.io.Serializable;
import java.util.ArrayList;
import tech.linjiang.pandora.Pandora;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.database.DatabaseResult;
import tech.linjiang.pandora.ui.connector.EventCallback;
import tech.linjiang.pandora.ui.connector.SimpleOnActionExpandListener;
import tech.linjiang.pandora.ui.connector.SimpleOnQueryTextListener;
import tech.linjiang.pandora.ui.fragment.AddRowFragment;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.ui.fragment.EditFragment;
import tech.linjiang.pandora.ui.item.GridItem;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.GridDividerDecoration;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.ui.view.MenuRecyclerView;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;
import tech.linjiang.pandora.util.ViewKnife;

public class TableFragment
extends BaseFragment {
    private UniversalAdapter adapter;
    private MenuRecyclerView recyclerView;
    private int key;
    private boolean mode;
    private String table;
    private String primaryKey;
    private GridItem clickedItem;
    private String realTimeQueryCondition;
    private EventCallback eventCallback = new EventCallback(){

        @Override
        public void onComplete() {
            TableFragment.this.loadData(TableFragment.this.realTimeQueryCondition);
        }
    };

    @Override
    protected int getLayoutId() {
        return 0;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.key = this.getArguments().getInt("param1");
        this.table = this.getArguments().getString("param2");
        this.mode = this.getArguments().getBoolean("param3");
        this.primaryKey = Pandora.get().getDatabases().getPrimaryKey(this.key, this.table);
    }

    @Override
    protected View getLayoutView() {
        HorizontalScrollView scrollView = new HorizontalScrollView(this.getContext());
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        scrollView.setFillViewport(true);
        this.recyclerView = new MenuRecyclerView(this.getContext());
        this.recyclerView.setBackgroundColor(ViewKnife.getColor(R.color.pd_main_bg));
        scrollView.addView((View)this.recyclerView, params);
        return scrollView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (!this.mode) {
            this.initMenu();
        }
        this.adapter = new UniversalAdapter();
        this.registerForContextMenu((View)this.recyclerView);
        this.recyclerView.addItemDecoration(new GridDividerDecoration.Builder().setColor(ViewKnife.getColor(R.color.pd_divider_light)).setThickness(ViewKnife.dip2px(1.0f)).build());
        this.recyclerView.setAdapter(this.adapter);
        this.adapter.setListener(new UniversalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position, BaseItem item) {
                if (item instanceof GridItem) {
                    if (TableFragment.this.mode) {
                        return;
                    }
                    if (!((GridItem)item).isEnable()) {
                        return;
                    }
                    TableFragment.this.clickedItem = (GridItem)item;
                    Bundle bundle = new Bundle();
                    bundle.putString("param1", (String)((GridItem)item).data);
                    TableFragment.this.launch(EditFragment.class, bundle, 1);
                }
            }
        });
        this.adapter.setLongClickListener(new UniversalAdapter.OnItemLongClickListener(){

            @Override
            public boolean onItemLongClick(int position, BaseItem item) {
                return item instanceof GridItem && !((GridItem)item).isEnable();
            }
        });
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
    }

    @Override
    protected void onViewEnterAnimEnd(View container) {
        this.loadData(null);
    }

    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        menu.add(-1, R.id.pd_menu_id_1, 0, (CharSequence)"copy value");
        menu.add(-1, R.id.pd_menu_id_2, 1, (CharSequence)"delete row");
    }

    public boolean onContextItemSelected(MenuItem item) {
        MenuRecyclerView.RvContextMenuInfo info = (MenuRecyclerView.RvContextMenuInfo)item.getMenuInfo();
        BaseItem gridItem = this.adapter.getItems().get(info.position);
        if (gridItem instanceof GridItem) {
            if (item.getItemId() == R.id.pd_menu_id_1) {
                Utils.copy2ClipBoard((String)gridItem.data);
                return true;
            }
            if (item.getItemId() == R.id.pd_menu_id_2) {
                String pkValue = ((GridItem)gridItem).primaryKeyValue;
                this.delete(pkValue);
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    private void initMenu() {
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_1, 0, (CharSequence)"search").setActionView((View)new SearchView(this.getContext())).setIcon(R.drawable.pd_search).setShowAsAction(8);
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_2, 1, (CharSequence)"info");
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_3, 2, (CharSequence)"add");
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_4, 3, (CharSequence)"delete all");
        MenuItem menuItem = this.getToolbar().getMenu().findItem(R.id.pd_menu_id_1);
        SearchView searchView = (SearchView)menuItem.getActionView();
        searchView.setQueryHint((CharSequence)ViewKnife.getString(R.string.pd_search_hint));
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)new SimpleOnQueryTextListener(){

            @Override
            public boolean onQueryTextSubmit(String query) {
                TableFragment.this.closeSoftInput();
                TableFragment.this.realTimeQueryCondition = query;
                TableFragment.this.loadData(query);
                return true;
            }
        });
        SimpleOnActionExpandListener.bind(menuItem, new SimpleOnActionExpandListener(){

            @Override
            public boolean onMenuItemActionCollapse(MenuItem item) {
                if (!TextUtils.isEmpty((CharSequence)TableFragment.this.realTimeQueryCondition)) {
                    TableFragment.this.realTimeQueryCondition = null;
                    TableFragment.this.loadData(null);
                }
                return true;
            }
        });
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getItemId() == R.id.pd_menu_id_2) {
                    Bundle bundle = new Bundle();
                    bundle.putInt("param1", TableFragment.this.key);
                    bundle.putString("param2", TableFragment.this.table);
                    bundle.putBoolean("param3", true);
                    TableFragment.this.launch(TableFragment.class, bundle);
                } else if (item.getItemId() == R.id.pd_menu_id_3) {
                    Bundle bundle = new Bundle();
                    bundle.putInt("param1", TableFragment.this.key);
                    bundle.putString("param2", TableFragment.this.table);
                    bundle.putSerializable("param3", (Serializable)TableFragment.this.eventCallback);
                    TableFragment.this.launch(AddRowFragment.class, bundle);
                } else if (item.getItemId() == R.id.pd_menu_id_4) {
                    TableFragment.this.delete(null);
                }
                TableFragment.this.closeSoftInput();
                return true;
            }
        });
    }

    private void loadData(final String condition) {
        this.adapter.clearItems();
        this.showLoading();
        new SimpleTask<Void, DatabaseResult>(new SimpleTask.Callback<Void, DatabaseResult>(){

            public DatabaseResult doInBackground(Void[] params) {
                if (TableFragment.this.mode) {
                    return Pandora.get().getDatabases().getTableInfo(TableFragment.this.key, TableFragment.this.table);
                }
                return Pandora.get().getDatabases().query(TableFragment.this.key, TableFragment.this.table, condition);
            }

            @Override
            public void onPostExecute(DatabaseResult result) {
                ArrayList<GridItem> data = new ArrayList<GridItem>();
                if (result.sqlError == null) {
                    int i;
                    TableFragment.this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(TableFragment.this.getContext(), result.columnNames.size()));
                    int pkIndex = 0;
                    for (i = 0; i < result.columnNames.size(); ++i) {
                        data.add(new GridItem(result.columnNames.get(i), true));
                        if (!TextUtils.equals((CharSequence)result.columnNames.get(i), (CharSequence)TableFragment.this.primaryKey)) continue;
                        pkIndex = i;
                    }
                    for (i = 0; i < result.values.size(); ++i) {
                        for (int j = 0; j < result.values.get(i).size(); ++j) {
                            GridItem item = new GridItem(result.values.get(i).get(j), result.values.get(i).get(pkIndex), result.columnNames.get(j));
                            if (!TableFragment.this.mode && pkIndex == j) {
                                item.setIsPrimaryKey();
                            }
                            data.add(item);
                        }
                    }
                    TableFragment.this.adapter.setItems(data);
                } else {
                    Utils.toast(result.sqlError.message);
                }
                TableFragment.this.hideLoading();
            }
        }).execute(new Void[0]);
    }

    private void delete(final String pkValue) {
        this.showLoading();
        new SimpleTask<Void, DatabaseResult>(new SimpleTask.Callback<Void, DatabaseResult>(){

            public DatabaseResult doInBackground(Void[] params) {
                return Pandora.get().getDatabases().delete(TableFragment.this.key, TableFragment.this.table, TextUtils.isEmpty((CharSequence)pkValue) ? null : TableFragment.this.primaryKey, TextUtils.isEmpty((CharSequence)pkValue) ? null : pkValue);
            }

            @Override
            public void onPostExecute(DatabaseResult result) {
                TableFragment.this.hideLoading();
                if (result.sqlError != null) {
                    Utils.toast(result.sqlError.message);
                } else {
                    TableFragment.this.realTimeQueryCondition = null;
                    Utils.toast(R.string.pd_success);
                    TableFragment.this.loadData(null);
                }
            }
        }).execute(new Void[0]);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1 && resultCode == -1) {
            final String value = data.getStringExtra("value");
            this.showLoading();
            new SimpleTask<Void, DatabaseResult>(new SimpleTask.Callback<Void, DatabaseResult>(){

                public DatabaseResult doInBackground(Void[] params) {
                    return Pandora.get().getDatabases().update(TableFragment.this.key, TableFragment.this.table, TableFragment.this.primaryKey, ((TableFragment)TableFragment.this).clickedItem.primaryKeyValue, ((TableFragment)TableFragment.this).clickedItem.columnName, value);
                }

                @Override
                public void onPostExecute(DatabaseResult result) {
                    TableFragment.this.hideLoading();
                    Utils.toast(result.sqlError != null ? R.string.pd_failed : R.string.pd_success);
                    TableFragment.this.loadData(TableFragment.this.realTimeQueryCondition);
                }
            }).execute(new Void[0]);
        }
    }
}

