/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.model.Content;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class NetContentFragment
extends BaseFragment {
    private boolean showResponse;
    private long id;
    private String contentType;
    private String originContent;
    private WebView webView;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.showResponse = this.getArguments().getBoolean("param1", true);
        this.id = this.getArguments().getLong("param2");
        this.contentType = this.getArguments().getString("param3");
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected View getLayoutView() {
        this.webView = new WebView(this.getContext());
        this.webView.getSettings().setDefaultTextEncodingName("UTF-8");
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                NetContentFragment.this.loadData();
            }
        });
        return this.webView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Content");
        this.webView.loadUrl("file:///android_asset/tmp_json.html");
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
    }

    @Override
    protected int getLayoutId() {
        return 0;
    }

    private void setSearchView() {
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_1, 0, (CharSequence)"copy");
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_3, 2, (CharSequence)"share");
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getItemId() == R.id.pd_menu_id_1) {
                    Utils.copy2ClipBoard(NetContentFragment.this.originContent);
                } else if (item.getItemId() == R.id.pd_menu_id_3) {
                    Utils.shareText(NetContentFragment.this.originContent);
                }
                return true;
            }
        });
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

            public String doInBackground(Void[] params) {
                Content content = CacheDbHelper.getContent(NetContentFragment.this.id);
                String result = NetContentFragment.this.showResponse ? content.responseBody : content.requestBody;
                return result;
            }

            @Override
            public void onPostExecute(String result) {
                Log.d((String)NetContentFragment.this.TAG, (String)("onPostExecute: " + result));
                NetContentFragment.this.hideLoading();
                if (TextUtils.isEmpty((CharSequence)result)) {
                    Utils.toast("empty");
                    return;
                }
                NetContentFragment.this.setSearchView();
                NetContentFragment.this.originContent = result;
                NetContentFragment.this.webView.setWebViewClient(null);
                if (NetContentFragment.this.contentType != null && NetContentFragment.this.contentType.toLowerCase().contains("json")) {
                    result = result.replaceAll("\n", "");
                    result = result.replace("\\", "\\\\");
                    result = result.replace("'", "\\'");
                    if (Build.VERSION.SDK_INT < 19) {
                        NetContentFragment.this.webView.loadUrl(String.format("javascript:showJson('%s')", result));
                    } else {
                        NetContentFragment.this.webView.evaluateJavascript(String.format("showJson('%s')", result), null);
                    }
                } else {
                    NetContentFragment.this.webView.loadDataWithBaseURL(null, result, NetContentFragment.this.decideMimeType(), "utf-8", null);
                }
            }
        }).execute(new Void[0]);
    }

    private String decideMimeType() {
        if (this.contentType != null && this.contentType.toLowerCase().contains("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
}

