/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.fragment;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import java.net.URLDecoder;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.network.CacheDbHelper;
import tech.linjiang.pandora.network.model.Content;
import tech.linjiang.pandora.ui.fragment.BaseFragment;
import tech.linjiang.pandora.util.SimpleTask;
import tech.linjiang.pandora.util.Utils;

public class NetContentFragment
extends BaseFragment {
    private boolean showResponse;
    private long id;
    private String contentType;
    private String originContent;
    private WebView webView;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.showResponse = this.getArguments().getBoolean("param1", true);
        this.id = this.getArguments().getLong("param2");
        this.contentType = this.getArguments().getString("param3");
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected View getLayoutView() {
        this.webView = new WebView(this.getContext());
        this.webView.getSettings().setDefaultTextEncodingName("UTF-8");
        this.webView.getSettings().setJavaScriptEnabled(true);
        return this.webView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getToolbar().setTitle((CharSequence)"Content");
    }

    @Override
    protected void onViewEnterAnimEnd(View container) {
        this.loadData();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.closeSoftInput();
    }

    @Override
    protected int getLayoutId() {
        return 0;
    }

    private void setSearchView() {
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_1, 0, (CharSequence)"copy");
        this.getToolbar().getMenu().add(-1, R.id.pd_menu_id_3, 2, (CharSequence)"share");
        this.getToolbar().setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (item.getItemId() == R.id.pd_menu_id_1) {
                    Utils.copy2ClipBoard(NetContentFragment.this.originContent);
                } else if (item.getItemId() == R.id.pd_menu_id_3) {
                    Utils.shareText(NetContentFragment.this.originContent);
                }
                return true;
            }
        });
    }

    private void loadData() {
        this.showLoading();
        new SimpleTask<Void, String>(new SimpleTask.Callback<Void, String>(){

            public String doInBackground(Void[] params) {
                Content content = CacheDbHelper.getContent(NetContentFragment.this.id);
                String result = NetContentFragment.this.showResponse ? content.responseBody : content.requestBody;
                try {
                    return URLDecoder.decode(result, "utf-8");
                }
                catch (Exception e) {
                    return result;
                }
            }

            @Override
            public void onPostExecute(String result) {
                NetContentFragment.this.hideLoading();
                NetContentFragment.this.setSearchView();
                NetContentFragment.this.originContent = result;
                if (NetContentFragment.this.contentType.toLowerCase().contains("json")) {
                    result = "<!DOCTYPE html>\n<html>\n<head>\n    <meta charset=utf-8>\n    <meta name=viewport content=\"width=device-width\">\n    <script type=\"text/javascript\">\n    function output(content) {\n        document.body.appendChild(document.createElement('pre')).innerHTML = content;\n    }\n    function start() {\n        var obj = \n" + result + ";\n        var str = JSON.stringify(obj, undefined, 4);\n        output(str);\n    }\n    </script>\n</head>\n<body onLoad=\"javascript:start();\">\n</body>\n</html>";
                }
                NetContentFragment.this.webView.loadData(result, NetContentFragment.this.decideMimeType(), "utf-8");
            }
        }).execute(new Void[0]);
    }

    private String decideMimeType() {
        if (this.contentType.toLowerCase().contains("xml")) {
            return "text/xml";
        }
        return "text/html";
    }
}

