/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.inspector.canvas;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import tech.linjiang.pandora.util.ViewKnife;

public class GridCanvas {
    private static final int LINE_INTERVAL = ViewKnife.dip2px(5.0f);
    private View container;
    private Paint paint = new Paint(){
        {
            this.setAntiAlias(true);
            this.setColor(-11184811);
            this.setStrokeWidth(1.0f);
        }
    };

    public GridCanvas(View container) {
        this.container = container;
    }

    private int getMeasuredWidth() {
        return this.container.getMeasuredWidth();
    }

    private int getMeasuredHeight() {
        return this.container.getMeasuredHeight();
    }

    public void draw(Canvas canvas, float alpha) {
        canvas.save();
        this.paint.setAlpha((int)(255.0f * alpha));
        for (int startX = 0; startX < this.getMeasuredWidth(); startX += LINE_INTERVAL) {
            canvas.drawLine((float)startX, 0.0f, (float)startX, (float)this.getMeasuredHeight(), this.paint);
        }
        for (int startY = 0; startY < this.getMeasuredHeight(); startY += LINE_INTERVAL) {
            canvas.drawLine(0.0f, (float)startY, (float)this.getMeasuredWidth(), (float)startY, this.paint);
        }
        canvas.restore();
    }
}

