/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.ui.item;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.core.R;
import tech.linjiang.pandora.ui.recyclerview.BaseItem;
import tech.linjiang.pandora.ui.recyclerview.UniversalAdapter;
import tech.linjiang.pandora.ui.view.TreeNodeLayout;
import tech.linjiang.pandora.util.ViewKnife;

public class HierarchyItem
extends BaseItem<View>
implements View.OnClickListener {
    public boolean isTarget;
    public boolean isExpand;
    public int layerCount;
    public int sysLayerCount;
    private View.OnClickListener childClickListener;
    private View itemView;

    public static HierarchyItem createRoot(View data, View.OnClickListener childClickListener) {
        HierarchyItem hierarchyItem = new HierarchyItem(data, 0);
        hierarchyItem.childClickListener = childClickListener;
        return hierarchyItem;
    }

    HierarchyItem(View data, int layerCount) {
        super(data);
        this.layerCount = layerCount;
    }

    public boolean isGroup() {
        return this.data instanceof ViewGroup;
    }

    public int getChildCount() {
        ViewGroup group = (ViewGroup)this.data;
        return group.getChildCount();
    }

    public List<HierarchyItem> assembleChildren() {
        ViewGroup group = (ViewGroup)this.data;
        ArrayList<HierarchyItem> result = new ArrayList<HierarchyItem>();
        int newLayerCount = this.layerCount + 1;
        for (int i = 0; i < group.getChildCount(); ++i) {
            HierarchyItem item = new HierarchyItem(group.getChildAt(i), newLayerCount);
            item.sysLayerCount = this.sysLayerCount;
            item.childClickListener = this.childClickListener;
            result.add(item);
        }
        return result;
    }

    private boolean isVisible() {
        return ((View)this.data).getVisibility() == 0;
    }

    public void toggleIcon() {
        boolean bl = this.isExpand = !this.isExpand;
        if (this.itemView != null && this.isGroup() && this.getChildCount() > 0) {
            ((TextView)this.itemView.findViewById(R.id.view_name_title)).setCompoundDrawablesWithIntrinsicBounds(ViewKnife.getDrawable(this.isExpand ? R.drawable.pd_expand : R.drawable.pd_collapse), null, null, null);
        }
    }

    @Override
    public void onBinding(int position, UniversalAdapter.ViewPool pool, View data) {
        this.itemView = pool.itemView;
        int color2 = this.isVisible() ? (this.isTarget ? ViewKnife.getColor(R.color.pd_blue) : -16777216) : -6974059;
        pool.setText(R.id.view_name_title, this.viewToTitleString(data)).setTextColor(R.id.view_name_title, color2).setText(R.id.view_name_subtitle, this.viewToSummaryString(data)).setTextColor(R.id.view_name_subtitle, color2);
        TreeNodeLayout layout2 = (TreeNodeLayout)((Object)pool.getView(R.id.view_name_wrapper));
        layout2.setLayerCount(this.layerCount, this.sysLayerCount);
        if (this.isGroup() && this.getChildCount() > 0) {
            ((TextView)pool.getView(R.id.view_name_title)).setCompoundDrawablesWithIntrinsicBounds(ViewKnife.getDrawable(this.isExpand ? R.drawable.pd_expand : R.drawable.pd_collapse), null, null, null);
        } else {
            ((TextView)pool.getView(R.id.view_name_title)).setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        }
        pool.getView(R.id.view_name_more).setOnClickListener((View.OnClickListener)this);
        pool.getView(R.id.view_name_more).setTag((Object)position);
    }

    @Override
    public int getLayout() {
        return R.layout.pd_item_hierachy;
    }

    private String viewToTitleString(View view) {
        if (this.isGroup()) {
            return view.getClass().getSimpleName() + " (" + this.getChildCount() + ")";
        }
        return view.getClass().getSimpleName();
    }

    private String viewToSummaryString(View view) {
        return "{(" + view.getLeft() + ',' + view.getTop() + "), (" + view.getRight() + ',' + view.getBottom() + ")} " + ViewKnife.getIdString(view);
    }

    public void onClick(View v) {
        if (this.childClickListener != null) {
            this.childClickListener.onClick(v);
        }
    }
}

