/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.util.Locale;
import tech.linjiang.pandora.util.Utils;

public class ViewKnife {
    public static Resources getResouces() {
        return Utils.getContext().getResources();
    }

    public static int getColor(@ColorRes int color2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return ViewKnife.getResouces().getColor(color2, Utils.getContext().getTheme());
        }
        return ViewKnife.getResouces().getColor(color2);
    }

    public static float getDimen(@DimenRes int dimen) {
        return ViewKnife.getResouces().getDimension(dimen);
    }

    public static String getString(@StringRes int res) {
        return ViewKnife.getResouces().getString(res);
    }

    public static Drawable getDrawable(@DrawableRes int res) {
        return ContextCompat.getDrawable((Context)Utils.getContext(), (int)res);
    }

    public static int dip2px(float dipValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2dip(float pxValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static String px2dipStr(float pxValue) {
        return String.format(Locale.getDefault(), "%ddp", ViewKnife.px2dip(pxValue));
    }

    public static void removeSelf(View view) {
        if (view != null && view.getParent() != null && view.getParent() instanceof ViewGroup) {
            ((ViewGroup)view.getParent()).removeView(view);
        }
    }

    public static float getTextHeight(Paint paint, String text) {
        Rect rect = new Rect();
        paint.getTextBounds(text, 0, text.length(), rect);
        return rect.height();
    }

    public static float getTextWidth(Paint paint, String text) {
        return paint.measureText(text);
    }

    public static void setStatusBarColor(@NonNull Window window, int color2) {
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(color2);
        }
    }

    public static void transStatusBar(@NonNull Window window) {
        if (Build.VERSION.SDK_INT >= 21) {
            View view = window.getDecorView();
            if (view != null) {
                view.setSystemUiVisibility(view.getSystemUiVisibility() | 0x500);
            }
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
        }
    }

    public static int getStatusHeight() {
        int height = 0;
        int resourceId = ViewKnife.getResouces().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0 && (height = ViewKnife.getResouces().getDimensionPixelSize(resourceId)) > 0) {
            return height;
        }
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int tmpHeight = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            height = ViewKnife.getResouces().getDimensionPixelSize(tmpHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return height;
    }

    public static String getIdString(View view) {
        StringBuilder out = new StringBuilder();
        int id2 = view.getId();
        if (id2 != -1 && !ViewKnife.isViewIdGenerated(id2)) {
            try {
                String pkgName;
                switch (id2 & 0xFF000000) {
                    case 0x7F000000: {
                        pkgName = "app";
                        break;
                    }
                    case 0x1000000: {
                        pkgName = "android";
                        break;
                    }
                    default: {
                        pkgName = ViewKnife.getResouces().getResourcePackageName(id2);
                    }
                }
                String typename = ViewKnife.getResouces().getResourceTypeName(id2);
                String entryName = ViewKnife.getResouces().getResourceEntryName(id2);
                out.append(pkgName);
                out.append(":");
                out.append(typename);
                out.append("/");
                out.append(entryName);
            }
            catch (Resources.NotFoundException e) {
                e.printStackTrace();
                out.append(Integer.toHexString(id2));
            }
        } else {
            out.append("NO_ID");
        }
        return out.toString();
    }

    private static boolean isViewIdGenerated(int id2) {
        return (id2 & 0xFF000000) == 0 && (id2 & 0xFFFFFF) != 0;
    }

    public static int formatGravity(String value) {
        int start = value.contains("start") ? 0x800003 : 0;
        int top = value.contains("top") ? 48 : 0;
        int end = value.contains("end") ? 0x800005 : 0;
        int bottom = value.contains("bottom") ? 80 : 0;
        return start | top | end | bottom;
    }

    public static String parseGravity(int value) {
        String start = ViewKnife.existGravity(value, 0x800003) ? "start" : null;
        String top = ViewKnife.existGravity(value, 48) ? "top" : null;
        String end = ViewKnife.existGravity(value, 0x800005) ? "end" : null;
        String bottom = ViewKnife.existGravity(value, 80) ? "bottom" : null;
        StringBuilder sb = new StringBuilder();
        sb.append(!TextUtils.isEmpty((CharSequence)start) ? start + "|" : "");
        sb.append(!TextUtils.isEmpty((CharSequence)top) ? top + "|" : "");
        sb.append(!TextUtils.isEmpty((CharSequence)end) ? end + "|" : "");
        sb.append(!TextUtils.isEmpty((CharSequence)bottom) ? bottom + "|" : "");
        String result = sb.toString();
        if (result.endsWith("|")) {
            result = result.substring(0, result.lastIndexOf("|"));
        }
        return result;
    }

    private static boolean existGravity(int value, int attr) {
        return (value & attr) == attr;
    }
}

