/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.util;

import android.text.TextUtils;
import android.util.Pair;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Headers;
import org.json.JSONArray;
import org.json.JSONException;

public class JsonUtil {
    public static String formatHeaders(Headers headers) {
        JSONArray array = new JSONArray();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            array.put((Object)new JSONArray().put((Object)headers.name(i)).put((Object)headers.value(i)));
        }
        if (array.length() > 0) {
            return array.toString();
        }
        return null;
    }

    public static List<Pair<String, String>> parseHeaders(String headers) {
        ArrayList<Pair<String, String>> headerList = new ArrayList<Pair<String, String>>();
        if (!TextUtils.isEmpty((CharSequence)headers)) {
            try {
                JSONArray array = new JSONArray(headers);
                for (int i = 0; i < array.length(); ++i) {
                    Pair header = new Pair((Object)array.getJSONArray(i).getString(0), (Object)array.getJSONArray(i).getString(1));
                    headerList.add((Pair<String, String>)header);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return headerList;
    }

    public static List<String> print(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        int tabNum = 0;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder jsonFormat = new StringBuilder();
        int length = json.length();
        char last = '\u0000';
        for (int i = 0; i < length; ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                ++tabNum;
                jsonFormat.append(c);
                result.add(jsonFormat.toString());
                jsonFormat = new StringBuilder();
                jsonFormat.append(JsonUtil.addTab(tabNum));
            } else if (c == '}') {
                result.add(jsonFormat.toString());
                jsonFormat = new StringBuilder();
                jsonFormat.append(JsonUtil.addTab(--tabNum));
                jsonFormat.append(c);
            } else if (c == ',') {
                jsonFormat.append(c);
                result.add(jsonFormat.toString());
                jsonFormat = new StringBuilder();
                jsonFormat.append(JsonUtil.addTab(tabNum));
            } else if (c == ':') {
                jsonFormat.append(c).append(" ");
            } else if (c == '[') {
                ++tabNum;
                char next = json.charAt(i + 1);
                if (next == ']') {
                    jsonFormat.append(c);
                } else {
                    jsonFormat.append(c);
                    result.add(jsonFormat.toString());
                    jsonFormat = new StringBuilder();
                    jsonFormat.append(JsonUtil.addTab(tabNum));
                }
            } else if (c == ']') {
                --tabNum;
                if (last == '[') {
                    jsonFormat.append(c);
                } else {
                    result.add(jsonFormat.toString());
                    jsonFormat = new StringBuilder();
                    jsonFormat.append(JsonUtil.addTab(tabNum)).append(c);
                }
            } else {
                jsonFormat.append(c);
            }
            last = c;
        }
        result.add(jsonFormat.toString());
        return result;
    }

    private static String addTab(int tabNum) {
        StringBuilder sbTab = new StringBuilder();
        for (int i = 0; i < tabNum; ++i) {
            sbTab.append("        ");
        }
        return sbTab.toString();
    }
}

