/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora.network;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import tech.linjiang.pandora.network.model.Content;
import tech.linjiang.pandora.network.model.Summary;
import tech.linjiang.pandora.util.JsonUtil;
import tech.linjiang.pandora.util.Utils;

public class CacheDbHelper
extends SQLiteOpenHelper {
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_NAME = "pd_cache.db";
    private static CacheDbHelper HELPER = new CacheDbHelper(Utils.getContext());

    private CacheDbHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.reset();
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE summary (_id INTEGER PRIMARY KEY,status INTEGER,code INTEGER,url TEXT,host TEXT,method TEXT,protocol TEXT,ssl INTEGER,start_time INTEGER,end_time INTEGER,response_content_type TEXT,request_size INTEGER,response_size INTEGER,request_header TEXT,response_header TEXT)");
        db.execSQL("CREATE TABLE content (summary_id INTEGER PRIMARY KEY,request TEXT,response TEXT)");
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS summary");
        db.execSQL("DROP TABLE IF EXISTS content");
        this.onCreate(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    private void reset() {
        SQLiteDatabase db = this.getWritableDatabase();
        if (db != null) {
            db.execSQL("DELETE FROM summary");
            db.execSQL("DELETE FROM content");
        }
    }

    static SQLiteDatabase getWDb() {
        return HELPER.getWritableDatabase();
    }

    static SQLiteDatabase getRDb() {
        return HELPER.getReadableDatabase();
    }

    public static void deleteAll() {
        SummaryEntry.delete();
        ContentEntry.delete();
    }

    public static List<Summary> getSummaries() {
        return SummaryEntry.query();
    }

    public static Summary getSummary(long id2) {
        return SummaryEntry.query(id2);
    }

    public static Content getContent(long id2) {
        return ContentEntry.query(id2);
    }

    public static class ContentEntry {
        public static final String TABLE_NAME = "content";
        public static final String COLUMN_NAME_SUMMARY_ID = "summary_id";
        public static final String COLUMN_NAME_REQUEST = "request";
        public static final String COLUMN_NAME_RESPONSE = "response";
        static final String SQL_CREATE_ENTRIES = "CREATE TABLE content (summary_id INTEGER PRIMARY KEY,request TEXT,response TEXT)";
        static final String SQL_DELETE_ENTRIES = "DROP TABLE IF EXISTS content";
        static final String SQL_CLEAR_ENTRIES = "DELETE FROM content";

        public static void update(long pkValue, ContentValues values) {
            CacheDbHelper.getWDb().update(TABLE_NAME, values, "summary_id = ?", new String[]{String.valueOf(pkValue)});
        }

        public static long insert(ContentValues values) {
            return CacheDbHelper.getWDb().insert(TABLE_NAME, null, values);
        }

        public static void delete() {
            CacheDbHelper.getWDb().execSQL(SQL_CLEAR_ENTRIES);
        }

        public static Content query(long pkValue) {
            Content content = new Content();
            Cursor cursor = CacheDbHelper.getRDb().query(TABLE_NAME, null, "summary_id = ?", new String[]{String.valueOf(pkValue)}, null, null, null, String.valueOf(1));
            while (cursor.moveToNext()) {
                content.requestBody = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_REQUEST));
                content.responseBody = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_RESPONSE));
            }
            cursor.close();
            return content;
        }
    }

    public static class SummaryEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "summary";
        public static final String COLUMN_NAME_STATUS = "status";
        public static final String COLUMN_NAME_CODE = "code";
        public static final String COLUMN_NAME_URL = "url";
        public static final String COLUMN_NAME_HOST = "host";
        public static final String COLUMN_NAME_METHOD = "method";
        public static final String COLUMN_NAME_PROTOCOL = "protocol";
        public static final String COLUMN_NAME_SSL = "ssl";
        public static final String COLUMN_NAME_TIME_START = "start_time";
        public static final String COLUMN_NAME_TIME_END = "end_time";
        public static final String COLUMN_NAME_CONTENT_TYPE_RESPONSE = "response_content_type";
        public static final String COLUMN_NAME_SIZE_REQUEST = "request_size";
        public static final String COLUMN_NAME_SIZE_RESPONSE = "response_size";
        public static final String COLUMN_NAME_HEADER_REQUEST = "request_header";
        public static final String COLUMN_NAME_HEADER_RESPONSE = "response_header";
        static final String SQL_CREATE_ENTRIES = "CREATE TABLE summary (_id INTEGER PRIMARY KEY,status INTEGER,code INTEGER,url TEXT,host TEXT,method TEXT,protocol TEXT,ssl INTEGER,start_time INTEGER,end_time INTEGER,response_content_type TEXT,request_size INTEGER,response_size INTEGER,request_header TEXT,response_header TEXT)";
        static final String SQL_DELETE_ENTRIES = "DROP TABLE IF EXISTS summary";
        static final String SQL_CLEAR_ENTRIES = "DELETE FROM summary";
        private static final int MAX_QUERY_COUNT = 512;

        public static void update(long pkValue, ContentValues values) {
            CacheDbHelper.getWDb().update(TABLE_NAME, values, "_id = ?", new String[]{String.valueOf(pkValue)});
        }

        public static long insert(ContentValues values) {
            return CacheDbHelper.getWDb().insert(TABLE_NAME, null, values);
        }

        public static void delete() {
            CacheDbHelper.getWDb().execSQL(SQL_CLEAR_ENTRIES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Summary query(long id2) {
            try (Cursor cursor = CacheDbHelper.getRDb().query(TABLE_NAME, null, "_id = ?", new String[]{String.valueOf(id2)}, null, null, null, String.valueOf(1));){
                if (cursor.moveToNext()) {
                    Summary summary = SummaryEntry.parse(cursor);
                    return summary;
                }
                Summary summary = null;
                return summary;
            }
        }

        public static List<Summary> query() {
            ArrayList<Summary> summaries = new ArrayList<Summary>();
            Cursor cursor = CacheDbHelper.getRDb().query(TABLE_NAME, null, null, null, null, null, "start_time DESC", String.valueOf(512));
            while (cursor.moveToNext()) {
                Summary summary = SummaryEntry.parse(cursor);
                summaries.add(summary);
            }
            cursor.close();
            return summaries;
        }

        private static Summary parse(Cursor cursor) {
            Summary summary = new Summary();
            summary.id = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
            summary.status = cursor.getInt(cursor.getColumnIndexOrThrow(COLUMN_NAME_STATUS));
            summary.code = cursor.getInt(cursor.getColumnIndexOrThrow(COLUMN_NAME_CODE));
            summary.url = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_URL));
            summary.host = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_HOST));
            summary.method = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_METHOD));
            summary.protocol = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_PROTOCOL));
            summary.ssl = cursor.getInt(cursor.getColumnIndexOrThrow(COLUMN_NAME_SSL)) == 1;
            summary.start_time = cursor.getLong(cursor.getColumnIndexOrThrow(COLUMN_NAME_TIME_START));
            summary.end_time = cursor.getLong(cursor.getColumnIndexOrThrow(COLUMN_NAME_TIME_END));
            summary.response_content_type = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_CONTENT_TYPE_RESPONSE));
            summary.request_size = cursor.getLong(cursor.getColumnIndexOrThrow(COLUMN_NAME_SIZE_REQUEST));
            summary.response_size = cursor.getLong(cursor.getColumnIndexOrThrow(COLUMN_NAME_SIZE_RESPONSE));
            String reqHeaders = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_HEADER_REQUEST));
            summary.request_header = JsonUtil.parseHeaders(reqHeaders);
            String resHeaders = cursor.getString(cursor.getColumnIndexOrThrow(COLUMN_NAME_HEADER_RESPONSE));
            summary.response_header = JsonUtil.parseHeaders(resHeaders);
            return summary;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Status {
            public static final int REQUESTING = 0;
            public static final int ERROR = 1;
            public static final int COMPLETE = 2;
        }
    }
}

