/*
 * Decompiled with CFR 0.152.
 */
package tech.linjiang.pandora;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.view.View;
import tech.linjiang.pandora.database.Databases;
import tech.linjiang.pandora.inspector.attribute.AttrFactory;
import tech.linjiang.pandora.network.OkHttpInterceptor;
import tech.linjiang.pandora.preference.SharedPref;
import tech.linjiang.pandora.ui.Dispatcher;
import tech.linjiang.pandora.ui.connector.OnEntranceClick;
import tech.linjiang.pandora.ui.connector.SimpleActivityLifecycleCallbacks;
import tech.linjiang.pandora.ui.view.EntranceView;
import tech.linjiang.pandora.util.Utils;

@SuppressLint(value={"StaticFieldLeak"})
public class Pandora {
    private static final String TAG = "Pandora";
    private static Pandora INSTANCE;
    private final EntranceView entranceView = new EntranceView(Utils.getContext());
    private OkHttpInterceptor interceptor = new OkHttpInterceptor();
    private final Databases databases = new Databases();
    private final SharedPref sharedPref = new SharedPref();
    private final AttrFactory attrFactory = new AttrFactory();
    private Activity bottomActivity;
    private String curActivityName;
    private boolean preventFree;
    private SimpleActivityLifecycleCallbacks callbacks = new SimpleActivityLifecycleCallbacks(){
        private int count;

        @Override
        public void onActivityStarted(Activity activity) {
            super.onActivityStarted(activity);
            ++this.count;
            if (this.count == 1) {
                INSTANCE.entranceView.show();
            }
            if (activity instanceof Dispatcher) {
                INSTANCE.entranceView.hide();
            }
        }

        @Override
        public void onActivityResumed(Activity activity) {
            super.onActivityResumed(activity);
            if (!(activity instanceof Dispatcher)) {
                INSTANCE.bottomActivity = activity;
            }
        }

        @Override
        public void onActivityPaused(Activity activity) {
            super.onActivityPaused(activity);
            if (activity == INSTANCE.bottomActivity && !INSTANCE.preventFree) {
                INSTANCE.bottomActivity = null;
            }
        }

        @Override
        public void onActivityStopped(Activity activity) {
            super.onActivityStopped(activity);
            --this.count;
            if (this.count <= 0) {
                INSTANCE.entranceView.hide();
            } else if (activity instanceof Dispatcher) {
                INSTANCE.entranceView.show();
            }
        }

        @Override
        public void onActivityDestroyed(Activity activity) {
            super.onActivityDestroyed(activity);
            if (activity instanceof Dispatcher) {
                INSTANCE.preventFree = false;
            }
        }
    };
    private SensorEventListener sensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            if (!INSTANCE.entranceView.isOpen() && Utils.checkIfShake(event.values[0], event.values[1], event.values[2])) {
                INSTANCE.open();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public static Pandora init(Application application) {
        INSTANCE = new Pandora();
        Utils.init(application);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Pandora.INSTANCE.callbacks);
        return INSTANCE;
    }

    public static Pandora get() {
        if (INSTANCE == null) {
            throw new RuntimeException("need to call Pandora#init in Application#onCreate firstly.");
        }
        return INSTANCE;
    }

    private Pandora() {
        this.entranceView.setOnClickListener(new OnEntranceClick(){

            @Override
            protected void onClick(int type) {
                Pandora.this.preventFree = true;
                super.onClick(type);
            }
        });
    }

    public OkHttpInterceptor getInterceptor() {
        return this.interceptor;
    }

    public Databases getDatabases() {
        return this.databases;
    }

    public SharedPref getSharedPref() {
        return this.sharedPref;
    }

    public AttrFactory getAttrFactory() {
        return this.attrFactory;
    }

    public View getViewRoot() {
        if (this.bottomActivity != null) {
            return this.bottomActivity.getWindow().peekDecorView();
        }
        return null;
    }

    public Activity getBottomActivity() {
        return this.bottomActivity;
    }

    public void open() {
        if (Utils.checkPermission()) {
            this.entranceView.open();
        }
    }

    public void close() {
        if (Utils.checkPermission()) {
            this.entranceView.close();
        }
    }

    public Pandora enableShakeOpen() {
        Utils.registerSensor(this.sensorEventListener);
        return this;
    }
}

