/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezDevice;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.BluezGattCharacteristic;
import com.welie.blessed.bluez.DbusHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bluez.GattCharacteristic1;
import org.bluez.GattService1;
import org.bluez.exceptions.BluezNotImplementedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.jetbrains.annotations.NotNull;

public class BluezGattService
extends AbstractBluetoothObject {
    private final GattService1 service;
    private final BluezDevice device;
    private final Map<UUID, BluezGattCharacteristic> characteristicByUuid = new LinkedHashMap<UUID, BluezGattCharacteristic>();

    public BluezGattService(GattService1 _service, BluezDevice _device, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluezDeviceType.GATT_SERVICE, _dbusConnection, _dbusPath);
        this.service = _service;
        this.device = _device;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return GattService1.class;
    }

    public void refreshGattCharacteristics() {
        this.characteristicByUuid.clear();
        Set<String> findNodes = DbusHelper.findNodes(this.getDbusConnection(), this.getDbusPath());
        Map<String, GattCharacteristic1> remoteObjects = this.getRemoteObjects(findNodes, this.getDbusPath(), GattCharacteristic1.class);
        for (Map.Entry<String, GattCharacteristic1> entry : remoteObjects.entrySet()) {
            BluezGattCharacteristic bluetoothGattCharacteristics = new BluezGattCharacteristic(entry.getValue(), this, entry.getKey(), this.getDbusConnection());
            this.characteristicByUuid.put(bluetoothGattCharacteristics.getUuid(), bluetoothGattCharacteristics);
        }
    }

    @NotNull
    public List<BluezGattCharacteristic> getGattCharacteristics() {
        if (this.characteristicByUuid.isEmpty()) {
            this.refreshGattCharacteristics();
        }
        return new ArrayList<BluezGattCharacteristic>(this.characteristicByUuid.values());
    }

    public BluezGattCharacteristic getGattCharacteristicByUuid(UUID uuid) {
        if (this.characteristicByUuid.isEmpty()) {
            this.refreshGattCharacteristics();
        }
        return this.characteristicByUuid.get(uuid);
    }

    public UUID getUuid() {
        return UUID.fromString(this.getTyped("UUID", String.class));
    }

    public Boolean isPrimary() {
        return this.getTyped("Primary", Boolean.class);
    }

    public Object[] getIncludes() throws BluezNotImplementedException {
        throw new BluezNotImplementedException("Feature not yet implemented");
    }

    public GattService1 getService() {
        return this.service;
    }

    public BluezDevice getDevice() {
        return this.device;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [service=" + this.service + ", device=" + this.device.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

