/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.ClassUtils;
import com.welie.blessed.bluez.DbusHelper;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;

public abstract class AbstractBluetoothObject {
    private final Logger logger = Logger.getLogger(this.getClass().getSimpleName());
    private final BluezDeviceType bluetoothType;
    private final DBusConnection dbusConnection;
    private final String dbusPath;

    public AbstractBluetoothObject(BluezDeviceType _bluetoothType, DBusConnection _dbusConnection, String _dbusPath) {
        this.bluetoothType = _bluetoothType;
        this.dbusConnection = _dbusConnection;
        this.dbusPath = _dbusPath;
    }

    protected abstract Class<? extends DBusInterface> getInterfaceClass();

    public BluezDeviceType getBluetoothType() {
        return this.bluetoothType;
    }

    public String getDbusPath() {
        return this.dbusPath;
    }

    protected DBusConnection getDbusConnection() {
        return this.dbusConnection;
    }

    protected <T extends DBusInterface> Map<String, T> getRemoteObjects(Set<String> _objectNames, String _parentPath, Class<T> _type) {
        LinkedHashMap<CallSite, T> map = new LinkedHashMap<CallSite, T>();
        Object path = _parentPath;
        if (!_parentPath.endsWith("/")) {
            path = (String)path + "/";
        }
        for (String string : _objectNames) {
            T remoteObject = DbusHelper.getRemoteObject(this.getDbusConnection(), (String)path + string, _type);
            map.put((CallSite)((Object)((String)path + string)), remoteObject);
        }
        return map;
    }

    protected <T> T getTyped(String _field, Class<T> _type) {
        try {
            Properties remoteObject = (Properties)this.dbusConnection.getRemoteObject("org.bluez", this.dbusPath, Properties.class);
            Object obj = remoteObject.Get(this.getInterfaceClass().getName(), _field);
            if (ClassUtils.isAssignable(_type, obj.getClass())) {
                return _type.cast(obj);
            }
        }
        catch (DBusException _ex) {
            this.logger.severe(String.format("Error while receiving data from DBUS (Field: {%s}): %s", _field, _ex.getMessage()));
        }
        return null;
    }

    protected void setTyped(String _field, Object _value) {
        try {
            Properties remoteObject = (Properties)this.dbusConnection.getRemoteObject("org.bluez", this.dbusPath, Properties.class);
            remoteObject.Set(this.getInterfaceClass().getName(), _field, _value);
        }
        catch (DBusException _ex) {
            this.logger.severe(String.format("Error while setting data for DBUS (Field: {%s}): %s", _field, _ex.getMessage()));
        }
    }

    protected Map<String, Variant<?>> optionsToVariantMap(Map<String, Object> _options) {
        LinkedHashMap optionMap = new LinkedHashMap();
        if (_options != null) {
            for (Map.Entry<String, Object> entry : _options.entrySet()) {
                if (entry.getValue() == null) continue;
                optionMap.put(entry.getKey(), new Variant(entry.getValue()));
            }
        }
        return optionMap;
    }

    protected byte[] byteListToByteArray(List<?> _list) {
        if (_list == null) {
            return null;
        }
        if (_list.isEmpty()) {
            return new byte[0];
        }
        if (!ClassUtils.isAssignable(Byte.TYPE, _list.get(0).getClass())) {
            return null;
        }
        byte[] result = new byte[_list.size()];
        for (int i = 0; i < _list.size(); ++i) {
            Object x = _list.get(i);
            result[i] = (Byte)x;
        }
        return result;
    }
}

