/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezDevice;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.DbusHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bluez.Adapter1;
import org.bluez.Device1;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotReadyException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluezAdapter
extends AbstractBluetoothObject {
    private final Map<String, Class<?>> supportedFilterOptions = new HashMap();
    private final String[] supportedTransportValues = new String[]{"auto", "bredr", "le"};
    private final Adapter1 adapter;
    private boolean internalDiscover;

    public BluezAdapter(Adapter1 _adapter, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluezDeviceType.ADAPTER, _dbusConnection, _dbusPath);
        this.adapter = _adapter;
        this.supportedFilterOptions.put("UUIDs", String[].class);
        this.supportedFilterOptions.put("RSSI", Short.class);
        this.supportedFilterOptions.put("Pathloss", UInt16.class);
        this.supportedFilterOptions.put("Transport", String.class);
        this.supportedFilterOptions.put("DuplicateData", Boolean.class);
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return Adapter1.class;
    }

    public String getDeviceName() {
        return this.getDbusPath().substring(this.getDbusPath().lastIndexOf("/") + 1);
    }

    public String getAlias() {
        return this.getTyped("Alias", String.class);
    }

    public void setAlias(String _alias) {
        this.setTyped("Alias", _alias);
    }

    public boolean isPowered() {
        return this.getTyped("Powered", Boolean.class);
    }

    public void setPowered(boolean _powered) {
        this.setTyped("Powered", _powered);
    }

    public Boolean isDiscoverable() {
        return this.getTyped("Discoverable", Boolean.class);
    }

    public void setDiscoverable(boolean _discoverable) {
        this.setTyped("Discoverable", _discoverable);
    }

    public Integer getDiscoverableTimeout() {
        UInt32 typed = this.getTyped("DiscoverableTimeout", UInt32.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public void setDiscoverableTimeout(Integer _discoverableTimeout) {
        this.setTyped("DiscoverableTimeout", new UInt32((long)_discoverableTimeout.intValue()));
    }

    public Boolean isPairable() {
        return this.getTyped("Pairable", Boolean.class);
    }

    public void setPairable(boolean _pairable) {
        this.setTyped("Pairable", _pairable);
    }

    public Integer getPairableTimeout() {
        UInt32 typed = this.getTyped("PairableTimeout", UInt32.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public void setPairableTimeout(Integer _pairableTimeout) {
        this.setTyped("PairableTimeout", new UInt32((long)_pairableTimeout.intValue()));
    }

    public String getAddress() {
        return this.getTyped("Address", String.class);
    }

    public String getName() {
        return this.getTyped("Name", String.class);
    }

    public Integer getDeviceClass() {
        UInt32 typed = this.getTyped("Class", UInt32.class);
        return typed != null ? Integer.valueOf(typed.intValue()) : null;
    }

    public Boolean isDiscovering() {
        return this.getTyped("Discovering", Boolean.class);
    }

    public String[] getUuids() {
        List typed = this.getTyped("UUIDs", ArrayList.class);
        if (typed != null) {
            return typed.toArray(new String[0]);
        }
        return null;
    }

    public String getModAlias() {
        return this.getTyped("Modalias", String.class);
    }

    public void startDiscovery() throws BluezFailedException, BluezNotReadyException {
        this.adapter.StartDiscovery();
    }

    public void stopDiscovery() throws BluezNotAuthorizedException, BluezFailedException, BluezNotReadyException {
        this.adapter.StopDiscovery();
    }

    public void removeDevice(Device1 _device) throws BluezFailedException, BluezInvalidArgumentsException {
        this.adapter.RemoveDevice(new DBusPath(_device.getObjectPath()));
    }

    public void setDiscoveryFilter(Map<String, Variant<?>> _filter) throws BluezInvalidArgumentsException, BluezNotReadyException, BluezNotSupportedException, BluezFailedException {
        for (Map.Entry<String, Variant<?>> entry : _filter.entrySet()) {
            if (!this.supportedFilterOptions.containsKey(entry.getKey())) {
                throw new BluezInvalidArgumentsException("Key " + entry.getKey() + " is not supported by Bluez library");
            }
            Class<?> typeClass = this.supportedFilterOptions.get(entry.getKey());
            if (typeClass.isAssignableFrom(entry.getValue().getValue().getClass())) continue;
            throw new BluezInvalidArgumentsException("Key " + entry.getKey() + " uses unsupported data type " + entry.getValue().getClass() + ", only " + typeClass.getName() + " is supported.");
        }
        if (_filter.containsKey("Transport")) {
            String transportType = (String)_filter.get("Transport").getValue();
            if (!Arrays.asList(this.supportedTransportValues).contains(transportType)) {
                throw new BluezInvalidArgumentsException("Transport option " + transportType + " is unsupported.");
            }
        }
        this.adapter.SetDiscoveryFilter(_filter);
    }

    @Nullable
    public BluezDevice getBluezDeviceByPath(@NotNull String devicePath) {
        BluezDevice bluezDevice = null;
        Device1 device = DbusHelper.getRemoteObject(this.getDbusConnection(), devicePath, Device1.class);
        if (device != null) {
            bluezDevice = new BluezDevice(device, this, devicePath, this.getDbusConnection());
        }
        return bluezDevice;
    }

    @NotNull
    public String getPath(String deviceAddress) {
        return this.getDbusPath() + "/dev_" + deviceAddress.replace(":", "_");
    }

    @NotNull
    public DBusConnection getDBusConnection() {
        return super.getDbusConnection();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [adapter=" + this.adapter + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

