/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.BluezGattCharacteristic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bluez.GattDescriptor1;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidValueLengthException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotPermittedException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.jetbrains.annotations.NotNull;

public class BluezGattDescriptor
extends AbstractBluetoothObject {
    private final GattDescriptor1 descriptor;
    private final BluezGattCharacteristic characteristicWrapper;

    public BluezGattDescriptor(GattDescriptor1 _descriptor, BluezGattCharacteristic _characteristicWrapper, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluezDeviceType.GATT_DESCRIPTOR, _dbusConnection, _dbusPath);
        this.characteristicWrapper = _characteristicWrapper;
        this.descriptor = _descriptor;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return GattDescriptor1.class;
    }

    public void writeValue(byte[] _value, Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException, BluezInvalidValueLengthException {
        this.descriptor.WriteValue(_value, this.optionsToVariantMap(_options));
    }

    public byte[] readValue(Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException {
        return this.descriptor.ReadValue(this.optionsToVariantMap(_options));
    }

    public UUID getUuid() {
        return UUID.fromString(this.getTyped("UUID", String.class));
    }

    public BluezGattCharacteristic getCharacteristic() {
        return this.characteristicWrapper;
    }

    public GattDescriptor1 getRawCharacteric() {
        return this.descriptor;
    }

    @NotNull
    public byte[] getValue() {
        List typed = this.getTyped("Value", ArrayList.class);
        if (typed != null) {
            return this.byteListToByteArray(typed);
        }
        return new byte[0];
    }

    public List<String> getFlags() {
        List typed = this.getTyped("Flags", ArrayList.class);
        if (typed != null) {
            return typed;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [descriptor=" + this.descriptor + ", characteristicWrapper=" + this.characteristicWrapper.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

