/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.BluezGattDescriptor;
import com.welie.blessed.bluez.BluezGattService;
import com.welie.blessed.bluez.DbusHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bluez.GattCharacteristic1;
import org.bluez.GattDescriptor1;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidOffsetException;
import org.bluez.exceptions.BluezInvalidValueLengthException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotPermittedException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluezGattCharacteristic
extends AbstractBluetoothObject {
    @NotNull
    private final GattCharacteristic1 gattCharacteristic;
    @NotNull
    private final BluezGattService gattService;
    private UUID uuid;
    private final Map<UUID, BluezGattDescriptor> descriptorByUuid = new LinkedHashMap<UUID, BluezGattDescriptor>();

    public BluezGattCharacteristic(GattCharacteristic1 _gattCharacteristic, BluezGattService _service, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluezDeviceType.GATT_CHARACTERISTIC, _dbusConnection, _dbusPath);
        this.gattCharacteristic = _gattCharacteristic;
        this.gattService = _service;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return GattCharacteristic1.class;
    }

    public void refreshGattCharacteristics() {
        this.descriptorByUuid.clear();
        Set<String> findNodes = DbusHelper.findNodes(this.getDbusConnection(), this.getDbusPath());
        Map<String, GattDescriptor1> remoteObjects = this.getRemoteObjects(findNodes, this.getDbusPath(), GattDescriptor1.class);
        for (Map.Entry<String, GattDescriptor1> entry : remoteObjects.entrySet()) {
            BluezGattDescriptor btDescriptor = new BluezGattDescriptor(entry.getValue(), this, entry.getKey(), this.getDbusConnection());
            this.descriptorByUuid.put(btDescriptor.getUuid(), btDescriptor);
        }
    }

    @NotNull
    public List<BluezGattDescriptor> getGattDescriptors() {
        if (this.descriptorByUuid.isEmpty()) {
            this.refreshGattCharacteristics();
        }
        return new ArrayList<BluezGattDescriptor>(this.descriptorByUuid.values());
    }

    @Nullable
    public BluezGattDescriptor getGattDescriptorByUuid(UUID _uuid) {
        if (this.descriptorByUuid.isEmpty()) {
            this.refreshGattCharacteristics();
        }
        return this.descriptorByUuid.get(_uuid);
    }

    public void writeValue(byte[] _value, Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException, BluezInvalidValueLengthException {
        this.gattCharacteristic.WriteValue(_value, this.optionsToVariantMap(_options));
    }

    public byte[] readValue(Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException, BluezInvalidOffsetException {
        return this.gattCharacteristic.ReadValue(this.optionsToVariantMap(_options));
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.fromString(this.getTyped("UUID", String.class));
        }
        return this.uuid;
    }

    public BluezGattService getService() {
        return this.gattService;
    }

    public GattCharacteristic1 getRawGattCharacteristic() {
        return this.gattCharacteristic;
    }

    public byte[] getValue() {
        List typed = this.getTyped("Value", ArrayList.class);
        if (typed != null) {
            return this.byteListToByteArray(typed);
        }
        return new byte[0];
    }

    public Boolean isNotifying() {
        return this.getTyped("Notifying", Boolean.class);
    }

    public List<String> getFlags() {
        List typed = this.getTyped("Flags", ArrayList.class);
        if (typed != null) {
            return typed;
        }
        return Collections.emptyList();
    }

    public void startNotify() throws BluezFailedException, BluezInProgressException, BluezNotSupportedException, BluezNotPermittedException {
        this.gattCharacteristic.StartNotify();
    }

    public void stopNotify() throws BluezFailedException {
        this.gattCharacteristic.StopNotify();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [gattCharacteristic=" + this.gattCharacteristic + ", gattService=" + this.gattService.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

