/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class Handler {
    private final ScheduledThreadPoolExecutor executor;

    public Handler(@NotNull String name) {
        Objects.requireNonNull(name, "name is null");
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setRemoveOnCancelPolicy(true);
        this.executor.execute(() -> Thread.currentThread().setName(name));
    }

    public final void post(@NotNull Runnable runnable) {
        this.executor.execute(runnable);
    }

    public final ScheduledFuture<?> postDelayed(@NotNull Runnable runnable, long delayMillis) {
        return this.executor.schedule(runnable, delayMillis, TimeUnit.MILLISECONDS);
    }

    public final void shutdown() {
        this.executor.shutdown();
    }
}

