/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothGattDescriptor;
import com.welie.blessed.BluetoothGattService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothGattCharacteristic {
    public static final int PROPERTY_BROADCAST = 1;
    public static final int PROPERTY_READ = 2;
    public static final int PROPERTY_WRITE_NO_RESPONSE = 4;
    public static final int PROPERTY_WRITE = 8;
    public static final int PROPERTY_NOTIFY = 16;
    public static final int PROPERTY_INDICATE = 32;
    public static final int PROPERTY_SIGNED_WRITE = 64;
    public static final int PROPERTY_EXTENDED_PROPS = 128;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;
    @NotNull
    protected final UUID uuid;
    protected final int properties;
    @Nullable
    protected BluetoothGattService service;
    protected final List<BluetoothGattDescriptor> descriptors = new ArrayList<BluetoothGattDescriptor>();

    public BluetoothGattCharacteristic(@NotNull UUID uuid, int properties) {
        this.uuid = Objects.requireNonNull(uuid, "no valid UUID supplied");
        this.properties = properties;
    }

    public boolean addDescriptor(@NotNull BluetoothGattDescriptor descriptor) {
        Objects.requireNonNull(descriptor, "no valid descriptor supplied");
        descriptor.setCharacteristic(this);
        return this.descriptors.add(descriptor);
    }

    @Nullable
    public BluetoothGattService getService() {
        return this.service;
    }

    void setService(@NotNull BluetoothGattService service) {
        this.service = Objects.requireNonNull(service, "no valid service supplied");
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public int getProperties() {
        return this.properties;
    }

    @NotNull
    public List<BluetoothGattDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    @Nullable
    public BluetoothGattDescriptor getDescriptor(@NotNull UUID uuid) {
        Objects.requireNonNull(uuid, "no valid uuid supplied");
        for (BluetoothGattDescriptor descriptor : this.descriptors) {
            if (!descriptor.getUuid().equals(uuid)) continue;
            return descriptor;
        }
        return null;
    }

    public boolean supportsReading() {
        return (this.properties & 2) > 0;
    }

    public boolean supportsWritingWithResponse() {
        return (this.properties & 8) > 0;
    }

    public boolean supportsWritingWithoutResponse() {
        return (this.properties & 4) > 0;
    }

    public boolean supportsNotifying() {
        return (this.properties & 0x10) > 0 || (this.properties & 0x20) > 0;
    }

    public boolean supportsWriteType(WriteType writeType) {
        int writeProperty;
        switch (writeType) {
            case WITH_RESPONSE: {
                writeProperty = 8;
                break;
            }
            case WITHOUT_RESPONSE: {
                writeProperty = 4;
                break;
            }
            default: {
                writeProperty = -1;
            }
        }
        return (this.getProperties() & writeProperty) != 0;
    }

    public static enum WriteType {
        WITH_RESPONSE,
        WITHOUT_RESPONSE;

    }
}

