/*
 * Decompiled with CFR 0.152.
 */
package testapp;

import com.welie.blessed.BluetoothBytesParser;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import testapp.WeightUnit;

public class WeightMeasurement {
    private final double weight;
    private final WeightUnit unit;
    private final Date timestamp;
    private Integer userID;
    private Integer BMI;
    private Integer height;

    public WeightMeasurement(byte[] byteArray) {
        BluetoothBytesParser parser = new BluetoothBytesParser(byteArray);
        int flags = parser.getIntValue(17);
        this.unit = (flags & 1) > 0 ? WeightUnit.Pounds : WeightUnit.Kilograms;
        boolean timestampPresent = (flags & 2) > 0;
        boolean userIDPresent = (flags & 4) > 0;
        boolean bmiAndHeightPresent = (flags & 8) > 0;
        double weightMultiplier = this.unit == WeightUnit.Kilograms ? 0.005 : 0.01;
        this.weight = (double)parser.getIntValue(18).intValue() * weightMultiplier;
        this.timestamp = timestampPresent ? parser.getDateTime() : Calendar.getInstance().getTime();
        if (userIDPresent) {
            this.userID = parser.getIntValue(17);
        }
        if (bmiAndHeightPresent) {
            this.BMI = parser.getIntValue(18);
            this.height = parser.getIntValue(18);
        }
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String formattedTimestamp = this.timestamp != null ? df.format(this.timestamp) : "null";
        return String.format("%.1f %s, user %d, BMI %d, height %d at (%s)", this.weight, this.unit == WeightUnit.Kilograms ? "kg" : "lb", this.userID, this.BMI, this.height, formattedTimestamp);
    }
}

