/*
 * Decompiled with CFR 0.152.
 */
package testapp;

import com.welie.blessed.BluetoothBytesParser;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class PulseOximeterSpotMeasurement {
    private final float spO2;
    private final float pulseRate;
    private float pulseAmplitudeIndex;
    private final boolean deviceClockSet;
    private Date timestamp;
    private int measurementStatus;
    private int sensorStatus;

    public PulseOximeterSpotMeasurement(byte[] value) {
        BluetoothBytesParser parser = new BluetoothBytesParser(value);
        int flags = parser.getIntValue(17);
        boolean timestampPresent = (flags & 1) > 0;
        boolean measurementStatusPresent = (flags & 2) > 0;
        boolean sensorStatusPresent = (flags & 4) > 0;
        boolean pulseAmplitudeIndexPresent = (flags & 8) > 0;
        this.deviceClockSet = (flags & 0x10) == 0;
        this.spO2 = parser.getFloatValue(50).floatValue();
        this.pulseRate = parser.getFloatValue(50).floatValue();
        if (timestampPresent) {
            Date timestamp = parser.getDateTime();
            this.setTimestamp(timestamp);
        } else {
            this.setTimestamp(Calendar.getInstance().getTime());
        }
        if (measurementStatusPresent) {
            this.measurementStatus = parser.getIntValue(18);
        }
        if (sensorStatusPresent) {
            this.sensorStatus = parser.getIntValue(18);
            int n = parser.getIntValue(17);
        }
        if (pulseAmplitudeIndexPresent) {
            this.pulseAmplitudeIndex = parser.getFloatValue(50).floatValue();
        }
    }

    public float getSpO2() {
        return this.spO2;
    }

    public float getPulseRate() {
        return this.pulseRate;
    }

    public float getPulseAmplitudeIndex() {
        return this.pulseAmplitudeIndex;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isDeviceClockSet() {
        return this.deviceClockSet;
    }

    public int getMeasurementStatus() {
        return this.measurementStatus;
    }

    public int getSensorStatus() {
        return this.sensorStatus;
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String formattedTimestamp = df.format(this.timestamp);
        return String.format("SpO2 %.0f%% HR: %.0f PAI: %.1f (%s)", Float.valueOf(this.spO2), Float.valueOf(this.pulseRate), Float.valueOf(this.pulseAmplitudeIndex), formattedTimestamp);
    }
}

