/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;

public class DBusMatchRule {
    private static final Map<String, Class<? extends DBusSignal>> SIGNALTYPEMAP = new ConcurrentHashMap<String, Class<? extends DBusSignal>>();
    private String type;
    private String iface;
    private String member;
    private String object;
    private String source;

    public static Class<? extends DBusSignal> getCachedSignalType(String type) {
        return SIGNALTYPEMAP.get(type);
    }

    public DBusMatchRule(String _type, String _iface, String _member) {
        this.type = _type;
        this.iface = _iface;
        this.member = _member;
    }

    public DBusMatchRule(String _type, String _iface, String _member, String _object) {
        this.type = _type;
        this.iface = _iface;
        this.member = _member;
        this.object = _object;
    }

    public DBusMatchRule(DBusExecutionException e) throws DBusException {
        this(e.getClass());
        this.member = null;
        this.type = "error";
    }

    public DBusMatchRule(Message m3) {
        this.iface = m3.getInterface();
        this.member = m3.getName();
        if (m3 instanceof DBusSignal) {
            this.type = "signal";
        } else if (m3 instanceof Error) {
            this.type = "error";
            this.member = null;
        } else if (m3 instanceof MethodCall) {
            this.type = "method_call";
        } else if (m3 instanceof MethodReturn) {
            this.type = "method_reply";
        }
    }

    public DBusMatchRule(Class<? extends DBusInterface> c, String method) throws DBusException {
        this(c);
        this.member = method;
        this.type = "method_call";
    }

    public DBusMatchRule(Class<? extends Object> _c, String _source, String _object) throws DBusException {
        this(_c);
        this.source = _source;
        this.object = _object;
    }

    public DBusMatchRule(Class<? extends Object> c) throws DBusException {
        if (DBusInterface.class.isAssignableFrom(c)) {
            this.iface = null != c.getAnnotation(DBusInterfaceName.class) ? c.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = null;
            this.type = null;
        } else if (DBusSignal.class.isAssignableFrom(c)) {
            if (null == c.getEnclosingClass()) {
                throw new DBusException("Signals must be declared as a member of a class implementing DBusInterface which is the member of a package.");
            }
            this.iface = null != c.getEnclosingClass().getAnnotation(DBusInterfaceName.class) ? c.getEnclosingClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getEnclosingClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = c.isAnnotationPresent(DBusMemberName.class) ? c.getAnnotation(DBusMemberName.class).value() : c.getSimpleName();
            SIGNALTYPEMAP.put(this.iface + '$' + this.member, c);
            this.type = "signal";
        } else if (Error.class.isAssignableFrom(c)) {
            this.iface = null != c.getAnnotation(DBusInterfaceName.class) ? c.getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = null;
            this.type = "error";
        } else if (DBusExecutionException.class.isAssignableFrom(c)) {
            this.iface = null != c.getClass().getAnnotation(DBusInterfaceName.class) ? c.getClass().getAnnotation(DBusInterfaceName.class).value() : AbstractConnection.DOLLAR_PATTERN.matcher(c.getClass().getName()).replaceAll(".");
            if (!this.iface.matches(".*\\..*")) {
                throw new DBusException("DBusInterfaces must be defined in a package.");
            }
            this.member = null;
            this.type = "error";
        } else {
            throw new DBusException("Invalid type for match rule: " + c);
        }
    }

    public String toString() {
        String s2 = null;
        if (null != this.type) {
            String string = s2 = null == s2 ? "type='" + this.type + "'" : s2 + ",type='" + this.type + "'";
        }
        if (null != this.member) {
            String string = s2 = null == s2 ? "member='" + this.member + "'" : s2 + ",member='" + this.member + "'";
        }
        if (null != this.iface) {
            String string = s2 = null == s2 ? "interface='" + this.iface + "'" : s2 + ",interface='" + this.iface + "'";
        }
        if (null != this.source) {
            String string = s2 = null == s2 ? "sender='" + this.source + "'" : s2 + ",sender='" + this.source + "'";
        }
        if (null != this.object) {
            s2 = null == s2 ? "path='" + this.object + "'" : s2 + ",path='" + this.object + "'";
        }
        return s2;
    }

    public String getType() {
        return this.type;
    }

    public String getInterface() {
        return this.iface;
    }

    public String getMember() {
        return this.member;
    }

    public String getSource() {
        return this.source;
    }

    public String getObject() {
        return this.object;
    }
}

