/*
 * Decompiled with CFR 0.152.
 */
package dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.NodeVisitor;
import dataflow.util.HashCodeUtils;
import java.util.Collection;
import java.util.LinkedList;
import javacutils.InternalUtils;

public class ConditionalAndNode
extends Node {
    protected BinaryTree tree;
    protected Node lhs;
    protected Node rhs;

    public ConditionalAndNode(BinaryTree tree, Node lhs, Node rhs) {
        super(InternalUtils.typeOf(tree));
        assert (tree.getKind().equals((Object)Tree.Kind.CONDITIONAL_AND));
        this.tree = tree;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public Node getLeftOperand() {
        return this.lhs;
    }

    public Node getRightOperand() {
        return this.rhs;
    }

    @Override
    public BinaryTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitConditionalAnd(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " && " + this.getRightOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConditionalAndNode)) {
            return false;
        }
        ConditionalAndNode other = (ConditionalAndNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getLeftOperand(), this.getRightOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.getLeftOperand());
        list.add(this.getRightOperand());
        return list;
    }
}

