/*
 * Decompiled with CFR 0.152.
 */
package dataflow.analysis;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import dataflow.analysis.AbstractValue;
import dataflow.analysis.AnalysisResult;
import dataflow.analysis.RegularTransferResult;
import dataflow.analysis.Store;
import dataflow.analysis.TransferFunction;
import dataflow.analysis.TransferInput;
import dataflow.analysis.TransferResult;
import dataflow.cfg.ControlFlowGraph;
import dataflow.cfg.UnderlyingAST;
import dataflow.cfg.block.Block;
import dataflow.cfg.block.ConditionalBlock;
import dataflow.cfg.block.ExceptionBlock;
import dataflow.cfg.block.RegularBlock;
import dataflow.cfg.block.SpecialBlock;
import dataflow.cfg.node.AssignmentNode;
import dataflow.cfg.node.LocalVariableNode;
import dataflow.cfg.node.Node;
import dataflow.cfg.node.ReturnNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import javacutils.ElementUtils;
import javacutils.Pair;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class Analysis<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
    protected boolean isRunning = false;
    protected T transferFunction;
    protected ControlFlowGraph cfg;
    protected final ProcessingEnvironment env;
    protected final Types types;
    protected IdentityHashMap<Block, S> thenStores;
    protected IdentityHashMap<Block, S> elseStores;
    protected IdentityHashMap<Block, TransferInput<A, S>> inputs;
    protected IdentityHashMap<ReturnNode, TransferResult<A, S>> storesAtReturnStatements;
    protected Worklist worklist;
    protected IdentityHashMap<Node, A> nodeValues;
    public HashMap<Element, A> finalLocalValues;
    protected Node currentNode;
    protected Tree currentTree;
    protected TransferInput<A, S> currentInput;

    public Tree getCurrentTree() {
        return this.currentTree;
    }

    public void setCurrentTree(Tree currentTree) {
        this.currentTree = currentTree;
    }

    public Analysis(ProcessingEnvironment env) {
        this.env = env;
        this.types = env.getTypeUtils();
    }

    public Analysis(ProcessingEnvironment env, T transfer) {
        this(env);
        this.transferFunction = transfer;
    }

    public void setTransferFunction(T transfer) {
        this.transferFunction = transfer;
    }

    public T getTransferFunction() {
        return this.transferFunction;
    }

    public Types getTypes() {
        return this.types;
    }

    public ProcessingEnvironment getEnv() {
        return this.env;
    }

    public void performAnalysis(ControlFlowGraph cfg) {
        assert (!this.isRunning);
        this.isRunning = true;
        this.init(cfg);
        block6: while (!this.worklist.isEmpty()) {
            Block b = this.worklist.poll();
            switch (b.getType()) {
                case REGULAR_BLOCK: {
                    RegularBlock rb = (RegularBlock)b;
                    TransferInput<A, S> inputBefore = this.getInputBefore(rb);
                    this.currentInput = inputBefore.copy();
                    TransferResult<A, S> transferResult = null;
                    Node lastNode = null;
                    boolean addToWorklistAgain = false;
                    for (Node n : rb.getContents()) {
                        transferResult = this.callTransferFunction(n, this.currentInput);
                        A val = transferResult.getResultValue();
                        if (val != null) {
                            boolean didNodeValuesChange = this.updateNodeValues(n, val);
                            addToWorklistAgain = didNodeValuesChange || addToWorklistAgain;
                        }
                        this.currentInput = new TransferInput(n, this, transferResult);
                        lastNode = n;
                    }
                    Block succ = rb.getSuccessor();
                    assert (succ != null) : "regular basic block without non-exceptional successor unexpected";
                    this.propagateStoresTo(succ, lastNode, this.currentInput, rb.getFlowRule(), addToWorklistAgain);
                    break;
                }
                case EXCEPTION_BLOCK: {
                    Block succ;
                    ExceptionBlock eb = (ExceptionBlock)b;
                    TransferInput<A, S> inputBefore = this.getInputBefore(eb);
                    this.currentInput = inputBefore.copy();
                    Node node = eb.getNode();
                    TransferResult<A, S> transferResult = this.callTransferFunction(node, this.currentInput);
                    A val = transferResult.getResultValue();
                    boolean addToWorklistAgain = false;
                    if (val != null) {
                        addToWorklistAgain = this.updateNodeValues(node, val);
                    }
                    if ((succ = eb.getSuccessor()) != null) {
                        this.currentInput = new TransferInput(node, this, transferResult);
                        this.propagateStoresTo(succ, node, this.currentInput, eb.getFlowRule(), addToWorklistAgain);
                    }
                    for (Map.Entry<TypeMirror, Set<Block>> e : eb.getExceptionalSuccessors().entrySet()) {
                        TypeMirror cause = e.getKey();
                        S exceptionalStore = transferResult.getExceptionalStore(cause);
                        if (exceptionalStore != null) {
                            for (Block exceptionSucc : e.getValue()) {
                                this.addStoreBefore(exceptionSucc, node, exceptionalStore, Store.Kind.BOTH, addToWorklistAgain);
                            }
                            continue;
                        }
                        for (Block exceptionSucc : e.getValue()) {
                            this.addStoreBefore(exceptionSucc, node, inputBefore.copy().getRegularStore(), Store.Kind.BOTH, addToWorklistAgain);
                        }
                    }
                    continue block6;
                }
                case CONDITIONAL_BLOCK: {
                    ConditionalBlock cb = (ConditionalBlock)b;
                    TransferInput<A, S> inputBefore = this.getInputBefore(cb);
                    TransferInput<A, S> input = inputBefore.copy();
                    Block thenSucc = cb.getThenSuccessor();
                    Block elseSucc = cb.getElseSuccessor();
                    this.propagateStoresTo(thenSucc, null, input, cb.getThenFlowRule(), false);
                    this.propagateStoresTo(elseSucc, null, input, cb.getElseFlowRule(), false);
                    break;
                }
                case SPECIAL_BLOCK: {
                    SpecialBlock sb = (SpecialBlock)b;
                    Block succ = sb.getSuccessor();
                    if (succ == null) continue block6;
                    this.propagateStoresTo(succ, null, this.getInputBefore(b), sb.getFlowRule(), false);
                    break;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        assert (this.isRunning);
        this.isRunning = false;
    }

    protected void propagateStoresTo(Block succ, Node node, TransferInput<A, S> currentInput, Store.FlowRule flowRule, boolean addToWorklistAgain) {
        switch (flowRule) {
            case EACH_TO_EACH: {
                if (currentInput.containsTwoStores()) {
                    this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.THEN, addToWorklistAgain);
                    this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.ELSE, addToWorklistAgain);
                    break;
                }
                this.addStoreBefore(succ, node, currentInput.getRegularStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case THEN_TO_BOTH: {
                this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case ELSE_TO_BOTH: {
                this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.BOTH, addToWorklistAgain);
                break;
            }
            case THEN_TO_THEN: {
                this.addStoreBefore(succ, node, currentInput.getThenStore(), Store.Kind.THEN, addToWorklistAgain);
                break;
            }
            case ELSE_TO_ELSE: {
                this.addStoreBefore(succ, node, currentInput.getElseStore(), Store.Kind.ELSE, addToWorklistAgain);
            }
        }
    }

    protected boolean updateNodeValues(Node n, A val) {
        AbstractValue oldVal = (AbstractValue)this.nodeValues.get(n);
        this.nodeValues.put(n, val);
        boolean result = (oldVal == null || val == null) && val != oldVal || !oldVal.equals(val);
        return result;
    }

    protected TransferResult<A, S> callTransferFunction(Node node, TransferInput<A, S> store) {
        LocalVariableNode lhs;
        Element elem;
        AssignmentNode assignment;
        Node lhst;
        if (node.isLValue()) {
            return new RegularTransferResult<Object, S>(null, store.getRegularStore());
        }
        store.node = node;
        this.currentNode = node;
        TransferResult transferResult = (TransferResult)node.accept(this.transferFunction, store);
        this.currentNode = null;
        if (node instanceof ReturnNode) {
            this.storesAtReturnStatements.put((ReturnNode)node, transferResult);
        }
        if (node instanceof AssignmentNode && (lhst = (assignment = (AssignmentNode)node).getTarget()) instanceof LocalVariableNode && ElementUtils.isEffectivelyFinal(elem = (lhs = (LocalVariableNode)lhst).getElement())) {
            this.finalLocalValues.put(elem, transferResult.getResultValue());
        }
        return transferResult;
    }

    protected void init(ControlFlowGraph cfg) {
        this.cfg = cfg;
        this.thenStores = new IdentityHashMap();
        this.elseStores = new IdentityHashMap();
        this.inputs = new IdentityHashMap();
        this.storesAtReturnStatements = new IdentityHashMap();
        this.worklist = new Worklist(cfg);
        this.nodeValues = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
        this.worklist.add(cfg.getEntryBlock());
        ArrayList<LocalVariableNode> parameters = null;
        UnderlyingAST underlyingAST = cfg.getUnderlyingAST();
        if (underlyingAST.getKind() == UnderlyingAST.Kind.METHOD) {
            MethodTree tree = ((UnderlyingAST.CFGMethod)underlyingAST).getMethod();
            parameters = new ArrayList<LocalVariableNode>();
            for (VariableTree variableTree : tree.getParameters()) {
                LocalVariableNode var = new LocalVariableNode(variableTree);
                parameters.add(var);
            }
        }
        Object initialStore = this.transferFunction.initialStore(underlyingAST, parameters);
        SpecialBlock entry = cfg.getEntryBlock();
        this.thenStores.put(entry, initialStore);
        this.elseStores.put(entry, initialStore);
        this.inputs.put(entry, new TransferInput(null, this, initialStore));
    }

    protected void addToWorklist(Block b) {
        if (!this.worklist.contains(b)) {
            this.worklist.add(b);
        }
    }

    protected void addStoreBefore(Block b, Node node, S s2, Store.Kind kind, boolean addBlockToWorklist) {
        S thenStore = this.getStoreBefore(b, Store.Kind.THEN);
        S elseStore = this.getStoreBefore(b, Store.Kind.ELSE);
        switch (kind) {
            case THEN: {
                S newThenStore;
                S s3 = newThenStore = thenStore != null ? thenStore.leastUpperBound(s2) : s2;
                if (newThenStore.equals(thenStore)) break;
                this.thenStores.put(b, newThenStore);
                if (elseStore == null) break;
                this.inputs.put(b, new TransferInput(node, this, newThenStore, elseStore));
                addBlockToWorklist = true;
                break;
            }
            case ELSE: {
                S newElseStore;
                S s4 = newElseStore = elseStore != null ? elseStore.leastUpperBound(s2) : s2;
                if (newElseStore.equals(elseStore)) break;
                this.elseStores.put(b, newElseStore);
                if (thenStore == null) break;
                this.inputs.put(b, new TransferInput(node, this, thenStore, newElseStore));
                addBlockToWorklist = true;
                break;
            }
            case BOTH: {
                S newElseStore;
                S newThenStore;
                if (thenStore == elseStore) {
                    S newStore;
                    S s5 = newStore = thenStore != null ? thenStore.leastUpperBound(s2) : s2;
                    if (newStore.equals(thenStore)) break;
                    this.thenStores.put(b, newStore);
                    this.elseStores.put(b, newStore);
                    this.inputs.put(b, new TransferInput(node, this, newStore));
                    addBlockToWorklist = true;
                    break;
                }
                boolean storeChanged = false;
                S s6 = newThenStore = thenStore != null ? thenStore.leastUpperBound(s2) : s2;
                if (!newThenStore.equals(thenStore)) {
                    this.thenStores.put(b, newThenStore);
                    storeChanged = true;
                }
                S s7 = newElseStore = elseStore != null ? elseStore.leastUpperBound(s2) : s2;
                if (!newElseStore.equals(elseStore)) {
                    this.elseStores.put(b, newElseStore);
                    storeChanged = true;
                }
                if (!storeChanged) break;
                this.inputs.put(b, new TransferInput(node, this, newThenStore, newElseStore));
                addBlockToWorklist = true;
            }
        }
        if (addBlockToWorklist) {
            this.addToWorklist(b);
        }
    }

    public TransferInput<A, S> getInput(Block b) {
        return this.getInputBefore(b);
    }

    protected TransferInput<A, S> getInputBefore(Block b) {
        return this.inputs.get(b);
    }

    protected S getStoreBefore(Block b, Store.Kind kind) {
        switch (kind) {
            case THEN: {
                return (S)((Store)Analysis.readFromStore(this.thenStores, b));
            }
            case ELSE: {
                return (S)((Store)Analysis.readFromStore(this.elseStores, b));
            }
        }
        assert (false);
        return null;
    }

    protected static <S> S readFromStore(Map<Block, S> stores, Block b) {
        return stores.get(b);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public A getValue(Node n) {
        if (this.isRunning) {
            if (this.currentNode == n || this.currentTree != null && this.currentTree == n.getTree()) {
                return null;
            }
            assert (this.currentNode != null);
            assert (!n.isLValue()) : "Did not expect an lvalue, but got " + n;
            if (this.currentNode == n || !this.currentNode.getOperands().contains(n) && !this.currentNode.getTransitiveOperands().contains(n)) {
                return null;
            }
            return (A)((AbstractValue)this.nodeValues.get(n));
        }
        return (A)((AbstractValue)this.nodeValues.get(n));
    }

    public A getValue(Tree t) {
        if (t == this.currentTree) {
            return null;
        }
        Node nodeCorrespondingToTree = this.getNodeForTree(t);
        if (nodeCorrespondingToTree == null || nodeCorrespondingToTree.isLValue()) {
            return null;
        }
        return this.getValue(nodeCorrespondingToTree);
    }

    public Node getNodeForTree(Tree t) {
        return this.cfg.getNodeCorrespondingToTree(t);
    }

    public MethodTree getContainingMethod(Tree t) {
        return this.cfg.getContainingMethod(t);
    }

    public ClassTree getContainingClass(Tree t) {
        return this.cfg.getContainingClass(t);
    }

    public List<Pair<ReturnNode, TransferResult<A, S>>> getReturnStatementStores() {
        ArrayList<Pair<ReturnNode, TransferResult<A, S>>> result = new ArrayList<Pair<ReturnNode, TransferResult<A, S>>>();
        for (ReturnNode returnNode : this.cfg.getReturnNodes()) {
            TransferResult<A, S> store = this.storesAtReturnStatements.get(returnNode);
            result.add(Pair.of(returnNode, store));
        }
        return result;
    }

    public AnalysisResult<A, S> getResult() {
        assert (!this.isRunning);
        IdentityHashMap<Tree, Node> treeLookup = this.cfg.getTreeLookup();
        return new AnalysisResult<A, S>(this.nodeValues, this.inputs, treeLookup, this.finalLocalValues);
    }

    public S getRegularExitStore() {
        SpecialBlock regularExitBlock = this.cfg.getRegularExitBlock();
        if (this.inputs.containsKey(regularExitBlock)) {
            S regularExitStore = this.inputs.get(regularExitBlock).getRegularStore();
            return regularExitStore;
        }
        return null;
    }

    public S getExceptionalExitStore() {
        S exceptionalExitStore = this.inputs.get(this.cfg.getExceptionalExitBlock()).getRegularStore();
        return exceptionalExitStore;
    }

    protected static class Worklist {
        protected IdentityHashMap<Block, Integer> depthFirstOrder = new IdentityHashMap();
        protected PriorityQueue<Block> queue;

        public Worklist(ControlFlowGraph cfg) {
            int count = 1;
            for (Block b : cfg.getDepthFirstOrderedBlocks()) {
                this.depthFirstOrder.put(b, count++);
            }
            this.queue = new PriorityQueue<Block>(11, new DFOComparator());
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public boolean contains(Block block) {
            return this.queue.contains(block);
        }

        public void add(Block block) {
            this.queue.add(block);
        }

        public Block poll() {
            return this.queue.poll();
        }

        public String toString() {
            return "Worklist(" + this.queue + ")";
        }

        public class DFOComparator
        implements Comparator<Block> {
            @Override
            public int compare(Block b1, Block b2) {
                return Worklist.this.depthFirstOrder.get(b1) - Worklist.this.depthFirstOrder.get(b2);
            }
        }
    }
}

