/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed.bluez;

import com.welie.blessed.bluez.AbstractBluetoothObject;
import com.welie.blessed.bluez.BluezDeviceType;
import com.welie.blessed.bluez.PairingDelegate;
import org.bluez.Agent1;
import org.bluez.exceptions.BluezCanceledException;
import org.bluez.exceptions.BluezRejectedException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.types.UInt16;
import org.freedesktop.dbus.types.UInt32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PairingAgent
extends AbstractBluetoothObject
implements Agent1 {
    private static final String TAG = PairingAgent.class.getSimpleName();
    private final Logger logger = LoggerFactory.getLogger(TAG);
    private final PairingDelegate pairingDelegate;

    public PairingAgent(String _dbusPath, DBusConnection _dbusConnection, PairingDelegate pairingDelegate) {
        super(BluezDeviceType.AGENT, _dbusConnection, _dbusPath);
        this.pairingDelegate = pairingDelegate;
        try {
            _dbusConnection.exportObject(_dbusPath, this);
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return Agent1.class;
    }

    @Override
    public void Release() {
    }

    @Override
    public String RequestPinCode(DBusPath _device) throws BluezRejectedException, BluezCanceledException {
        this.logger.info("peripheral sending RequestPinCode");
        return null;
    }

    @Override
    public void DisplayPinCode(DBusPath _device, String _pincode) throws BluezRejectedException, BluezCanceledException {
        this.logger.info("peripheral sending DisplayPinCode");
    }

    @Override
    public UInt32 RequestPasskey(DBusPath _device) throws BluezRejectedException, BluezCanceledException {
        String deviceAddress = this.path2deviceAddress(_device);
        this.pairingDelegate.onPairingStarted(deviceAddress);
        String passKeyString = this.pairingDelegate.requestPassCode(deviceAddress);
        return new UInt32(passKeyString);
    }

    @Override
    public void DisplayPasskey(DBusPath _device, UInt32 _passkey, UInt16 _entered) {
        this.logger.info("peripheral sending DisplayPasskey");
    }

    @Override
    public void RequestConfirmation(DBusPath _device, UInt32 _passkey) throws BluezRejectedException, BluezCanceledException {
        this.logger.info("peripheral sending RequestConfirmation");
    }

    @Override
    public void RequestAuthorization(DBusPath _device) throws BluezRejectedException, BluezCanceledException {
        this.pairingDelegate.onPairingStarted(this.path2deviceAddress(_device));
        this.logger.info("peripheral sending RequestAuthorization");
    }

    @Override
    public void AuthorizeService(DBusPath _device, String _uuid) throws BluezRejectedException, BluezCanceledException {
        this.logger.info("peripheral sending AuthorizeService");
    }

    @Override
    public void Cancel() {
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public String getObjectPath() {
        return this.getDbusPath();
    }

    String path2deviceAddress(DBusPath device) {
        String[] pathElements = device.getPath().split("/");
        String deviceName = pathElements[pathElements.length - 1];
        return deviceName.substring(4).replace("_", ":");
    }
}

