/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluetoothBytesParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanResult {
    private long timestampNanos;
    private final String name;
    private final String address;
    @NotNull
    private final List<UUID> uuids;
    private int rssi;
    private Map<@NotNull Integer, byte[]> manufacturerData;
    private Map<@NotNull String, byte[]> serviceData;

    public ScanResult(@Nullable String deviceName, @NotNull String deviceAddress, @NotNull @NotNull List<@NotNull UUID> uuids, int rssi, @NotNull @NotNull Map<@NotNull Integer, byte[]> manufacturerData, @NotNull @NotNull Map<@NotNull String, byte[]> serviceData) {
        this.name = deviceName;
        this.address = Objects.requireNonNull(deviceAddress, "no valid address supplied");
        this.uuids = Objects.requireNonNull(uuids, "no valid uuids supplied");
        this.rssi = rssi;
        this.setManufacturerData(manufacturerData);
        this.setServiceData(serviceData);
        this.stamp();
    }

    public long getTimestampNanos() {
        return this.timestampNanos;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getAddress() {
        return this.address;
    }

    public int getRssi() {
        return this.rssi;
    }

    @NotNull
    public List<UUID> getUuids() {
        return this.uuids;
    }

    @NotNull
    public Map<Integer, byte[]> getManufacturerData() {
        return this.manufacturerData;
    }

    @NotNull
    public Map<String, byte[]> getServiceData() {
        return this.serviceData;
    }

    void setRssi(int rssi) {
        this.rssi = rssi;
    }

    void setManufacturerData(@NotNull @NotNull Map<@NotNull Integer, byte[]> manufacturerData) {
        this.manufacturerData = Objects.requireNonNull(manufacturerData, "no valid manufacturer data supplied");
    }

    void setServiceData(@NotNull @NotNull Map<@NotNull String, byte[]> serviceData) {
        this.serviceData = Objects.requireNonNull(serviceData, "no valid service data supplied");
    }

    public String toString() {
        return "ScanResult{timestampNanos=" + this.timestampNanos + ", name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", uuids=" + this.uuids + ", rssi=" + this.rssi + ", manufacturerData=" + this.manufacturerDataToString() + ", serviceData=" + this.serviceDataToString() + '}';
    }

    private String manufacturerDataToString() {
        if (this.manufacturerData == null || this.manufacturerData.isEmpty()) {
            return "[]";
        }
        StringBuilder result = new StringBuilder("[");
        this.manufacturerData.forEach((code, bytes) -> result.append(String.format("0x%04x->0x%s,", code, BluetoothBytesParser.bytes2String(bytes))));
        result.deleteCharAt(result.length() - 1);
        result.append("]");
        return result.toString();
    }

    private String serviceDataToString() {
        if (this.serviceData == null || this.serviceData.isEmpty()) {
            return "[]";
        }
        StringBuilder result = new StringBuilder("[");
        this.serviceData.forEach((uuid, bytes) -> result.append(String.format("%s->0x%s,", uuid, BluetoothBytesParser.bytes2String(bytes))));
        result.deleteCharAt(result.length() - 1);
        result.append("]");
        return result.toString();
    }

    void stamp() {
        this.timestampNanos = System.nanoTime();
    }
}

