/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import com.welie.blessed.BluezSignalHandler;
import com.welie.blessed.bluez.BluezAdapter;
import com.welie.blessed.bluez.DbusHelper;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BluezAdapterProvider {
    @Nullable
    public final DBusConnection dBusConnection;
    @Nullable
    public final BluezAdapter adapter;

    public BluezAdapterProvider() {
        DBusConnection tempConnection = null;
        try {
            tempConnection = DBusConnection.newConnection(DBusConnection.DBusBusType.SYSTEM);
            tempConnection.changeThreadCount((byte)1);
        }
        catch (DBusException e) {
            e.printStackTrace();
        }
        this.dBusConnection = tempConnection;
        this.adapter = this.chooseBluezAdapter(DbusHelper.findBluezAdapters(this.dBusConnection));
        BluezSignalHandler.createInstance(this.dBusConnection);
    }

    @Nullable
    private BluezAdapter chooseBluezAdapter(@NotNull @NotNull List<@NotNull BluezAdapter> adapters) {
        Objects.requireNonNull(adapters);
        if (adapters.isEmpty()) {
            return null;
        }
        adapters.sort(Comparator.comparing(BluezAdapter::getDeviceName));
        return adapters.get(adapters.size() - 1);
    }
}

