/*
 * Decompiled with CFR 0.152.
 */
package checkers.formatter;

import checkers.flow.CFAbstractTransfer;
import checkers.flow.CFStore;
import checkers.flow.CFValue;
import checkers.formatter.FormatterAnalysis;
import checkers.formatter.FormatterAnnotatedTypeFactory;
import checkers.formatter.FormatterChecker;
import checkers.formatter.FormatterTreeUtil;
import checkers.formatter.quals.ConversionCategory;
import dataflow.analysis.RegularTransferResult;
import dataflow.analysis.TransferInput;
import dataflow.analysis.TransferResult;
import dataflow.cfg.node.MethodInvocationNode;
import javax.lang.model.element.AnnotationMirror;

public class FormatterTransfer
extends CFAbstractTransfer<CFValue, CFStore, FormatterTransfer> {
    protected FormatterAnalysis analysis;
    protected FormatterChecker checker;

    public FormatterTransfer(FormatterAnalysis analysis, FormatterChecker checker) {
        super(analysis);
        this.analysis = analysis;
        this.checker = checker;
    }

    @Override
    public TransferResult<CFValue, CFStore> visitMethodInvocation(MethodInvocationNode node, TransferInput<CFValue, CFStore> in) {
        FormatterAnnotatedTypeFactory atypeFactory = (FormatterAnnotatedTypeFactory)this.analysis.getTypeFactory();
        TransferResult<CFValue, CFStore> result = super.visitMethodInvocation(node, in);
        FormatterTreeUtil tu = atypeFactory.treeUtil;
        if (tu.isAsFormatCall(node, atypeFactory)) {
            FormatterTreeUtil.Result<ConversionCategory[]> cats = tu.asFormatCallCategories(node);
            if (cats.value() == null) {
                tu.failure(cats, "format.asformat.indirect.arguments", new Object[0]);
            } else {
                AnnotationMirror anno = atypeFactory.treeUtil.categoriesToFormatAnnotation(cats.value());
                CFValue newResultValue = (CFValue)this.analysis.createSingleAnnotationValue(anno, result.getResultValue().getType().getUnderlyingType());
                return new RegularTransferResult<CFValue, CFStore>(newResultValue, result.getRegularStore());
            }
        }
        return result;
    }
}

