/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.Map;

public class AppenderRefModelHandler
extends ModelHandlerBase {
    boolean inError = false;

    public AppenderRefModelHandler(Context context) {
        super(context);
    }

    protected Class<? extends AppenderRefModel> getSupportedModelClass() {
        return AppenderRefModel.class;
    }

    @Override
    public void handle(InterpretationContext intercon, Model model) throws ModelHandlerException {
        Object o = intercon.peekObject();
        if (!(o instanceof AppenderAttachable)) {
            this.inError = true;
            String errMsg = "Could not find an AppenderAttachable at the top of execution stack. Near " + model.idString();
            this.addError(errMsg);
            return;
        }
        AppenderRefModel appenderRefModel = (AppenderRefModel)model;
        AppenderAttachable appenderAttachable = (AppenderAttachable)o;
        String appenderName = intercon.subst(appenderRefModel.getRef());
        Map appenderRefBag = (Map)intercon.getObjectMap().get("APPENDER_REF_BAG");
        appenderRefBag.put(appenderName, appenderAttachable);
    }
}

