/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.LoggerModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.util.OptionHelper;

public class LoggerModelHandler
extends ModelHandlerBase {
    Logger logger;
    boolean inError = false;

    public LoggerModelHandler(Context context) {
        super(context);
    }

    protected Class<LoggerModel> getSupportedModelClass() {
        return LoggerModel.class;
    }

    @Override
    public void handle(InterpretationContext intercon, Model model) throws ModelHandlerException {
        String additivityStr;
        this.inError = false;
        LoggerModel loggerModel = (LoggerModel)model;
        String finalLoggerName = intercon.subst(loggerModel.getName());
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.logger = loggerContext.getLogger(finalLoggerName);
        String levelStr = intercon.subst(loggerModel.getLevel());
        if (!OptionHelper.isNullOrEmpty(levelStr)) {
            if ("INHERITED".equalsIgnoreCase(levelStr) || "NULL".equalsIgnoreCase(levelStr)) {
                this.addInfo("Setting level of logger [" + finalLoggerName + "] to null, i.e. INHERITED");
                this.logger.setLevel(null);
            } else {
                Level level = Level.toLevel(levelStr);
                this.addInfo("Setting level of logger [" + finalLoggerName + "] to " + level);
                this.logger.setLevel(level);
            }
        }
        if (!OptionHelper.isNullOrEmpty(additivityStr = intercon.subst(loggerModel.getAdditivity()))) {
            boolean additive = OptionHelper.toBoolean(additivityStr, true);
            this.addInfo("Setting additivity of logger [" + finalLoggerName + "] to " + additive);
            this.logger.setAdditive(additive);
        }
        intercon.pushObject(this.logger);
    }

    @Override
    public void postHandle(InterpretationContext intercon, Model model) {
        if (this.inError) {
            return;
        }
        Object o = intercon.peekObject();
        if (o != this.logger) {
            LoggerModel loggerModel = (LoggerModel)model;
            this.addWarn("The object [" + o + "] on the top the of the stack is not the expected logger named " + loggerModel.getName());
        } else {
            intercon.popObject();
        }
    }
}

