/*
 * Decompiled with CFR 0.152.
 */
package cfjapa.parser.ast.visitor;

import cfjapa.parser.ast.BlockComment;
import cfjapa.parser.ast.CompilationUnit;
import cfjapa.parser.ast.ImportDeclaration;
import cfjapa.parser.ast.IndexUnit;
import cfjapa.parser.ast.LineComment;
import cfjapa.parser.ast.PackageDeclaration;
import cfjapa.parser.ast.TypeParameter;
import cfjapa.parser.ast.body.AnnotationDeclaration;
import cfjapa.parser.ast.body.AnnotationMemberDeclaration;
import cfjapa.parser.ast.body.BodyDeclaration;
import cfjapa.parser.ast.body.ClassOrInterfaceDeclaration;
import cfjapa.parser.ast.body.ConstructorDeclaration;
import cfjapa.parser.ast.body.EmptyMemberDeclaration;
import cfjapa.parser.ast.body.EmptyTypeDeclaration;
import cfjapa.parser.ast.body.EnumConstantDeclaration;
import cfjapa.parser.ast.body.EnumDeclaration;
import cfjapa.parser.ast.body.FieldDeclaration;
import cfjapa.parser.ast.body.InitializerDeclaration;
import cfjapa.parser.ast.body.JavadocComment;
import cfjapa.parser.ast.body.MethodDeclaration;
import cfjapa.parser.ast.body.Parameter;
import cfjapa.parser.ast.body.TypeDeclaration;
import cfjapa.parser.ast.body.VariableDeclarator;
import cfjapa.parser.ast.body.VariableDeclaratorId;
import cfjapa.parser.ast.expr.AnnotationExpr;
import cfjapa.parser.ast.expr.ArrayAccessExpr;
import cfjapa.parser.ast.expr.ArrayCreationExpr;
import cfjapa.parser.ast.expr.ArrayInitializerExpr;
import cfjapa.parser.ast.expr.AssignExpr;
import cfjapa.parser.ast.expr.BinaryExpr;
import cfjapa.parser.ast.expr.BooleanLiteralExpr;
import cfjapa.parser.ast.expr.CastExpr;
import cfjapa.parser.ast.expr.CharLiteralExpr;
import cfjapa.parser.ast.expr.ClassExpr;
import cfjapa.parser.ast.expr.ConditionalExpr;
import cfjapa.parser.ast.expr.DoubleLiteralExpr;
import cfjapa.parser.ast.expr.EnclosedExpr;
import cfjapa.parser.ast.expr.Expression;
import cfjapa.parser.ast.expr.FieldAccessExpr;
import cfjapa.parser.ast.expr.InstanceOfExpr;
import cfjapa.parser.ast.expr.IntegerLiteralExpr;
import cfjapa.parser.ast.expr.IntegerLiteralMinValueExpr;
import cfjapa.parser.ast.expr.LongLiteralExpr;
import cfjapa.parser.ast.expr.LongLiteralMinValueExpr;
import cfjapa.parser.ast.expr.MarkerAnnotationExpr;
import cfjapa.parser.ast.expr.MemberValuePair;
import cfjapa.parser.ast.expr.MethodCallExpr;
import cfjapa.parser.ast.expr.NameExpr;
import cfjapa.parser.ast.expr.NormalAnnotationExpr;
import cfjapa.parser.ast.expr.NullLiteralExpr;
import cfjapa.parser.ast.expr.ObjectCreationExpr;
import cfjapa.parser.ast.expr.QualifiedNameExpr;
import cfjapa.parser.ast.expr.SingleMemberAnnotationExpr;
import cfjapa.parser.ast.expr.StringLiteralExpr;
import cfjapa.parser.ast.expr.SuperExpr;
import cfjapa.parser.ast.expr.ThisExpr;
import cfjapa.parser.ast.expr.UnaryExpr;
import cfjapa.parser.ast.expr.VariableDeclarationExpr;
import cfjapa.parser.ast.stmt.AssertStmt;
import cfjapa.parser.ast.stmt.BlockStmt;
import cfjapa.parser.ast.stmt.BreakStmt;
import cfjapa.parser.ast.stmt.CatchClause;
import cfjapa.parser.ast.stmt.ContinueStmt;
import cfjapa.parser.ast.stmt.DoStmt;
import cfjapa.parser.ast.stmt.EmptyStmt;
import cfjapa.parser.ast.stmt.ExplicitConstructorInvocationStmt;
import cfjapa.parser.ast.stmt.ExpressionStmt;
import cfjapa.parser.ast.stmt.ForStmt;
import cfjapa.parser.ast.stmt.ForeachStmt;
import cfjapa.parser.ast.stmt.IfStmt;
import cfjapa.parser.ast.stmt.LabeledStmt;
import cfjapa.parser.ast.stmt.ReturnStmt;
import cfjapa.parser.ast.stmt.Statement;
import cfjapa.parser.ast.stmt.SwitchEntryStmt;
import cfjapa.parser.ast.stmt.SwitchStmt;
import cfjapa.parser.ast.stmt.SynchronizedStmt;
import cfjapa.parser.ast.stmt.ThrowStmt;
import cfjapa.parser.ast.stmt.TryStmt;
import cfjapa.parser.ast.stmt.TypeDeclarationStmt;
import cfjapa.parser.ast.stmt.WhileStmt;
import cfjapa.parser.ast.type.ClassOrInterfaceType;
import cfjapa.parser.ast.type.PrimitiveType;
import cfjapa.parser.ast.type.ReferenceType;
import cfjapa.parser.ast.type.Type;
import cfjapa.parser.ast.type.VoidType;
import cfjapa.parser.ast.type.WildcardType;
import cfjapa.parser.ast.visitor.VoidVisitor;

public abstract class VoidVisitorAdapter<A>
implements VoidVisitor<A> {
    @Override
    public void visit(AnnotationDeclaration annotationDeclaration, A a) {
        if (annotationDeclaration.getJavaDoc() != null) {
            annotationDeclaration.getJavaDoc().accept(this, a);
        }
        if (annotationDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : annotationDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (annotationDeclaration.getMembers() != null) {
            for (BodyDeclaration bodyDeclaration : annotationDeclaration.getMembers()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(AnnotationMemberDeclaration annotationMemberDeclaration, A a) {
        if (annotationMemberDeclaration.getJavaDoc() != null) {
            annotationMemberDeclaration.getJavaDoc().accept(this, a);
        }
        if (annotationMemberDeclaration.getAnnotations() != null) {
            for (AnnotationExpr annotationExpr : annotationMemberDeclaration.getAnnotations()) {
                annotationExpr.accept(this, a);
            }
        }
        annotationMemberDeclaration.getType().accept(this, a);
        if (annotationMemberDeclaration.getDefaultValue() != null) {
            annotationMemberDeclaration.getDefaultValue().accept(this, a);
        }
    }

    @Override
    public void visit(ArrayAccessExpr arrayAccessExpr, A a) {
        arrayAccessExpr.getName().accept(this, a);
        arrayAccessExpr.getIndex().accept(this, a);
    }

    @Override
    public void visit(ArrayCreationExpr arrayCreationExpr, A a) {
        arrayCreationExpr.getType().accept(this, a);
        if (arrayCreationExpr.getDimensions() != null) {
            for (Expression expression : arrayCreationExpr.getDimensions()) {
                expression.accept(this, a);
            }
        } else {
            arrayCreationExpr.getInitializer().accept(this, a);
        }
    }

    @Override
    public void visit(ArrayInitializerExpr arrayInitializerExpr, A a) {
        if (arrayInitializerExpr.getValues() != null) {
            for (Expression expression : arrayInitializerExpr.getValues()) {
                expression.accept(this, a);
            }
        }
    }

    @Override
    public void visit(AssertStmt assertStmt, A a) {
        assertStmt.getCheck().accept(this, a);
        if (assertStmt.getMessage() != null) {
            assertStmt.getMessage().accept(this, a);
        }
    }

    @Override
    public void visit(AssignExpr assignExpr, A a) {
        assignExpr.getTarget().accept(this, a);
        assignExpr.getValue().accept(this, a);
    }

    @Override
    public void visit(BinaryExpr binaryExpr, A a) {
        binaryExpr.getLeft().accept(this, a);
        binaryExpr.getRight().accept(this, a);
    }

    @Override
    public void visit(BlockComment blockComment, A a) {
    }

    @Override
    public void visit(BlockStmt blockStmt, A a) {
        if (blockStmt.getStmts() != null) {
            for (Statement statement : blockStmt.getStmts()) {
                statement.accept(this, a);
            }
        }
    }

    @Override
    public void visit(BooleanLiteralExpr booleanLiteralExpr, A a) {
    }

    @Override
    public void visit(BreakStmt breakStmt, A a) {
    }

    @Override
    public void visit(CastExpr castExpr, A a) {
        castExpr.getType().accept(this, a);
        castExpr.getExpr().accept(this, a);
    }

    @Override
    public void visit(CatchClause catchClause, A a) {
        catchClause.getExcept().accept(this, a);
        catchClause.getCatchBlock().accept(this, a);
    }

    @Override
    public void visit(CharLiteralExpr charLiteralExpr, A a) {
    }

    @Override
    public void visit(ClassExpr classExpr, A a) {
        classExpr.getType().accept(this, a);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration classOrInterfaceDeclaration, A a) {
        if (classOrInterfaceDeclaration.getJavaDoc() != null) {
            classOrInterfaceDeclaration.getJavaDoc().accept(this, a);
        }
        if (classOrInterfaceDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : classOrInterfaceDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getTypeParameters() != null) {
            for (TypeParameter typeParameter : classOrInterfaceDeclaration.getTypeParameters()) {
                typeParameter.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getExtends() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : classOrInterfaceDeclaration.getExtends()) {
                classOrInterfaceType.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getImplements() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : classOrInterfaceDeclaration.getImplements()) {
                classOrInterfaceType.accept(this, a);
            }
        }
        if (classOrInterfaceDeclaration.getMembers() != null) {
            for (BodyDeclaration bodyDeclaration : classOrInterfaceDeclaration.getMembers()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ClassOrInterfaceType classOrInterfaceType, A a) {
        if (classOrInterfaceType.getScope() != null) {
            classOrInterfaceType.getScope().accept(this, a);
        }
        if (classOrInterfaceType.getTypeArgs() != null) {
            for (Type type : classOrInterfaceType.getTypeArgs()) {
                type.accept(this, a);
            }
        }
    }

    @Override
    public void visit(CompilationUnit compilationUnit, A a) {
        if (compilationUnit.getPackage() != null) {
            compilationUnit.getPackage().accept(this, a);
        }
        if (compilationUnit.getImports() != null) {
            for (ImportDeclaration node : compilationUnit.getImports()) {
                node.accept(this, a);
            }
        }
        if (compilationUnit.getTypes() != null) {
            for (TypeDeclaration typeDeclaration : compilationUnit.getTypes()) {
                typeDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ConditionalExpr conditionalExpr, A a) {
        conditionalExpr.getCondition().accept(this, a);
        conditionalExpr.getThenExpr().accept(this, a);
        conditionalExpr.getElseExpr().accept(this, a);
    }

    @Override
    public void visit(ConstructorDeclaration constructorDeclaration, A a) {
        if (constructorDeclaration.getJavaDoc() != null) {
            constructorDeclaration.getJavaDoc().accept(this, a);
        }
        if (constructorDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : constructorDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (constructorDeclaration.getTypeParameters() != null) {
            for (TypeParameter typeParameter : constructorDeclaration.getTypeParameters()) {
                typeParameter.accept(this, a);
            }
        }
        if (constructorDeclaration.getParameters() != null) {
            for (Parameter parameter : constructorDeclaration.getParameters()) {
                parameter.accept(this, a);
            }
        }
        if (constructorDeclaration.getThrows() != null) {
            for (NameExpr nameExpr : constructorDeclaration.getThrows()) {
                nameExpr.accept(this, a);
            }
        }
        constructorDeclaration.getBlock().accept(this, a);
    }

    @Override
    public void visit(ContinueStmt continueStmt, A a) {
    }

    @Override
    public void visit(DoStmt doStmt, A a) {
        doStmt.getBody().accept(this, a);
        doStmt.getCondition().accept(this, a);
    }

    @Override
    public void visit(DoubleLiteralExpr doubleLiteralExpr, A a) {
    }

    @Override
    public void visit(EmptyMemberDeclaration emptyMemberDeclaration, A a) {
        if (emptyMemberDeclaration.getJavaDoc() != null) {
            emptyMemberDeclaration.getJavaDoc().accept(this, a);
        }
    }

    @Override
    public void visit(EmptyStmt emptyStmt, A a) {
    }

    @Override
    public void visit(EmptyTypeDeclaration emptyTypeDeclaration, A a) {
        if (emptyTypeDeclaration.getJavaDoc() != null) {
            emptyTypeDeclaration.getJavaDoc().accept(this, a);
        }
    }

    @Override
    public void visit(EnclosedExpr enclosedExpr, A a) {
        enclosedExpr.getInner().accept(this, a);
    }

    @Override
    public void visit(EnumConstantDeclaration enumConstantDeclaration, A a) {
        if (enumConstantDeclaration.getJavaDoc() != null) {
            enumConstantDeclaration.getJavaDoc().accept(this, a);
        }
        if (enumConstantDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : enumConstantDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (enumConstantDeclaration.getArgs() != null) {
            for (Expression expression : enumConstantDeclaration.getArgs()) {
                expression.accept(this, a);
            }
        }
        if (enumConstantDeclaration.getClassBody() != null) {
            for (BodyDeclaration bodyDeclaration : enumConstantDeclaration.getClassBody()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(EnumDeclaration enumDeclaration, A a) {
        if (enumDeclaration.getJavaDoc() != null) {
            enumDeclaration.getJavaDoc().accept(this, a);
        }
        if (enumDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : enumDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (enumDeclaration.getImplements() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : enumDeclaration.getImplements()) {
                classOrInterfaceType.accept(this, a);
            }
        }
        if (enumDeclaration.getEntries() != null) {
            for (EnumConstantDeclaration enumConstantDeclaration : enumDeclaration.getEntries()) {
                enumConstantDeclaration.accept(this, a);
            }
        }
        if (enumDeclaration.getMembers() != null) {
            for (BodyDeclaration bodyDeclaration : enumDeclaration.getMembers()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt explicitConstructorInvocationStmt, A a) {
        if (!explicitConstructorInvocationStmt.isThis() && explicitConstructorInvocationStmt.getExpr() != null) {
            explicitConstructorInvocationStmt.getExpr().accept(this, a);
        }
        if (explicitConstructorInvocationStmt.getTypeArgs() != null) {
            for (Type node : explicitConstructorInvocationStmt.getTypeArgs()) {
                node.accept(this, a);
            }
        }
        if (explicitConstructorInvocationStmt.getArgs() != null) {
            for (Expression expression : explicitConstructorInvocationStmt.getArgs()) {
                expression.accept(this, a);
            }
        }
    }

    @Override
    public void visit(ExpressionStmt expressionStmt, A a) {
        expressionStmt.getExpression().accept(this, a);
    }

    @Override
    public void visit(FieldAccessExpr fieldAccessExpr, A a) {
        fieldAccessExpr.getScope().accept(this, a);
    }

    @Override
    public void visit(FieldDeclaration fieldDeclaration, A a) {
        if (fieldDeclaration.getJavaDoc() != null) {
            fieldDeclaration.getJavaDoc().accept(this, a);
        }
        if (fieldDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : fieldDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        fieldDeclaration.getType().accept(this, a);
        for (VariableDeclarator variableDeclarator : fieldDeclaration.getVariables()) {
            variableDeclarator.accept(this, a);
        }
    }

    @Override
    public void visit(ForeachStmt foreachStmt, A a) {
        foreachStmt.getVariable().accept(this, a);
        foreachStmt.getIterable().accept(this, a);
        foreachStmt.getBody().accept(this, a);
    }

    @Override
    public void visit(ForStmt forStmt, A a) {
        if (forStmt.getInit() != null) {
            for (Expression expression : forStmt.getInit()) {
                expression.accept(this, a);
            }
        }
        if (forStmt.getCompare() != null) {
            forStmt.getCompare().accept(this, a);
        }
        if (forStmt.getUpdate() != null) {
            for (Expression expression : forStmt.getUpdate()) {
                expression.accept(this, a);
            }
        }
        forStmt.getBody().accept(this, a);
    }

    @Override
    public void visit(IfStmt ifStmt, A a) {
        ifStmt.getCondition().accept(this, a);
        ifStmt.getThenStmt().accept(this, a);
        if (ifStmt.getElseStmt() != null) {
            ifStmt.getElseStmt().accept(this, a);
        }
    }

    @Override
    public void visit(ImportDeclaration importDeclaration, A a) {
        importDeclaration.getName().accept(this, a);
    }

    @Override
    public void visit(InitializerDeclaration initializerDeclaration, A a) {
        if (initializerDeclaration.getJavaDoc() != null) {
            initializerDeclaration.getJavaDoc().accept(this, a);
        }
        initializerDeclaration.getBlock().accept(this, a);
    }

    @Override
    public void visit(InstanceOfExpr instanceOfExpr, A a) {
        instanceOfExpr.getExpr().accept(this, a);
        instanceOfExpr.getType().accept(this, a);
    }

    @Override
    public void visit(IntegerLiteralExpr integerLiteralExpr, A a) {
    }

    @Override
    public void visit(IntegerLiteralMinValueExpr integerLiteralMinValueExpr, A a) {
    }

    @Override
    public void visit(JavadocComment javadocComment, A a) {
    }

    @Override
    public void visit(LabeledStmt labeledStmt, A a) {
        labeledStmt.getStmt().accept(this, a);
    }

    @Override
    public void visit(LineComment lineComment, A a) {
    }

    @Override
    public void visit(LongLiteralExpr longLiteralExpr, A a) {
    }

    @Override
    public void visit(LongLiteralMinValueExpr longLiteralMinValueExpr, A a) {
    }

    @Override
    public void visit(MarkerAnnotationExpr markerAnnotationExpr, A a) {
        markerAnnotationExpr.getName().accept(this, a);
    }

    @Override
    public void visit(MemberValuePair memberValuePair, A a) {
        memberValuePair.getValue().accept(this, a);
    }

    @Override
    public void visit(MethodCallExpr methodCallExpr, A a) {
        if (methodCallExpr.getScope() != null) {
            methodCallExpr.getScope().accept(this, a);
        }
        if (methodCallExpr.getTypeArgs() != null) {
            for (Type node : methodCallExpr.getTypeArgs()) {
                node.accept(this, a);
            }
        }
        if (methodCallExpr.getArgs() != null) {
            for (Expression expression : methodCallExpr.getArgs()) {
                expression.accept(this, a);
            }
        }
    }

    @Override
    public void visit(MethodDeclaration methodDeclaration, A a) {
        if (methodDeclaration.getJavaDoc() != null) {
            methodDeclaration.getJavaDoc().accept(this, a);
        }
        if (methodDeclaration.getAnnotations() != null) {
            for (AnnotationExpr node : methodDeclaration.getAnnotations()) {
                node.accept(this, a);
            }
        }
        if (methodDeclaration.getTypeParameters() != null) {
            for (TypeParameter typeParameter : methodDeclaration.getTypeParameters()) {
                typeParameter.accept(this, a);
            }
        }
        methodDeclaration.getType().accept(this, a);
        if (methodDeclaration.getParameters() != null) {
            for (Parameter parameter : methodDeclaration.getParameters()) {
                parameter.accept(this, a);
            }
        }
        if (methodDeclaration.getThrows() != null) {
            for (NameExpr nameExpr : methodDeclaration.getThrows()) {
                nameExpr.accept(this, a);
            }
        }
        if (methodDeclaration.getBody() != null) {
            methodDeclaration.getBody().accept(this, a);
        }
    }

    @Override
    public void visit(NameExpr nameExpr, A a) {
    }

    @Override
    public void visit(NormalAnnotationExpr normalAnnotationExpr, A a) {
        normalAnnotationExpr.getName().accept(this, a);
        if (normalAnnotationExpr.getPairs() != null) {
            for (MemberValuePair memberValuePair : normalAnnotationExpr.getPairs()) {
                memberValuePair.accept(this, a);
            }
        }
    }

    @Override
    public void visit(NullLiteralExpr nullLiteralExpr, A a) {
    }

    @Override
    public void visit(ObjectCreationExpr objectCreationExpr, A a) {
        if (objectCreationExpr.getScope() != null) {
            objectCreationExpr.getScope().accept(this, a);
        }
        if (objectCreationExpr.getTypeArgs() != null) {
            for (Type node : objectCreationExpr.getTypeArgs()) {
                node.accept(this, a);
            }
        }
        objectCreationExpr.getType().accept(this, a);
        if (objectCreationExpr.getArgs() != null) {
            for (Expression expression : objectCreationExpr.getArgs()) {
                expression.accept(this, a);
            }
        }
        if (objectCreationExpr.getAnonymousClassBody() != null) {
            for (BodyDeclaration bodyDeclaration : objectCreationExpr.getAnonymousClassBody()) {
                bodyDeclaration.accept(this, a);
            }
        }
    }

    @Override
    public void visit(PackageDeclaration packageDeclaration, A a) {
        if (packageDeclaration.getAnnotations() != null) {
            for (AnnotationExpr annotationExpr : packageDeclaration.getAnnotations()) {
                annotationExpr.accept(this, a);
            }
        }
        packageDeclaration.getName().accept(this, a);
    }

    @Override
    public void visit(Parameter parameter, A a) {
        if (parameter.getAnnotations() != null) {
            for (AnnotationExpr annotationExpr : parameter.getAnnotations()) {
                annotationExpr.accept(this, a);
            }
        }
        parameter.getType().accept(this, a);
        parameter.getId().accept(this, a);
    }

    @Override
    public void visit(PrimitiveType primitiveType, A a) {
    }

    @Override
    public void visit(QualifiedNameExpr qualifiedNameExpr, A a) {
        qualifiedNameExpr.getQualifier().accept(this, a);
    }

    @Override
    public void visit(ReferenceType referenceType, A a) {
        referenceType.getType().accept(this, a);
    }

    @Override
    public void visit(ReturnStmt returnStmt, A a) {
        if (returnStmt.getExpr() != null) {
            returnStmt.getExpr().accept(this, a);
        }
    }

    @Override
    public void visit(SingleMemberAnnotationExpr singleMemberAnnotationExpr, A a) {
        singleMemberAnnotationExpr.getName().accept(this, a);
        singleMemberAnnotationExpr.getMemberValue().accept(this, a);
    }

    @Override
    public void visit(StringLiteralExpr stringLiteralExpr, A a) {
    }

    @Override
    public void visit(SuperExpr superExpr, A a) {
        if (superExpr.getClassExpr() != null) {
            superExpr.getClassExpr().accept(this, a);
        }
    }

    @Override
    public void visit(SwitchEntryStmt switchEntryStmt, A a) {
        if (switchEntryStmt.getLabel() != null) {
            switchEntryStmt.getLabel().accept(this, a);
        }
        if (switchEntryStmt.getStmts() != null) {
            for (Statement statement : switchEntryStmt.getStmts()) {
                statement.accept(this, a);
            }
        }
    }

    @Override
    public void visit(SwitchStmt switchStmt, A a) {
        switchStmt.getSelector().accept(this, a);
        if (switchStmt.getEntries() != null) {
            for (SwitchEntryStmt switchEntryStmt : switchStmt.getEntries()) {
                switchEntryStmt.accept(this, a);
            }
        }
    }

    @Override
    public void visit(SynchronizedStmt synchronizedStmt, A a) {
        synchronizedStmt.getExpr().accept(this, a);
        synchronizedStmt.getBlock().accept(this, a);
    }

    @Override
    public void visit(ThisExpr thisExpr, A a) {
        if (thisExpr.getClassExpr() != null) {
            thisExpr.getClassExpr().accept(this, a);
        }
    }

    @Override
    public void visit(ThrowStmt throwStmt, A a) {
        throwStmt.getExpr().accept(this, a);
    }

    @Override
    public void visit(TryStmt tryStmt, A a) {
        tryStmt.getTryBlock().accept(this, a);
        if (tryStmt.getCatchs() != null) {
            for (CatchClause catchClause : tryStmt.getCatchs()) {
                catchClause.accept(this, a);
            }
        }
        if (tryStmt.getFinallyBlock() != null) {
            tryStmt.getFinallyBlock().accept(this, a);
        }
    }

    @Override
    public void visit(TypeDeclarationStmt typeDeclarationStmt, A a) {
        typeDeclarationStmt.getTypeDeclaration().accept(this, a);
    }

    @Override
    public void visit(TypeParameter typeParameter, A a) {
        if (typeParameter.getTypeBound() != null) {
            for (ClassOrInterfaceType classOrInterfaceType : typeParameter.getTypeBound()) {
                classOrInterfaceType.accept(this, a);
            }
        }
    }

    @Override
    public void visit(UnaryExpr unaryExpr, A a) {
        unaryExpr.getExpr().accept(this, a);
    }

    @Override
    public void visit(VariableDeclarationExpr variableDeclarationExpr, A a) {
        if (variableDeclarationExpr.getAnnotations() != null) {
            for (AnnotationExpr node : variableDeclarationExpr.getAnnotations()) {
                node.accept(this, a);
            }
        }
        variableDeclarationExpr.getType().accept(this, a);
        for (VariableDeclarator variableDeclarator : variableDeclarationExpr.getVars()) {
            variableDeclarator.accept(this, a);
        }
    }

    @Override
    public void visit(VariableDeclarator variableDeclarator, A a) {
        variableDeclarator.getId().accept(this, a);
        if (variableDeclarator.getInit() != null) {
            variableDeclarator.getInit().accept(this, a);
        }
    }

    @Override
    public void visit(VariableDeclaratorId variableDeclaratorId, A a) {
    }

    @Override
    public void visit(VoidType voidType, A a) {
    }

    @Override
    public void visit(WhileStmt whileStmt, A a) {
        whileStmt.getCondition().accept(this, a);
        whileStmt.getBody().accept(this, a);
    }

    @Override
    public void visit(WildcardType wildcardType, A a) {
        if (wildcardType.getExtends() != null) {
            wildcardType.getExtends().accept(this, a);
        }
        if (wildcardType.getSuper() != null) {
            wildcardType.getSuper().accept(this, a);
        }
    }

    @Override
    public void visit(IndexUnit indexUnit, A a) {
        for (CompilationUnit compilationUnit : indexUnit.getCompilationUnits()) {
            compilationUnit.accept(this, a);
        }
    }
}

