/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.welie.blessed.AdvertiseError;
import com.welie.blessed.BluetoothBytesParser;
import com.welie.blessed.BluetoothCentral;
import com.welie.blessed.BluetoothCentralManager;
import com.welie.blessed.BluetoothPeripheralManagerCallback;
import com.welie.blessed.BondState;
import com.welie.blessed.GattStatus;
import com.welie.blessed.Logger;
import com.welie.blessed.ReadResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothPeripheralManager {
    private static final String TAG = BluetoothPeripheralManager.class.getSimpleName();
    protected static final UUID CCC_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private static final String CONTEXT_IS_NULL = "context is null";
    private static final String BLUETOOTH_MANAGER_IS_NULL = "BluetoothManager is null";
    private static final String SERVICE_IS_NULL = "service is null";
    private static final String CHARACTERISTIC_IS_NULL = "characteristic is null";
    private static final String DEVICE_IS_NULL = "device is null";
    private static final String CHARACTERISTIC_VALUE_IS_NULL = "characteristic value is null";
    private static final String CENTRAL_IS_NULL = "central is null";
    private static final String ADDRESS_IS_NULL = "address is null";
    @NotNull
    private final Context context;
    @NotNull
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private final BluetoothManager bluetoothManager;
    @NotNull
    private final BluetoothAdapter bluetoothAdapter;
    @NotNull
    private final BluetoothLeAdvertiser bluetoothLeAdvertiser;
    @NotNull
    private final BluetoothGattServer bluetoothGattServer;
    @NotNull
    private final BluetoothPeripheralManagerCallback callback;
    @Nullable
    private BluetoothCentralManager centralManager = null;
    @NotNull
    protected final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    @NotNull
    private final HashMap<BluetoothGattCharacteristic, byte[]> writeLongCharacteristicTemporaryBytes = new HashMap();
    @NotNull
    private final HashMap<BluetoothGattDescriptor, byte[]> writeLongDescriptorTemporaryBytes = new HashMap();
    @NotNull
    private final Map<String, BluetoothCentral> connectedCentralsMap = new ConcurrentHashMap<String, BluetoothCentral>();
    @Nullable
    private BluetoothGattCharacteristic currentNotifyCharacteristic = null;
    @NotNull
    private final HashMap<BluetoothGattCharacteristic, Set<String>> centralsWantingNotifications = new HashMap();
    @NotNull
    private final HashMap<BluetoothGattCharacteristic, Set<String>> centralsWantingIndications = new HashMap();
    @NotNull
    private byte[] currentNotifyValue = new byte[0];
    @NotNull
    private byte[] currentReadValue = new byte[0];
    private volatile boolean commandQueueBusy = false;
    protected final BluetoothGattServerCallback bluetoothGattServerCallback = new BluetoothGattServerCallback(){

        public void onConnectionStateChange(BluetoothDevice device, int status, int newState) {
            if (status == 0) {
                if (newState == 2) {
                    if (BluetoothPeripheralManager.this.centralManager != null && ((BluetoothPeripheralManager)BluetoothPeripheralManager.this).centralManager.unconnectedPeripherals.containsKey(device.getAddress())) {
                        return;
                    }
                    if (BluetoothPeripheralManager.this.connectedCentralsMap.containsKey(device.getAddress())) {
                        return;
                    }
                    BluetoothPeripheralManager.this.bluetoothGattServer.connect(device, false);
                    this.handleDeviceConnected(device);
                } else if (newState == 0) {
                    if (!BluetoothPeripheralManager.this.connectedCentralsMap.containsKey(device.getAddress())) {
                        return;
                    }
                    this.handleDeviceDisconnected(device);
                }
            } else {
                Logger.i(TAG, "Device '%s' disconnected with status %d", device.getName(), status);
                this.handleDeviceDisconnected(device);
            }
        }

        private void handleDeviceConnected(@NotNull BluetoothDevice device) {
            Logger.i(TAG, "Central '%s' (%s) connected", device.getName(), device.getAddress());
            final BluetoothCentral bluetoothCentral = new BluetoothCentral(device);
            BluetoothPeripheralManager.this.connectedCentralsMap.put(bluetoothCentral.getAddress(), bluetoothCentral);
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheralManager.this.callback.onCentralConnected(bluetoothCentral);
                }
            });
        }

        private void handleDeviceDisconnected(@NotNull BluetoothDevice device) {
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            Logger.i(TAG, "Central '%s' (%s) disconnected", bluetoothCentral.getName(), bluetoothCentral.getAddress());
            if (bluetoothCentral.getBondState() != BondState.BONDED) {
                BluetoothPeripheralManager.this.removeCentralFromWantingAnything(bluetoothCentral);
            }
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheralManager.this.callback.onCentralDisconnected(bluetoothCentral);
                }
            });
            BluetoothPeripheralManager.this.removeCentral(device);
        }

        public void onServiceAdded(final int status, final @NotNull BluetoothGattService service) {
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheralManager.this.callback.onServiceAdded(GattStatus.fromValue(status), service);
                }
            });
            BluetoothPeripheralManager.this.completedCommand();
        }

        public void onCharacteristicReadRequest(final @NotNull BluetoothDevice device, final int requestId, final int offset, final @NotNull BluetoothGattCharacteristic characteristic) {
            Logger.i(TAG, "read request for characteristic <%s> with offset %d", characteristic.getUuid(), offset);
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    GattStatus status = GattStatus.SUCCESS;
                    if (offset == 0) {
                        ReadResponse response = BluetoothPeripheralManager.this.callback.onCharacteristicRead(bluetoothCentral, characteristic);
                        Objects.requireNonNull(response, "no valid ReadResponse returned");
                        status = response.status;
                        BluetoothPeripheralManager.access$902(BluetoothPeripheralManager.this, response.value);
                    }
                    byte[] value = BluetoothPeripheralManager.this.chopValue(BluetoothPeripheralManager.this.currentReadValue, offset);
                    BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(device, requestId, status.value, offset, value);
                }
            });
        }

        public void onCharacteristicWriteRequest(final @NotNull BluetoothDevice device, final int requestId, final @NotNull BluetoothGattCharacteristic characteristic, final boolean preparedWrite, final boolean responseNeeded, final int offset, @Nullable byte[] value) {
            Logger.i(TAG, "write characteristic %s request <%s> offset %d for <%s>", responseNeeded ? "WITH_RESPONSE" : "WITHOUT_RESPONSE", BluetoothBytesParser.asHexString(value), offset, characteristic.getUuid());
            final byte[] safeValue = BluetoothPeripheralManager.this.nonnullOf(value);
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    GattStatus status = GattStatus.SUCCESS;
                    if (!preparedWrite) {
                        status = BluetoothPeripheralManager.this.callback.onCharacteristicWrite(bluetoothCentral, characteristic, safeValue);
                        if (status == GattStatus.SUCCESS && Build.VERSION.SDK_INT < 33) {
                            characteristic.setValue(safeValue);
                        }
                    } else if (offset == 0) {
                        BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.put(characteristic, safeValue);
                    } else {
                        byte[] temporaryBytes = (byte[])BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.get(characteristic);
                        if (temporaryBytes != null && offset == temporaryBytes.length) {
                            BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.put(characteristic, BluetoothBytesParser.mergeArrays(temporaryBytes, safeValue));
                        } else {
                            status = GattStatus.INVALID_OFFSET;
                        }
                    }
                    if (responseNeeded) {
                        BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(device, requestId, status.value, offset, safeValue);
                    }
                    if (status == GattStatus.SUCCESS && !preparedWrite) {
                        BluetoothPeripheralManager.this.callback.onCharacteristicWriteCompleted(bluetoothCentral, characteristic, safeValue);
                    }
                }
            });
        }

        public void onDescriptorReadRequest(final @NotNull BluetoothDevice device, final int requestId, final int offset, final @NotNull BluetoothGattDescriptor descriptor) {
            Logger.i(TAG, "read request for descriptor <%s> with offset %d", descriptor.getUuid(), offset);
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    GattStatus status = GattStatus.SUCCESS;
                    if (offset == 0) {
                        ReadResponse response = BluetoothPeripheralManager.this.callback.onDescriptorRead(bluetoothCentral, descriptor);
                        Objects.requireNonNull(response, "no valid ReadResponse returned");
                        status = response.status;
                        BluetoothPeripheralManager.access$902(BluetoothPeripheralManager.this, response.value);
                    }
                    byte[] value = BluetoothPeripheralManager.this.chopValue(BluetoothPeripheralManager.this.currentReadValue, offset);
                    BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(device, requestId, status.value, offset, value);
                }
            });
        }

        public void onDescriptorWriteRequest(final @NotNull BluetoothDevice device, final int requestId, final @NotNull BluetoothGattDescriptor descriptor, final boolean preparedWrite, final boolean responseNeeded, final int offset, @Nullable byte[] value) {
            final byte[] safeValue = BluetoothPeripheralManager.this.nonnullOf(value);
            final BluetoothGattCharacteristic characteristic = Objects.requireNonNull(descriptor.getCharacteristic(), "Descriptor does not have characteristic");
            Logger.i(TAG, "write descriptor %s request <%s> offset %d for <%s>", responseNeeded ? "WITH_RESPONSE" : "WITHOUT_RESPONSE", BluetoothBytesParser.asHexString(value), offset, descriptor.getUuid());
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    GattStatus status = GattStatus.SUCCESS;
                    if (descriptor.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                        status = this.checkCccDescriptorValue(safeValue, characteristic);
                    } else if (!preparedWrite) {
                        status = BluetoothPeripheralManager.this.callback.onDescriptorWrite(bluetoothCentral, descriptor, safeValue);
                    } else if (offset == 0) {
                        BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.put(descriptor, safeValue);
                    } else {
                        byte[] temporaryBytes = (byte[])BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.get(descriptor);
                        if (temporaryBytes != null && offset == temporaryBytes.length) {
                            BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.put(descriptor, BluetoothBytesParser.mergeArrays(temporaryBytes, safeValue));
                        } else {
                            status = GattStatus.INVALID_OFFSET;
                        }
                    }
                    if (status == GattStatus.SUCCESS && !preparedWrite && Build.VERSION.SDK_INT < 33) {
                        descriptor.setValue(safeValue);
                    }
                    if (responseNeeded) {
                        BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(device, requestId, status.value, offset, safeValue);
                    }
                    if (status == GattStatus.SUCCESS && descriptor.getUuid().equals(CCC_DESCRIPTOR_UUID)) {
                        if (Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE) || Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                            if (Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                                BluetoothPeripheralManager.this.addCentralWantingIndications(characteristic, bluetoothCentral);
                            } else {
                                BluetoothPeripheralManager.this.addCentralWantingNotifications(characteristic, bluetoothCentral);
                            }
                            Logger.i(TAG, "notifying enabled for <%s>", characteristic.getUuid());
                            BluetoothPeripheralManager.this.callback.onNotifyingEnabled(bluetoothCentral, characteristic);
                        } else {
                            Logger.i(TAG, "notifying disabled for <%s>", characteristic.getUuid());
                            BluetoothPeripheralManager.this.removeCentralWantingIndications(characteristic, bluetoothCentral);
                            BluetoothPeripheralManager.this.removeCentralWantingNotifications(characteristic, bluetoothCentral);
                            BluetoothPeripheralManager.this.callback.onNotifyingDisabled(bluetoothCentral, characteristic);
                        }
                    } else if (status == GattStatus.SUCCESS && !preparedWrite) {
                        BluetoothPeripheralManager.this.callback.onDescriptorWriteCompleted(bluetoothCentral, descriptor, safeValue);
                    }
                }
            });
        }

        private GattStatus checkCccDescriptorValue(@NotNull byte[] safeValue, @NotNull BluetoothGattCharacteristic characteristic) {
            GattStatus status = GattStatus.SUCCESS;
            if (safeValue.length != 2) {
                status = GattStatus.INVALID_ATTRIBUTE_VALUE_LENGTH;
            } else if (!(Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE) || Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) || Arrays.equals(safeValue, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE))) {
                status = GattStatus.VALUE_NOT_ALLOWED;
            } else if (!BluetoothPeripheralManager.this.supportsIndicate(characteristic) && Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                status = GattStatus.REQUEST_NOT_SUPPORTED;
            } else if (!BluetoothPeripheralManager.this.supportsNotify(characteristic) && Arrays.equals(safeValue, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE)) {
                status = GattStatus.REQUEST_NOT_SUPPORTED;
            }
            return status;
        }

        public void onExecuteWrite(final @NotNull BluetoothDevice device, final int requestId, boolean execute) {
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            if (execute) {
                BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothGattDescriptor descriptor;
                        GattStatus status = GattStatus.SUCCESS;
                        if (!BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.isEmpty()) {
                            BluetoothGattCharacteristic characteristic = (BluetoothGattCharacteristic)BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.keySet().iterator().next();
                            if (characteristic != null && (status = BluetoothPeripheralManager.this.callback.onCharacteristicWrite(bluetoothCentral, characteristic, (byte[])BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.get(characteristic))) == GattStatus.SUCCESS) {
                                byte[] value = (byte[])BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.get(characteristic);
                                if (Build.VERSION.SDK_INT < 33) {
                                    characteristic.setValue(value);
                                }
                                BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.clear();
                                BluetoothPeripheralManager.this.callback.onCharacteristicWriteCompleted(bluetoothCentral, characteristic, value);
                            }
                        } else if (!BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.isEmpty() && (descriptor = (BluetoothGattDescriptor)BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.keySet().iterator().next()) != null && (status = BluetoothPeripheralManager.this.callback.onDescriptorWrite(bluetoothCentral, descriptor, (byte[])BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.get(descriptor))) == GattStatus.SUCCESS) {
                            byte[] value = (byte[])BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.get(descriptor);
                            if (Build.VERSION.SDK_INT < 33) {
                                descriptor.setValue(value);
                            }
                            BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.clear();
                        }
                        BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(device, requestId, status.value, 0, null);
                    }
                });
            } else {
                BluetoothPeripheralManager.this.writeLongCharacteristicTemporaryBytes.clear();
                BluetoothPeripheralManager.this.writeLongDescriptorTemporaryBytes.clear();
                BluetoothPeripheralManager.this.bluetoothGattServer.sendResponse(device, requestId, GattStatus.SUCCESS.value, 0, null);
            }
        }

        public void onNotificationSent(@NotNull BluetoothDevice device, final int status) {
            final BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            final BluetoothGattCharacteristic characteristic = Objects.requireNonNull(BluetoothPeripheralManager.this.currentNotifyCharacteristic);
            final byte[] value = Objects.requireNonNull(BluetoothPeripheralManager.this.currentNotifyValue);
            BluetoothPeripheralManager.access$1802(BluetoothPeripheralManager.this, new byte[0]);
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheralManager.this.callback.onNotificationSent(bluetoothCentral, value, characteristic, GattStatus.fromValue(status));
                }
            });
            BluetoothPeripheralManager.this.completedCommand();
        }

        public void onMtuChanged(@NotNull BluetoothDevice device, int mtu) {
            Logger.i(TAG, "new MTU: %d", mtu);
            BluetoothCentral bluetoothCentral = BluetoothPeripheralManager.this.getCentral(device);
            bluetoothCentral.setCurrentMtu(mtu);
        }

        public void onPhyUpdate(@NotNull BluetoothDevice device, int txPhy, int rxPhy, int status) {
            super.onPhyUpdate(device, txPhy, rxPhy, status);
        }

        public void onPhyRead(@NotNull BluetoothDevice device, int txPhy, int rxPhy, int status) {
            super.onPhyRead(device, txPhy, rxPhy, status);
        }
    };
    protected final AdvertiseCallback advertiseCallback = new AdvertiseCallback(){

        public void onStartSuccess(final @NotNull AdvertiseSettings settingsInEffect) {
            Logger.i(TAG, "advertising started");
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheralManager.this.callback.onAdvertisingStarted(settingsInEffect);
                }
            });
        }

        public void onStartFailure(int errorCode) {
            final AdvertiseError advertiseError = AdvertiseError.fromValue(errorCode);
            Logger.e(TAG, "advertising failed with error '%s'", new Object[]{advertiseError});
            BluetoothPeripheralManager.this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheralManager.this.callback.onAdvertiseFailure(advertiseError);
                }
            });
        }
    };
    private final BroadcastReceiver adapterStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                BluetoothPeripheralManager.this.handleAdapterState(state);
            }
        }
    };

    protected void onAdvertisingStopped() {
        Logger.i(TAG, "advertising stopped");
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheralManager.this.callback.onAdvertisingStopped();
            }
        });
    }

    public BluetoothPeripheralManager(@NotNull Context context, @NotNull BluetoothManager bluetoothManager, @NotNull BluetoothPeripheralManagerCallback callback) {
        this.context = Objects.requireNonNull(context, CONTEXT_IS_NULL);
        this.callback = Objects.requireNonNull(callback, "Callback is null");
        this.bluetoothManager = Objects.requireNonNull(bluetoothManager, BLUETOOTH_MANAGER_IS_NULL);
        this.bluetoothAdapter = bluetoothManager.getAdapter();
        this.bluetoothLeAdvertiser = this.bluetoothAdapter.getBluetoothLeAdvertiser();
        this.bluetoothGattServer = bluetoothManager.openGattServer(context, this.bluetoothGattServerCallback);
        IntentFilter filter = new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED");
        context.registerReceiver(this.adapterStateReceiver, filter);
    }

    public void setCentralManager(@NotNull BluetoothCentralManager central) {
        this.centralManager = Objects.requireNonNull(central);
    }

    public void close() {
        this.stopAdvertising();
        this.context.unregisterReceiver(this.adapterStateReceiver);
        this.bluetoothGattServer.close();
    }

    public void startAdvertising(@NotNull AdvertiseSettings settings, @NotNull AdvertiseData advertiseData, @NotNull AdvertiseData scanResponse) {
        if (!this.bluetoothAdapter.isMultipleAdvertisementSupported()) {
            Logger.e(TAG, "device does not support advertising");
        } else {
            this.bluetoothLeAdvertiser.startAdvertising(settings, advertiseData, scanResponse, this.advertiseCallback);
        }
    }

    public void stopAdvertising() {
        this.bluetoothLeAdvertiser.stopAdvertising(this.advertiseCallback);
        this.onAdvertisingStopped();
    }

    public boolean add(final @NotNull BluetoothGattService service) {
        Objects.requireNonNull(service, SERVICE_IS_NULL);
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (!BluetoothPeripheralManager.this.bluetoothGattServer.addService(service)) {
                    Logger.e(TAG, "adding service %s failed", service.getUuid());
                    BluetoothPeripheralManager.this.completedCommand();
                }
            }
        });
    }

    public boolean remove(@NotNull BluetoothGattService service) {
        Objects.requireNonNull(service, SERVICE_IS_NULL);
        return this.bluetoothGattServer.removeService(service);
    }

    public void removeAllServices() {
        this.bluetoothGattServer.clearServices();
    }

    @NotNull
    public List<BluetoothGattService> getServices() {
        return this.bluetoothGattServer.getServices();
    }

    public boolean notifyCharacteristicChanged(@NotNull byte[] value, @NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(value, CHARACTERISTIC_VALUE_IS_NULL);
        Objects.requireNonNull(characteristic, CHARACTERISTIC_IS_NULL);
        if (this.doesNotSupportNotifying(characteristic)) {
            return false;
        }
        boolean result = true;
        for (BluetoothCentral device : this.getConnectedCentrals()) {
            if (this.notifyCharacteristicChanged(value, device, characteristic)) continue;
            result = false;
        }
        return result;
    }

    public boolean notifyCharacteristicChanged(@NotNull byte[] value, @NotNull BluetoothCentral bluetoothCentral, @NotNull BluetoothGattCharacteristic characteristic) {
        boolean confirm;
        Objects.requireNonNull(bluetoothCentral, CENTRAL_IS_NULL);
        Objects.requireNonNull(value, CHARACTERISTIC_VALUE_IS_NULL);
        Objects.requireNonNull(characteristic, CHARACTERISTIC_IS_NULL);
        BluetoothDevice bluetoothDevice = bluetoothCentral.device;
        boolean bl = confirm = this.supportsIndicate(characteristic) && this.getCentralsWantingIndications(characteristic).contains(bluetoothCentral);
        if (!confirm && !this.getCentralsWantingNotifications(characteristic).contains(bluetoothCentral)) {
            return false;
        }
        return this.notifyCharacteristicChanged(this.copyOf(value), bluetoothDevice, characteristic, confirm);
    }

    private boolean notifyCharacteristicChanged(final @NotNull byte[] value, final @NotNull BluetoothDevice bluetoothDevice, final @NotNull BluetoothGattCharacteristic characteristic, final boolean confirm) {
        Objects.requireNonNull(value, CHARACTERISTIC_VALUE_IS_NULL);
        Objects.requireNonNull(bluetoothDevice, DEVICE_IS_NULL);
        Objects.requireNonNull(characteristic, CHARACTERISTIC_IS_NULL);
        if (this.doesNotSupportNotifying(characteristic)) {
            return false;
        }
        return this.enqueue(new Runnable(){

            @Override
            public void run() {
                if (!BluetoothPeripheralManager.this.internalNotifyCharacteristicChanged(bluetoothDevice, characteristic, value, confirm)) {
                    Logger.e(TAG, "notifying characteristic changed failed for <%s>", characteristic.getUuid());
                    BluetoothPeripheralManager.this.completedCommand();
                }
            }
        });
    }

    private boolean internalNotifyCharacteristicChanged(@NotNull BluetoothDevice device, @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, boolean confirm) {
        this.currentNotifyValue = value;
        this.currentNotifyCharacteristic = characteristic;
        if (Build.VERSION.SDK_INT >= 33) {
            int result = this.bluetoothGattServer.notifyCharacteristicChanged(device, characteristic, confirm, value);
            return result == 0;
        }
        characteristic.setValue(value);
        return this.bluetoothGattServer.notifyCharacteristicChanged(device, characteristic, confirm);
    }

    public void cancelConnection(@NotNull BluetoothCentral bluetoothCentral) {
        Objects.requireNonNull(bluetoothCentral, CENTRAL_IS_NULL);
        this.cancelConnection(this.bluetoothAdapter.getRemoteDevice(bluetoothCentral.getAddress()));
    }

    private void cancelConnection(@NotNull BluetoothDevice bluetoothDevice) {
        Objects.requireNonNull(bluetoothDevice, DEVICE_IS_NULL);
        Logger.i(TAG, "cancelConnection with '%s' (%s)", bluetoothDevice.getName(), bluetoothDevice.getAddress());
        this.bluetoothGattServer.cancelConnection(bluetoothDevice);
    }

    @NotNull
    private List<BluetoothDevice> getConnectedDevices() {
        return this.bluetoothManager.getConnectedDevices(7);
    }

    @NotNull
    public Set<BluetoothCentral> getConnectedCentrals() {
        HashSet<BluetoothCentral> bluetoothCentrals = new HashSet<BluetoothCentral>(this.connectedCentralsMap.values());
        return Collections.unmodifiableSet(bluetoothCentrals);
    }

    private boolean enqueue(Runnable command) {
        boolean result = this.commandQueue.add(command);
        if (result) {
            this.nextCommand();
        } else {
            Logger.e(TAG, "could not enqueue command");
        }
        return result;
    }

    private void completedCommand() {
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextCommand() {
        BluetoothPeripheralManager bluetoothPeripheralManager = this;
        synchronized (bluetoothPeripheralManager) {
            if (this.commandQueueBusy) {
                return;
            }
            final Runnable bluetoothCommand = this.commandQueue.peek();
            if (bluetoothCommand == null) {
                return;
            }
            this.commandQueueBusy = true;
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        bluetoothCommand.run();
                    }
                    catch (Exception ex) {
                        Logger.e(TAG, "command exception");
                        Logger.e(TAG, ex.toString());
                        BluetoothPeripheralManager.this.completedCommand();
                    }
                }
            });
        }
    }

    @Nullable
    public BluetoothCentral getCentral(@NotNull String address) {
        Objects.requireNonNull(address, ADDRESS_IS_NULL);
        return this.connectedCentralsMap.get(address);
    }

    @NotNull
    private BluetoothCentral getCentral(@NotNull BluetoothDevice device) {
        Objects.requireNonNull(device, DEVICE_IS_NULL);
        BluetoothCentral result = this.connectedCentralsMap.get(device.getAddress());
        if (result == null) {
            result = new BluetoothCentral(device);
        }
        return result;
    }

    private void removeCentral(@NotNull BluetoothDevice device) {
        Objects.requireNonNull(device, DEVICE_IS_NULL);
        this.connectedCentralsMap.remove(device.getAddress());
    }

    private void handleAdapterState(int state) {
        switch (state) {
            case 10: {
                Logger.d(TAG, "bluetooth turned off");
                this.cancelAllConnectionsWhenBluetoothOff();
                break;
            }
            case 13: {
                Logger.d(TAG, "bluetooth turning off");
                break;
            }
            case 12: {
                Logger.d(TAG, "bluetooth turned on");
                break;
            }
            case 11: {
                Logger.d(TAG, "bluetooth turning on");
            }
        }
    }

    private void cancelAllConnectionsWhenBluetoothOff() {
        Set<BluetoothCentral> bluetoothCentrals = this.getConnectedCentrals();
        for (BluetoothCentral bluetoothCentral : bluetoothCentrals) {
            this.bluetoothGattServerCallback.onConnectionStateChange(this.bluetoothAdapter.getRemoteDevice(bluetoothCentral.getAddress()), 0, 0);
        }
        this.onAdvertisingStopped();
    }

    private byte[] chopValue(@Nullable byte[] value, int offset) {
        byte[] choppedValue = new byte[]{};
        if (value == null) {
            return choppedValue;
        }
        if (offset <= value.length) {
            choppedValue = Arrays.copyOfRange(value, offset, value.length);
        }
        return choppedValue;
    }

    @NotNull
    byte[] copyOf(@Nullable byte[] source) {
        return source == null ? new byte[]{} : Arrays.copyOf(source, source.length);
    }

    @NotNull
    private byte[] nonnullOf(@Nullable byte[] source) {
        return source == null ? new byte[]{} : source;
    }

    private boolean supportsNotify(@NotNull BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 0x10) > 0;
    }

    private boolean supportsIndicate(@NotNull BluetoothGattCharacteristic characteristic) {
        return (characteristic.getProperties() & 0x20) > 0;
    }

    private boolean doesNotSupportNotifying(@NotNull BluetoothGattCharacteristic characteristic) {
        return !this.supportsIndicate(characteristic) && !this.supportsNotify(characteristic);
    }

    protected void addCentralWantingIndications(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCentral central) {
        Set<String> centrals = this.centralsWantingIndications.get(characteristic);
        if (centrals == null) {
            centrals = new HashSet<String>();
            this.centralsWantingIndications.put(characteristic, centrals);
        }
        centrals.add(central.getAddress());
    }

    protected void addCentralWantingNotifications(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCentral central) {
        Set<String> centrals = this.centralsWantingNotifications.get(characteristic);
        if (centrals == null) {
            centrals = new HashSet<String>();
            this.centralsWantingNotifications.put(characteristic, centrals);
        }
        centrals.add(central.getAddress());
    }

    protected void removeCentralWantingIndications(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCentral central) {
        Set<String> centrals = this.centralsWantingIndications.get(characteristic);
        if (centrals != null) {
            centrals.remove(central.getAddress());
        }
    }

    protected void removeCentralWantingNotifications(@NotNull BluetoothGattCharacteristic characteristic, @NotNull BluetoothCentral central) {
        Set<String> centrals = this.centralsWantingNotifications.get(characteristic);
        if (centrals != null) {
            centrals.remove(central.getAddress());
        }
    }

    protected void removeCentralFromWantingAnything(@NotNull BluetoothCentral central) {
        String centralAddress = central.getAddress();
        for (Map.Entry<BluetoothGattCharacteristic, Set<String>> entry : this.centralsWantingIndications.entrySet()) {
            entry.getValue().remove(centralAddress);
        }
        for (Map.Entry<BluetoothGattCharacteristic, Set<String>> entry : this.centralsWantingNotifications.entrySet()) {
            entry.getValue().remove(centralAddress);
        }
    }

    @NotNull
    public Set<BluetoothCentral> getCentralsWantingIndications(@NotNull BluetoothGattCharacteristic characteristic) {
        Set<String> centrals = this.centralsWantingIndications.get(characteristic);
        return centrals == null ? Collections.emptySet() : this.getCentralsByAddress(centrals);
    }

    @NotNull
    public Set<BluetoothCentral> getCentralsWantingNotifications(@NotNull BluetoothGattCharacteristic characteristic) {
        Set<String> centrals = this.centralsWantingNotifications.get(characteristic);
        return centrals == null ? Collections.emptySet() : this.getCentralsByAddress(centrals);
    }

    @NotNull
    private Set<BluetoothCentral> getCentralsByAddress(@NotNull Set<String> centralAddresses) {
        HashSet<BluetoothCentral> result = new HashSet<BluetoothCentral>();
        for (String centralAddress : centralAddresses) {
            result.add(this.getCentral(centralAddress));
        }
        return result;
    }

    static /* synthetic */ byte[] access$902(BluetoothPeripheralManager x0, byte[] x1) {
        x0.currentReadValue = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1802(BluetoothPeripheralManager x0, byte[] x1) {
        x0.currentNotifyValue = x1;
        return x1;
    }
}

