/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluetoothBytesParser {
    private static final String INVALID_OFFSET = "invalid offset";
    private static final String UNSUPPORTED_FORMAT_TYPE = "unsupported format type";
    private static final String OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO = "offset must be greater or equal to zero";
    private int internalOffset;
    @NotNull
    private byte[] mValue;
    @NotNull
    private final ByteOrder internalByteOrder;
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT24 = 19;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_UINT48 = 22;
    public static final int FORMAT_UINT64 = 24;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT24 = 35;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;

    public BluetoothBytesParser() {
        this(new byte[0], ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(@NotNull ByteOrder byteOrder) {
        this(new byte[0], byteOrder);
    }

    public BluetoothBytesParser(@NotNull byte[] value) {
        this(value, 0, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(@NotNull byte[] value, @NotNull ByteOrder byteOrder) {
        this(value, 0, byteOrder);
    }

    public BluetoothBytesParser(@NotNull byte[] value, int offset) {
        this(value, offset, ByteOrder.LITTLE_ENDIAN);
    }

    public BluetoothBytesParser(@NotNull byte[] value, int offset, @NotNull ByteOrder byteOrder) {
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        Objects.requireNonNull(byteOrder);
        if (byteOrder != ByteOrder.LITTLE_ENDIAN && byteOrder != ByteOrder.BIG_ENDIAN) {
            throw new IllegalArgumentException("unsupported ByteOrder value");
        }
        this.mValue = Objects.requireNonNull(value);
        this.internalOffset = offset;
        this.internalByteOrder = byteOrder;
    }

    @NotNull
    public Long getLongValue(int formatType) {
        return this.getLongValue(formatType, this.internalByteOrder);
    }

    @NotNull
    public Long getLongValue(int formatType, @NotNull ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        long result = this.getLongValue(formatType, this.internalOffset, byteOrder);
        this.internalOffset += this.getTypeLen(formatType);
        return result;
    }

    @NotNull
    public Long getLongValue(int formatType, int offset, @NotNull ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        int length = this.getTypeLen(formatType);
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        if (offset + length > this.mValue.length) {
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            long value = 0xFF & this.mValue[offset + length - 1];
            for (int i = length - 2; i >= 0; --i) {
                value <<= 8;
                value += (long)(0xFF & this.mValue[i + offset]);
            }
            return value;
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            long value = 0xFF & this.mValue[offset];
            for (int i = 1; i < length; ++i) {
                value <<= 8;
                value += (long)(0xFF & this.mValue[i + offset]);
            }
            return value;
        }
        throw new IllegalArgumentException("invalid byte order");
    }

    public Integer getIntValue(int formatType) {
        Integer result = this.getIntValue(formatType, this.internalOffset, this.internalByteOrder);
        this.internalOffset += this.getTypeLen(formatType);
        return result;
    }

    public Integer getIntValue(int formatType, @NotNull ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        Integer result = this.getIntValue(formatType, this.internalOffset, byteOrder);
        this.internalOffset += this.getTypeLen(formatType);
        return result;
    }

    @NotNull
    public Integer getIntValue(int formatType, int offset, ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        if (offset + this.getTypeLen(formatType) > this.mValue.length) {
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        switch (formatType) {
            case 17: {
                return this.unsignedByteToInt(this.mValue[offset]);
            }
            case 18: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]);
                }
                return this.unsignedBytesToInt(this.mValue[offset + 1], this.mValue[offset]);
            }
            case 19: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], (byte)0);
                }
                return this.unsignedBytesToInt(this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset], (byte)0);
            }
            case 20: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]);
                }
                return this.unsignedBytesToInt(this.mValue[offset + 3], this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset]);
            }
            case 33: {
                return this.unsignedToSigned(this.unsignedByteToInt(this.mValue[offset]), 8);
            }
            case 34: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1]), 16);
                }
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset + 1], this.mValue[offset]), 16);
            }
            case 35: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], (byte)0), 24);
                }
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset], (byte)0), 24);
            }
            case 36: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]), 32);
                }
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[offset + 3], this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset]), 32);
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
    }

    @NotNull
    public Float getFloatValue(int formatType) {
        Float result = this.getFloatValue(formatType, this.internalOffset, this.internalByteOrder);
        this.internalOffset += this.getTypeLen(formatType);
        return result;
    }

    @NotNull
    public Float getFloatValue(int formatType, @NotNull ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        Float result = this.getFloatValue(formatType, this.internalOffset, byteOrder);
        this.internalOffset += this.getTypeLen(formatType);
        return result;
    }

    @NotNull
    public Float getFloatValue(int formatType, int offset, @NotNull ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder);
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        if (offset + this.getTypeLen(formatType) > this.mValue.length) {
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        switch (formatType) {
            case 50: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Float.valueOf(this.bytesToFloat(this.mValue[offset], this.mValue[offset + 1]));
                }
                return Float.valueOf(this.bytesToFloat(this.mValue[offset + 1], this.mValue[offset]));
            }
            case 52: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    return Float.valueOf(this.bytesToFloat(this.mValue[offset], this.mValue[offset + 1], this.mValue[offset + 2], this.mValue[offset + 3]));
                }
                return Float.valueOf(this.bytesToFloat(this.mValue[offset + 3], this.mValue[offset + 2], this.mValue[offset + 1], this.mValue[offset]));
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
    }

    @NotNull
    public String getStringValue() {
        return this.getStringValue(this.internalOffset);
    }

    @NotNull
    public String getStringValue(int offset) {
        int j;
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        if (this.mValue == null || offset > this.mValue.length) {
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        byte[] strBytes = new byte[this.mValue.length - offset];
        for (int i = 0; i != this.mValue.length - offset; ++i) {
            strBytes[i] = this.mValue[offset + i];
        }
        for (j = strBytes.length; j > 0 && (strBytes[j - 1] == 0 || strBytes[j - 1] == 32); --j) {
        }
        return new String(strBytes, 0, j, StandardCharsets.ISO_8859_1);
    }

    @NotNull
    public Date getDateTime() {
        Date result = this.getDateTime(this.internalOffset);
        this.internalOffset += 7;
        return result;
    }

    @NotNull
    public Date getDateTime(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        if (offset + 7 > this.mValue.length) {
            throw new IllegalArgumentException(INVALID_OFFSET);
        }
        int newOffset = offset;
        int year = this.getIntValue(18, newOffset, ByteOrder.LITTLE_ENDIAN);
        int month = this.getIntValue(17, newOffset += this.getTypeLen(18), ByteOrder.LITTLE_ENDIAN);
        int day = this.getIntValue(17, newOffset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        int hour = this.getIntValue(17, newOffset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        int min = this.getIntValue(17, newOffset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        int sec = this.getIntValue(17, newOffset += this.getTypeLen(17), ByteOrder.LITTLE_ENDIAN);
        GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hour, min, sec);
        return calendar.getTime();
    }

    @NotNull
    public byte[] getValue() {
        return this.mValue;
    }

    @NotNull
    public byte[] getByteArray(int length) {
        byte[] array = Arrays.copyOfRange(this.mValue, this.internalOffset, this.internalOffset + length);
        this.internalOffset += length;
        return array;
    }

    public void setIntValue(int value, int formatType, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        this.prepareArray(offset + this.getTypeLen(formatType));
        int newValue = value;
        int newOffset = offset;
        switch (formatType) {
            case 33: {
                newValue = this.intToSignedBits(newValue, 8);
            }
            case 17: {
                this.mValue[newOffset] = (byte)(newValue & 0xFF);
                break;
            }
            case 34: {
                newValue = this.intToSignedBits(newValue, 16);
            }
            case 18: {
                if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[newOffset++] = (byte)(newValue & 0xFF);
                    this.mValue[newOffset] = (byte)(newValue >> 8 & 0xFF);
                    break;
                }
                this.mValue[newOffset++] = (byte)(newValue >> 8 & 0xFF);
                this.mValue[newOffset] = (byte)(newValue & 0xFF);
                break;
            }
            case 35: {
                newValue = this.intToSignedBits(newValue, 24);
            }
            case 19: {
                if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[newOffset++] = (byte)(newValue & 0xFF);
                    this.mValue[newOffset++] = (byte)(newValue >> 8 & 0xFF);
                    this.mValue[newOffset] = (byte)(newValue >> 16 & 0xFF);
                    break;
                }
                this.mValue[newOffset++] = (byte)(newValue >> 16 & 0xFF);
                this.mValue[newOffset++] = (byte)(newValue >> 8 & 0xFF);
                this.mValue[newOffset] = (byte)(newValue & 0xFF);
                break;
            }
            case 36: {
                newValue = this.intToSignedBits(newValue, 32);
            }
            case 20: {
                if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[newOffset++] = (byte)(newValue & 0xFF);
                    this.mValue[newOffset++] = (byte)(newValue >> 8 & 0xFF);
                    this.mValue[newOffset++] = (byte)(newValue >> 16 & 0xFF);
                    this.mValue[newOffset] = (byte)(newValue >> 24 & 0xFF);
                    break;
                }
                this.mValue[newOffset++] = (byte)(newValue >> 24 & 0xFF);
                this.mValue[newOffset++] = (byte)(newValue >> 16 & 0xFF);
                this.mValue[newOffset++] = (byte)(newValue >> 8 & 0xFF);
                this.mValue[newOffset] = (byte)(newValue & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
            }
        }
    }

    public void setIntValue(int value, int formatType) {
        this.setIntValue(value, formatType, this.internalOffset);
        this.internalOffset += this.getTypeLen(formatType);
    }

    public void setLong(long value, int formatType) {
        this.setLong(value, formatType, this.internalOffset);
        this.internalOffset += this.getTypeLen(formatType);
    }

    public void setLong(long value, int formatType, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        if (!(formatType == 22 | formatType == 24)) {
            throw new IllegalArgumentException("format type not allowed");
        }
        int length = this.getTypeLen(formatType);
        this.prepareArray(offset + length);
        long newValue = value;
        if (this.internalByteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i = length - 1; i >= 0; --i) {
                this.mValue[i + offset] = (byte)(newValue & 0xFFL);
                newValue >>= 8;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.mValue[i + offset] = (byte)(newValue & 0xFFL);
                newValue >>= 8;
            }
        }
    }

    public void setFloatValue(int mantissa, int exponent, int formatType, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        this.prepareArray(offset + this.getTypeLen(formatType));
        int newMantissa = mantissa;
        int newExponent = exponent;
        int newOffset = offset;
        switch (formatType) {
            case 50: {
                newMantissa = this.intToSignedBits(newMantissa, 12);
                newExponent = this.intToSignedBits(newExponent, 4);
                if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[newOffset++] = (byte)(newMantissa & 0xFF);
                    this.mValue[newOffset] = (byte)(newMantissa >> 8 & 0xF);
                    int n = newOffset;
                    this.mValue[n] = (byte)(this.mValue[n] + (byte)((newExponent & 0xF) << 4));
                    break;
                }
                this.mValue[newOffset] = (byte)(newMantissa >> 8 & 0xF);
                int n = newOffset++;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)((newExponent & 0xF) << 4));
                this.mValue[newOffset] = (byte)(mantissa & 0xFF);
                break;
            }
            case 52: {
                newMantissa = this.intToSignedBits(newMantissa, 24);
                newExponent = this.intToSignedBits(newExponent, 8);
                if (this.internalByteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.mValue[newOffset++] = (byte)(newMantissa & 0xFF);
                    this.mValue[newOffset++] = (byte)(newMantissa >> 8 & 0xFF);
                    this.mValue[newOffset++] = (byte)(newMantissa >> 16 & 0xFF);
                    this.mValue[newOffset] = (byte)(newExponent & 0xFF);
                    break;
                }
                this.mValue[newOffset++] = (byte)(newExponent & 0xFF);
                this.mValue[newOffset++] = (byte)(newMantissa >> 16 & 0xFF);
                this.mValue[newOffset++] = (byte)(newMantissa >> 8 & 0xFF);
                this.mValue[newOffset] = (byte)(newMantissa & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_FORMAT_TYPE);
            }
        }
    }

    public void setFloatValue(float value, int precision) {
        float mantissa = (float)((double)value * Math.pow(10.0, precision));
        this.setFloatValue((int)mantissa, -precision, 52, this.internalOffset);
        this.internalOffset += this.getTypeLen(52);
    }

    public void setByteArray(byte[] value) {
        this.setByteArray(value, this.internalOffset);
        this.internalOffset += value.length;
    }

    public void setByteArray(byte[] value, int offset) {
        this.prepareArray(offset + value.length);
        System.arraycopy(value, 0, this.getValue(), offset, value.length);
    }

    public void setString(@NotNull String value) {
        Objects.requireNonNull(value);
        this.setString(value, this.internalOffset);
        this.internalOffset += value.getBytes().length;
    }

    public void setString(@NotNull String value, int offset) {
        Objects.requireNonNull(value);
        this.setByteArray(value.getBytes(), offset);
    }

    public void setValue(@NotNull byte[] value) {
        this.mValue = Objects.requireNonNull(value);
    }

    public void setCurrentTime(@NotNull Calendar calendar) {
        Objects.requireNonNull(calendar);
        this.mValue = new byte[10];
        this.mValue[0] = (byte)calendar.get(1);
        this.mValue[1] = (byte)(calendar.get(1) >> 8);
        this.mValue[2] = (byte)(calendar.get(2) + 1);
        this.mValue[3] = (byte)calendar.get(5);
        this.mValue[4] = (byte)calendar.get(11);
        this.mValue[5] = (byte)calendar.get(12);
        this.mValue[6] = (byte)calendar.get(13);
        this.mValue[7] = (byte)((calendar.get(7) + 5) % 7 + 1);
        this.mValue[8] = (byte)(calendar.get(14) * 256 / 1000);
        this.mValue[9] = 1;
    }

    public void setDateTime(@NotNull Calendar calendar) {
        Objects.requireNonNull(calendar);
        this.mValue = new byte[7];
        this.mValue[0] = (byte)calendar.get(1);
        this.mValue[1] = (byte)(calendar.get(1) >> 8);
        this.mValue[2] = (byte)(calendar.get(2) + 1);
        this.mValue[3] = (byte)calendar.get(5);
        this.mValue[4] = (byte)calendar.get(11);
        this.mValue[5] = (byte)calendar.get(12);
        this.mValue[6] = (byte)calendar.get(13);
    }

    private int getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    private int unsignedBytesToInt(byte b0, byte b1) {
        return this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8);
    }

    private int unsignedBytesToInt(byte b0, byte b1, byte b2, byte b3) {
        return this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8) + (this.unsignedByteToInt(b2) << 16) + (this.unsignedByteToInt(b3) << 24);
    }

    private float bytesToFloat(byte b0, byte b1) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(b0) + ((this.unsignedByteToInt(b1) & 0xF) << 8), 12);
        int exponent = this.unsignedToSigned(this.unsignedByteToInt(b1) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private float bytesToFloat(byte b0, byte b1, byte b2, byte b3) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(b0) + (this.unsignedByteToInt(b1) << 8) + (this.unsignedByteToInt(b2) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, b3));
    }

    private int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            return -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    private int intToSignedBits(int i, int size) {
        if (i < 0) {
            return (1 << size - 1) + (i & (1 << size - 1) - 1);
        }
        return i;
    }

    @NotNull
    public static String bytes2String(@Nullable byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    @NotNull
    public static byte[] string2bytes(@Nullable String hexString) {
        if (hexString == null) {
            return new byte[0];
        }
        byte[] result = new byte[hexString.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            int index = i * 2;
            result[i] = (byte)Integer.parseInt(hexString.substring(index, index + 2), 16);
        }
        return result;
    }

    @NotNull
    public static byte[] mergeArrays(byte[] ... arrays) {
        int size = 0;
        for (byte[] array : arrays) {
            size += array.length;
        }
        byte[] merged = new byte[size];
        int index = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, merged, index, array.length);
            index += array.length;
        }
        return merged;
    }

    public int getOffset() {
        return this.internalOffset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(OFFSET_MUST_BE_GREATER_OR_EQUAL_TO_ZERO);
        }
        this.internalOffset = offset;
    }

    @NotNull
    public ByteOrder getByteOrder() {
        return this.internalByteOrder;
    }

    private void prepareArray(int neededLength) {
        if (this.mValue == null) {
            this.mValue = new byte[neededLength];
        }
        if (neededLength > this.mValue.length) {
            byte[] largerByteArray = new byte[neededLength];
            System.arraycopy(this.mValue, 0, largerByteArray, 0, this.mValue.length);
            this.mValue = largerByteArray;
        }
    }

    public String toString() {
        return BluetoothBytesParser.bytes2String(this.mValue);
    }
}

