/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.welie.blessed.BluetoothPeripheralCallback;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

public class BluetoothPeripheral {
    private static final String CCC_DESCRIPTOR_UUID = "00002902-0000-1000-8000-00805f9b34fb";
    public static final int GATT_SUCCESS = 0;
    public static final int GATT_CONN_L2C_FAILURE = 1;
    public static final int GATT_CONN_TIMEOUT = 8;
    public static final int GATT_READ_NOT_PERMITTED = 2;
    public static final int GATT_WRITE_NOT_PERMITTED = 3;
    public static final int GATT_INSUFFICIENT_AUTHENTICATION = 5;
    public static final int GATT_REQUEST_NOT_SUPPORTED = 6;
    public static final int GATT_INSUFFICIENT_ENCRYPTION = 15;
    public static final int GATT_CONN_TERMINATE_PEER_USER = 19;
    public static final int GATT_CONN_TERMINATE_LOCAL_HOST = 22;
    public static final int GATT_CONN_LMP_TIMEOUT = 34;
    public static final int BLE_HCI_CONN_TERMINATED_DUE_TO_MIC_FAILURE = 61;
    public static final int GATT_CONN_FAIL_ESTABLISH = 62;
    public static final int GATT_NO_RESOURCES = 128;
    public static final int GATT_INTERNAL_ERROR = 129;
    public static final int GATT_BUSY = 132;
    public static final int GATT_ERROR = 133;
    public static final int GATT_AUTH_FAIL = 137;
    public static final int GATT_CONN_CANCEL = 256;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_CLASSIC = 1;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_DUAL = 3;
    public static final int BOND_NONE = 10;
    public static final int BOND_BONDING = 11;
    public static final int BOND_BONDED = 12;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    private static final int MAX_TRIES = 2;
    private static final int DIRECT_CONNECTION_DELAY_IN_MS = 100;
    private static final int CONNECTION_TIMEOUT_IN_MS = 35000;
    private static final int TIMEOUT_THRESHOLD_SAMSUNG = 4500;
    private static final int TIMEOUT_THRESHOLD_DEFAULT = 25000;
    private static final long DELAY_AFTER_BOND_LOST = 1000L;
    private static final int MAX_NOTIFYING_CHARACTERISTICS = 15;
    private final Context context;
    private final Handler callbackHandler;
    private final BluetoothDevice device;
    private final InternalCallback listener;
    private BluetoothPeripheralCallback peripheralCallback;
    private final Queue<Runnable> commandQueue = new ConcurrentLinkedQueue<Runnable>();
    private boolean commandQueueBusy;
    private boolean isRetrying;
    private boolean bondLost = false;
    private boolean manuallyBonding = false;
    private volatile BluetoothGatt bluetoothGatt;
    private int state;
    private int nrTries;
    private byte[] currentWriteBytes;
    private final Set<UUID> notifyingCharacteristics = new HashSet<UUID>();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private Runnable timeoutRunnable;
    private Runnable discoverServicesRunnable;
    private long connectTimestamp;
    private String cachedName;
    private final BluetoothGattCallback bluetoothGattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
            long timePassed = SystemClock.elapsedRealtime() - BluetoothPeripheral.this.connectTimestamp;
            BluetoothPeripheral.this.cancelConnectionTimer();
            int previousState = BluetoothPeripheral.this.state;
            BluetoothPeripheral.this.state = newState;
            if (status == 0) {
                switch (newState) {
                    case 2: {
                        BluetoothPeripheral.this.successfullyConnected(BluetoothPeripheral.this.device.getBondState(), timePassed);
                        break;
                    }
                    case 0: {
                        BluetoothPeripheral.this.successfullyDisconnected(previousState);
                        break;
                    }
                    case 3: {
                        Timber.i((String)"peripheral is disconnecting", (Object[])new Object[0]);
                        break;
                    }
                    case 1: {
                        Timber.i((String)"peripheral is connecting", (Object[])new Object[0]);
                    }
                    default: {
                        Timber.e((String)"unknown state received", (Object[])new Object[0]);
                        break;
                    }
                }
            } else {
                BluetoothPeripheral.this.connectionStateChangeUnsuccessful(status, previousState, newState, timePassed);
            }
        }

        public void onServicesDiscovered(BluetoothGatt gatt, int status) {
            if (status != 0) {
                Timber.e((String)"service discovery failed due to internal error '%s', disconnecting", (Object[])new Object[]{BluetoothPeripheral.statusToString(status)});
                BluetoothPeripheral.this.disconnect();
                return;
            }
            List services = gatt.getServices();
            Timber.i((String)"discovered %d services for '%s'", (Object[])new Object[]{services.size(), BluetoothPeripheral.this.getName()});
            if (BluetoothPeripheral.this.listener != null) {
                BluetoothPeripheral.this.listener.connected(BluetoothPeripheral.this);
            }
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onServicesDiscovered(BluetoothPeripheral.this);
                }
            });
        }

        public void onDescriptorWrite(BluetoothGatt gatt, final BluetoothGattDescriptor descriptor, final int status) {
            final BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
            if (status != 0) {
                Timber.e((String)"failed to write <%s> to descriptor of characteristic: <%s> for device: '%s', ", (Object[])new Object[]{BluetoothPeripheral.bytes2String(BluetoothPeripheral.this.currentWriteBytes), parentCharacteristic.getUuid(), BluetoothPeripheral.this.getAddress()});
            }
            if (descriptor.getUuid().equals(UUID.fromString(BluetoothPeripheral.CCC_DESCRIPTOR_UUID))) {
                byte[] value;
                if (status == 0 && (value = descriptor.getValue()) != null) {
                    if (Arrays.equals(value, BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE) || Arrays.equals(value, BluetoothGattDescriptor.ENABLE_INDICATION_VALUE)) {
                        BluetoothPeripheral.this.notifyingCharacteristics.add(parentCharacteristic.getUuid());
                        if (BluetoothPeripheral.this.notifyingCharacteristics.size() > 15) {
                            Timber.e((String)"too many (%d) notifying characteristics. The maximum Android can handle is %d", (Object[])new Object[]{BluetoothPeripheral.this.notifyingCharacteristics.size(), 15});
                        }
                    } else if (Arrays.equals(value, BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE)) {
                        BluetoothPeripheral.this.notifyingCharacteristics.remove(parentCharacteristic.getUuid());
                    } else {
                        Timber.e((String)"unexpected CCC descriptor value", (Object[])new Object[0]);
                    }
                }
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onNotificationStateUpdate(BluetoothPeripheral.this, parentCharacteristic, status);
                    }
                });
            } else {
                BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onDescriptorWrite(BluetoothPeripheral.this, BluetoothPeripheral.this.currentWriteBytes, descriptor, status);
                    }
                });
            }
            BluetoothPeripheral.this.completedCommand();
        }

        public void onDescriptorRead(BluetoothGatt gatt, final BluetoothGattDescriptor descriptor, final int status) {
            if (status != 0) {
                Timber.e((String)"reading descriptor <%s> failed for device '%s'", (Object[])new Object[]{descriptor.getUuid(), BluetoothPeripheral.this.getAddress()});
            }
            final byte[] value = BluetoothPeripheral.this.copyOf(descriptor.getValue());
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onDescriptorRead(BluetoothPeripheral.this, value, descriptor, status);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic) {
            final byte[] value = BluetoothPeripheral.this.copyOf(characteristic.getValue());
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, value, characteristic, 0);
                }
            });
        }

        public void onCharacteristicRead(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, final int status) {
            if (status != 0) {
                if (status == 137 || status == 5) {
                    Timber.w((String)"read needs bonding, bonding in progress", (Object[])new Object[0]);
                    return;
                }
                Timber.e((String)"read failed for characteristic: %s, status %d", (Object[])new Object[]{characteristic.getUuid(), status});
                BluetoothPeripheral.this.completedCommand();
                return;
            }
            final byte[] value = BluetoothPeripheral.this.copyOf(characteristic.getValue());
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onCharacteristicUpdate(BluetoothPeripheral.this, value, characteristic, status);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, final BluetoothGattCharacteristic characteristic, final int status) {
            if (status != 0) {
                if (status == 137 || status == 5) {
                    Timber.i((String)"write needs bonding, bonding in progress", (Object[])new Object[0]);
                    return;
                }
                Timber.e((String)"writing <%s> to characteristic <%s> failed, status %s", (Object[])new Object[]{BluetoothPeripheral.bytes2String(BluetoothPeripheral.this.currentWriteBytes), characteristic.getUuid(), BluetoothPeripheral.statusToString(status)});
            }
            final byte[] value = BluetoothPeripheral.this.copyOf(BluetoothPeripheral.this.currentWriteBytes);
            BluetoothPeripheral.access$1202(BluetoothPeripheral.this, null);
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onCharacteristicWrite(BluetoothPeripheral.this, value, characteristic, status);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onReadRemoteRssi(BluetoothGatt gatt, final int rssi, final int status) {
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onReadRemoteRssi(BluetoothPeripheral.this, rssi, status);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }

        public void onMtuChanged(BluetoothGatt gatt, final int mtu, final int status) {
            BluetoothPeripheral.this.callbackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.peripheralCallback.onMtuChanged(BluetoothPeripheral.this, mtu, status);
                }
            });
            BluetoothPeripheral.this.completedCommand();
        }
    };
    private final BroadcastReceiver bondStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            BluetoothDevice receivedDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (receivedDevice == null) {
                return;
            }
            if (!receivedDevice.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                return;
            }
            if (action.equals("android.bluetooth.device.action.BOND_STATE_CHANGED")) {
                int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", Integer.MIN_VALUE);
                int previousBondState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", Integer.MIN_VALUE);
                BluetoothPeripheral.this.handleBondStateChange(bondState, previousBondState);
            }
        }
    };
    private final BroadcastReceiver pairingRequestBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String pin;
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (device == null) {
                return;
            }
            if (!device.getAddress().equalsIgnoreCase(BluetoothPeripheral.this.getAddress())) {
                return;
            }
            int variant = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", Integer.MIN_VALUE);
            Timber.d((String)("pairing request received , pairing variant: " + BluetoothPeripheral.this.pairingVariantToString(variant) + " (" + variant + ")"), (Object[])new Object[0]);
            if (variant == 0 && (pin = BluetoothPeripheral.this.listener.getPincode(BluetoothPeripheral.this)) != null) {
                Timber.d((String)"Setting PIN code for this peripheral using '%s'", (Object[])new Object[]{pin});
                device.setPin(pin.getBytes());
                this.abortBroadcast();
            }
        }
    };
    private static final int PAIRING_VARIANT_PIN = 0;
    private static final int PAIRING_VARIANT_PASSKEY = 1;
    private static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    private static final int PAIRING_VARIANT_CONSENT = 3;
    private static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    private static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    private static final int PAIRING_VARIANT_OOB_CONSENT = 6;

    private void successfullyConnected(int bondstate, long timePassed) {
        Timber.i((String)"connected to '%s' (%s) in %.1fs", (Object[])new Object[]{this.getName(), this.bondStateToString(bondstate), Float.valueOf((float)timePassed / 1000.0f)});
        if (bondstate == 10 || bondstate == 12) {
            this.delayedDiscoverServices(this.getServiceDiscoveryDelay(bondstate));
        } else if (bondstate == 11) {
            Timber.i((String)"waiting for bonding to complete", (Object[])new Object[0]);
        }
    }

    private void delayedDiscoverServices(final long delay) {
        this.discoverServicesRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.d((String)"discovering services of '%s' with delay of %d ms", (Object[])new Object[]{BluetoothPeripheral.this.getName(), delay});
                if (!BluetoothPeripheral.this.bluetoothGatt.discoverServices()) {
                    Timber.e((String)"discoverServices failed to start", (Object[])new Object[0]);
                }
                BluetoothPeripheral.this.discoverServicesRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.discoverServicesRunnable, delay);
    }

    private long getServiceDiscoveryDelay(int bondstate) {
        long delayWhenBonded = 0L;
        if (Build.VERSION.SDK_INT <= 24) {
            delayWhenBonded = 1000L;
        }
        return bondstate == 12 ? delayWhenBonded : 0L;
    }

    private void successfullyDisconnected(int previousState) {
        if (previousState == 2 || previousState == 3) {
            Timber.i((String)"disconnected '%s' on request", (Object[])new Object[]{this.getName()});
        } else if (previousState == 1) {
            Timber.i((String)"cancelling connect attempt", (Object[])new Object[0]);
        }
        if (this.bondLost) {
            this.completeDisconnect(false, 0);
            if (this.listener != null) {
                this.callbackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.listener.connectFailed(BluetoothPeripheral.this, 0);
                    }
                }, 1000L);
            }
        } else {
            this.completeDisconnect(true, 0);
        }
    }

    private void connectionStateChangeUnsuccessful(int status, int previousState, int newState, long timePassed) {
        boolean servicesDiscovered;
        if (this.discoverServicesRunnable != null) {
            this.mainHandler.removeCallbacks(this.discoverServicesRunnable);
            this.discoverServicesRunnable = null;
        }
        boolean bl = servicesDiscovered = !this.getServices().isEmpty();
        if (previousState == 1) {
            boolean isTimeout = timePassed > (long)this.getTimoutThreshold();
            Timber.i((String)"connection failed with status '%s' (%s)", (Object[])new Object[]{BluetoothPeripheral.statusToString(status), isTimeout ? "TIMEOUT" : "ERROR"});
            int adjustedStatus = status == 133 && isTimeout ? 8 : status;
            this.completeDisconnect(false, adjustedStatus);
            if (this.listener != null) {
                this.listener.connectFailed(this, adjustedStatus);
            }
        } else if (previousState == 2 && newState == 0 && !servicesDiscovered) {
            Timber.i((String)"peripheral '%s' disconnected with status '%s' before completing service discovery", (Object[])new Object[]{this.getName(), BluetoothPeripheral.statusToString(status)});
            this.completeDisconnect(false, status);
            if (this.listener != null) {
                this.listener.connectFailed(this, status);
            }
        } else {
            if (newState == 0) {
                Timber.i((String)"peripheral '%s' disconnected with status '%s'", (Object[])new Object[]{this.getName(), BluetoothPeripheral.statusToString(status)});
            } else {
                Timber.i((String)"unexpected connection state change for '%s' status '%s'", (Object[])new Object[]{this.getName(), BluetoothPeripheral.statusToString(status)});
            }
            this.completeDisconnect(true, status);
        }
    }

    private void handleBondStateChange(int bondState, int previousBondState) {
        switch (bondState) {
            case 11: {
                Timber.d((String)"starting bonding with '%s' (%s)", (Object[])new Object[]{this.getName(), this.getAddress()});
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onBondingStarted(BluetoothPeripheral.this);
                    }
                });
                break;
            }
            case 12: {
                Timber.d((String)"bonded with '%s' (%s)", (Object[])new Object[]{this.getName(), this.getAddress()});
                this.callbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothPeripheral.this.peripheralCallback.onBondingSucceeded(BluetoothPeripheral.this);
                    }
                });
                if (this.bluetoothGatt.getServices().isEmpty()) {
                    this.delayedDiscoverServices(0L);
                }
                if (Build.VERSION.SDK_INT < 26 && this.commandQueueBusy && !this.manuallyBonding) {
                    this.mainHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Timber.d((String)"retrying command after bonding", (Object[])new Object[0]);
                            BluetoothPeripheral.this.retryCommand();
                        }
                    }, 50L);
                }
                if (!this.manuallyBonding) break;
                this.manuallyBonding = false;
                this.completedCommand();
                break;
            }
            case 10: {
                if (previousBondState == 11) {
                    Timber.e((String)"bonding failed for '%s', disconnecting device", (Object[])new Object[]{this.getName()});
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onBondingFailed(BluetoothPeripheral.this);
                        }
                    });
                } else {
                    Timber.e((String)"bond lost for '%s'", (Object[])new Object[]{this.getName()});
                    this.bondLost = true;
                    if (this.discoverServicesRunnable != null) {
                        this.mainHandler.removeCallbacks(this.discoverServicesRunnable);
                        this.discoverServicesRunnable = null;
                    }
                    this.callbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            BluetoothPeripheral.this.peripheralCallback.onBondLost(BluetoothPeripheral.this);
                        }
                    });
                }
                this.disconnect();
            }
        }
    }

    BluetoothPeripheral(@NotNull Context context, @NotNull BluetoothDevice device, @NotNull InternalCallback listener, BluetoothPeripheralCallback peripheralCallback, Handler callbackHandler) {
        Objects.requireNonNull(context, "no valid context provided");
        Objects.requireNonNull(device, "no valid device provided");
        Objects.requireNonNull(listener, "no valid listener provided");
        this.context = context;
        this.device = device;
        this.peripheralCallback = peripheralCallback;
        this.listener = listener;
        this.callbackHandler = callbackHandler != null ? callbackHandler : new Handler(Looper.getMainLooper());
        this.state = 0;
        this.commandQueueBusy = false;
    }

    void setPeripheralCallback(@NotNull BluetoothPeripheralCallback peripheralCallback) {
        this.peripheralCallback = Objects.requireNonNull(peripheralCallback, "no valid peripheral callback provided");
    }

    void connect() {
        if (this.state == 0) {
            this.mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Timber.i((String)"connect to '%s' (%s) using TRANSPORT_LE", (Object[])new Object[]{BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.registerBondingBroadcastReceivers();
                    BluetoothPeripheral.this.state = 1;
                    BluetoothPeripheral.this.bluetoothGatt = BluetoothPeripheral.this.connectGattHelper(BluetoothPeripheral.this.device, false, BluetoothPeripheral.this.bluetoothGattCallback);
                    BluetoothPeripheral.this.connectTimestamp = SystemClock.elapsedRealtime();
                    BluetoothPeripheral.this.startConnectionTimer(BluetoothPeripheral.this);
                }
            }, 100L);
        } else {
            Timber.e((String)"peripheral '%s' not yet disconnected, will not connect", (Object[])new Object[]{this.getName()});
        }
    }

    void autoConnect() {
        if (this.state == 0) {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    Timber.i((String)"autoConnect to '%s' (%s) using TRANSPORT_LE", (Object[])new Object[]{BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.registerBondingBroadcastReceivers();
                    BluetoothPeripheral.this.state = 1;
                    BluetoothPeripheral.this.bluetoothGatt = BluetoothPeripheral.this.connectGattHelper(BluetoothPeripheral.this.device, true, BluetoothPeripheral.this.bluetoothGattCallback);
                    BluetoothPeripheral.this.connectTimestamp = SystemClock.elapsedRealtime();
                }
            });
        } else {
            Timber.e((String)"peripheral '%s' not yet disconnected, will not connect", (Object[])new Object[]{this.getName()});
        }
    }

    private void registerBondingBroadcastReceivers() {
        this.context.registerReceiver(this.bondStateReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
        this.context.registerReceiver(this.pairingRequestBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST"));
    }

    public boolean createBond() {
        if (this.bluetoothGatt == null) {
            return this.device.createBond();
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                BluetoothPeripheral.this.manuallyBonding = true;
                if (!BluetoothPeripheral.this.device.createBond()) {
                    Timber.e((String)"bonding failed for %s", (Object[])new Object[]{BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.completedCommand();
                } else {
                    Timber.d((String)"manually bonding %s", (Object[])new Object[]{BluetoothPeripheral.this.getAddress()});
                    BluetoothPeripheral.this.nrTries++;
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue bonding command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean requestConnectionPriority(final int priority) {
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.requestConnectionPriority(priority)) {
                        Timber.e((String)"could not set connection priority", (Object[])new Object[0]);
                    } else {
                        Timber.d((String)"requesting connection priority %d", (Object[])new Object[]{priority});
                    }
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue request connection priority command", (Object[])new Object[0]);
        }
        return result;
    }

    private boolean createBond(int transport) {
        Timber.d((String)"bonding using TRANSPORT_LE", (Object[])new Object[0]);
        boolean result = false;
        try {
            Method bondMethod = this.device.getClass().getMethod("createBond", Integer.TYPE);
            if (bondMethod != null) {
                result = (Boolean)bondMethod.invoke((Object)this.device, transport);
            }
        }
        catch (Exception e) {
            Timber.e((String)"could not invoke createBond method", (Object[])new Object[0]);
        }
        return result;
    }

    public void cancelConnection() {
        if (this.bluetoothGatt == null) {
            Timber.w((String)"cannot cancel connection because no connection attempt is made yet", (Object[])new Object[0]);
            return;
        }
        if (this.state == 0 || this.state == 3) {
            return;
        }
        this.cancelConnectionTimer();
        if (this.state == 1) {
            this.disconnect();
            this.mainHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BluetoothPeripheral.this.bluetoothGattCallback.onConnectionStateChange(BluetoothPeripheral.this.bluetoothGatt, 0, 0);
                }
            }, 50L);
        } else {
            this.disconnect();
        }
    }

    private void disconnect() {
        if (this.state == 2 || this.state == 1) {
            this.state = 3;
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (BluetoothPeripheral.this.bluetoothGatt != null) {
                        Timber.i((String)"force disconnect '%s' (%s)", (Object[])new Object[]{BluetoothPeripheral.this.getName(), BluetoothPeripheral.this.getAddress()});
                        BluetoothPeripheral.this.bluetoothGatt.disconnect();
                    }
                }
            });
        } else if (this.listener != null) {
            this.listener.disconnected(this, 22);
        }
    }

    void disconnectWhenBluetoothOff() {
        this.bluetoothGatt = null;
        this.completeDisconnect(true, 0);
    }

    private void completeDisconnect(boolean notify, int status) {
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.close();
            this.bluetoothGatt = null;
        }
        this.commandQueue.clear();
        this.commandQueueBusy = false;
        try {
            this.context.unregisterReceiver(this.bondStateReceiver);
            this.context.unregisterReceiver(this.pairingRequestBroadcastReceiver);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.bondLost = false;
        if (this.listener != null && notify) {
            this.listener.disconnected(this, status);
        }
    }

    @NotNull
    public String getAddress() {
        return this.device.getAddress();
    }

    public int getType() {
        return this.device.getType();
    }

    public String getName() {
        String name = this.device.getName();
        if (name != null) {
            this.cachedName = name;
        }
        return this.cachedName;
    }

    public int getBondState() {
        return this.device.getBondState();
    }

    @NotNull
    public List<BluetoothGattService> getServices() {
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getServices();
        }
        return Collections.emptyList();
    }

    @Nullable
    public BluetoothGattService getService(@NotNull UUID serviceUUID) {
        Objects.requireNonNull(serviceUUID, "no valid service UUID provided");
        if (this.bluetoothGatt != null) {
            return this.bluetoothGatt.getService(serviceUUID);
        }
        return null;
    }

    @Nullable
    public BluetoothGattCharacteristic getCharacteristic(@NotNull UUID serviceUUID, @NotNull UUID characteristicUUID) {
        Objects.requireNonNull(serviceUUID, "no valid service UUID provided");
        Objects.requireNonNull(characteristicUUID, "no valid characteristic provided");
        BluetoothGattService service = this.getService(serviceUUID);
        if (service != null) {
            return service.getCharacteristic(characteristicUUID);
        }
        return null;
    }

    public int getState() {
        return this.state;
    }

    public boolean isNotifying(@NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, "no valid characteristic provided");
        return this.notifyingCharacteristics.contains(characteristic.getUuid());
    }

    private boolean isConnected() {
        return this.bluetoothGatt != null && this.state == 2;
    }

    public boolean readCharacteristic(final @NotNull BluetoothGattCharacteristic characteristic) {
        Objects.requireNonNull(characteristic, "characteristic is 'null', ignoring read request");
        if (this.bluetoothGatt == null) {
            Timber.e((String)"gatt is 'null', ignoring read request", (Object[])new Object[0]);
            return false;
        }
        if ((characteristic.getProperties() & 2) == 0) {
            Timber.e((String)"characteristic does not have read property", (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readCharacteristic(characteristic)) {
                        Timber.e((String)"readCharacteristic failed for characteristic: %s", (Object[])new Object[]{characteristic.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        Timber.d((String)"reading characteristic <%s>", (Object[])new Object[]{characteristic.getUuid()});
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue read characteristic command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean writeCharacteristic(final @NotNull BluetoothGattCharacteristic characteristic, @NotNull byte[] value, final int writeType) {
        int writeProperty;
        Objects.requireNonNull(characteristic, "no valid characteristic provided");
        Objects.requireNonNull(value, "no valid value provided");
        if (this.bluetoothGatt == null) {
            Timber.e((String)"gatt is 'null', ignoring read request", (Object[])new Object[0]);
            return false;
        }
        final byte[] bytesToWrite = this.copyOf(value);
        switch (writeType) {
            case 2: {
                writeProperty = 8;
                break;
            }
            case 1: {
                writeProperty = 4;
                break;
            }
            case 4: {
                writeProperty = 64;
                break;
            }
            default: {
                writeProperty = 0;
            }
        }
        if ((characteristic.getProperties() & writeProperty) == 0) {
            Timber.e((String)"characteristic <%s> does not support writeType '%s'", (Object[])new Object[]{characteristic.getUuid(), this.writeTypeToString(writeType)});
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    BluetoothPeripheral.access$1202(BluetoothPeripheral.this, bytesToWrite);
                    characteristic.setValue(bytesToWrite);
                    characteristic.setWriteType(writeType);
                    if (!BluetoothPeripheral.this.bluetoothGatt.writeCharacteristic(characteristic)) {
                        Timber.e((String)"writeCharacteristic failed for characteristic: %s", (Object[])new Object[]{characteristic.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        Timber.d((String)"writing <%s> to characteristic <%s>", (Object[])new Object[]{BluetoothPeripheral.bytes2String(bytesToWrite), characteristic.getUuid()});
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue write characteristic command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean readDescriptor(final @NotNull BluetoothGattDescriptor descriptor) {
        Objects.requireNonNull(descriptor, "no valid descriptor provided");
        if (this.bluetoothGatt == null) {
            Timber.e((String)"gatt is 'null', ignoring read request", (Object[])new Object[0]);
            return false;
        }
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readDescriptor(descriptor)) {
                        Timber.e((String)"readDescriptor failed for characteristic: %s", (Object[])new Object[]{descriptor.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue read descriptor command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean writeDescriptor(final @NotNull BluetoothGattDescriptor descriptor, @NotNull byte[] value) {
        Objects.requireNonNull(descriptor, "no valid descriptor provided");
        Objects.requireNonNull(value, "no valid value provided");
        if (this.bluetoothGatt == null) {
            Timber.e((String)"gatt is 'null', ignoring write descriptor request", (Object[])new Object[0]);
            return false;
        }
        final byte[] bytesToWrite = this.copyOf(value);
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    BluetoothPeripheral.access$1202(BluetoothPeripheral.this, bytesToWrite);
                    descriptor.setValue(bytesToWrite);
                    if (!BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(descriptor)) {
                        Timber.e((String)"writeDescriptor failed for descriptor: %s", (Object[])new Object[]{descriptor.getUuid()});
                        BluetoothPeripheral.this.completedCommand();
                    } else {
                        Timber.d((String)"writing <%s> to descriptor <%s>", (Object[])new Object[]{BluetoothPeripheral.bytes2String(bytesToWrite), descriptor.getUuid()});
                        BluetoothPeripheral.this.nrTries++;
                    }
                } else {
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue write descriptor command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean setNotify(final @NotNull BluetoothGattCharacteristic characteristic, final boolean enable) {
        byte[] value;
        Objects.requireNonNull(characteristic, "no valid characteristic provided");
        if (this.bluetoothGatt == null) {
            Timber.e((String)"gatt is 'null', ignoring set notify request", (Object[])new Object[0]);
            return false;
        }
        final BluetoothGattDescriptor descriptor = characteristic.getDescriptor(UUID.fromString(CCC_DESCRIPTOR_UUID));
        if (descriptor == null) {
            Timber.e((String)"could not get CCC descriptor for characteristic %s", (Object[])new Object[]{characteristic.getUuid()});
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 0x10) > 0) {
            value = BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE;
        } else if ((properties & 0x20) > 0) {
            value = BluetoothGattDescriptor.ENABLE_INDICATION_VALUE;
        } else {
            Timber.e((String)"characteristic %s does not have notify or indicate property", (Object[])new Object[]{characteristic.getUuid()});
            return false;
        }
        final byte[] finalValue = enable ? value : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                boolean result;
                if (!BluetoothPeripheral.this.isConnected()) {
                    BluetoothPeripheral.this.completedCommand();
                    return;
                }
                if (!BluetoothPeripheral.this.bluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
                    Timber.e((String)"setCharacteristicNotification failed for characteristic: %s", (Object[])new Object[]{characteristic.getUuid()});
                }
                BluetoothPeripheral.access$1202(BluetoothPeripheral.this, finalValue);
                descriptor.setValue(finalValue);
                if (Build.VERSION.SDK_INT >= 24) {
                    result = BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(descriptor);
                } else {
                    BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
                    int originalWriteType = parentCharacteristic.getWriteType();
                    parentCharacteristic.setWriteType(2);
                    result = BluetoothPeripheral.this.bluetoothGatt.writeDescriptor(descriptor);
                    parentCharacteristic.setWriteType(originalWriteType);
                }
                if (!result) {
                    Timber.e((String)"writeDescriptor failed for descriptor: %s", (Object[])new Object[]{descriptor.getUuid()});
                    BluetoothPeripheral.this.completedCommand();
                } else {
                    BluetoothPeripheral.this.nrTries++;
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue setNotify command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean clearServicesCache() {
        boolean result = false;
        try {
            Method refreshMethod = this.bluetoothGatt.getClass().getMethod("refresh", new Class[0]);
            if (refreshMethod != null) {
                result = (Boolean)refreshMethod.invoke((Object)this.bluetoothGatt, new Object[0]);
            }
        }
        catch (Exception e) {
            Timber.e((String)"could not invoke refresh method", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean readRemoteRssi() {
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.readRemoteRssi()) {
                        Timber.e((String)"readRemoteRssi failed", (Object[])new Object[0]);
                        BluetoothPeripheral.this.completedCommand();
                    }
                } else {
                    Timber.e((String)"cannot get rssi, peripheral not connected", (Object[])new Object[0]);
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue setNotify command", (Object[])new Object[0]);
        }
        return result;
    }

    public boolean requestMtu(final int mtu) {
        boolean result = this.commandQueue.add(new Runnable(){

            @Override
            public void run() {
                if (BluetoothPeripheral.this.isConnected()) {
                    if (!BluetoothPeripheral.this.bluetoothGatt.requestMtu(mtu)) {
                        Timber.e((String)"requestMtu failed", (Object[])new Object[0]);
                        BluetoothPeripheral.this.completedCommand();
                    }
                } else {
                    Timber.e((String)"cannot request MTU, peripheral not connected", (Object[])new Object[0]);
                    BluetoothPeripheral.this.completedCommand();
                }
            }
        });
        if (result) {
            this.nextCommand();
        } else {
            Timber.e((String)"could not enqueue setNotify command", (Object[])new Object[0]);
        }
        return result;
    }

    private void completedCommand() {
        this.isRetrying = false;
        this.commandQueue.poll();
        this.commandQueueBusy = false;
        this.nextCommand();
    }

    private void retryCommand() {
        this.commandQueueBusy = false;
        Runnable currentCommand = this.commandQueue.peek();
        if (currentCommand != null) {
            if (this.nrTries >= 2) {
                Timber.d((String)"max number of tries reached, not retrying operation anymore", (Object[])new Object[0]);
                this.commandQueue.poll();
            } else {
                this.isRetrying = true;
            }
        }
        this.nextCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextCommand() {
        BluetoothPeripheral bluetoothPeripheral = this;
        synchronized (bluetoothPeripheral) {
            if (this.commandQueueBusy) {
                return;
            }
            final Runnable bluetoothCommand = this.commandQueue.peek();
            if (bluetoothCommand == null) {
                return;
            }
            if (this.bluetoothGatt == null) {
                Timber.e((String)"gatt is 'null' for peripheral '%s', clearing command queue", (Object[])new Object[]{this.getAddress()});
                this.commandQueue.clear();
                this.commandQueueBusy = false;
                return;
            }
            this.commandQueueBusy = true;
            if (!this.isRetrying) {
                this.nrTries = 0;
            }
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        bluetoothCommand.run();
                    }
                    catch (Exception ex) {
                        Timber.e((Throwable)ex, (String)"command exception for device '%s'", (Object[])new Object[]{BluetoothPeripheral.this.getName()});
                        BluetoothPeripheral.this.completedCommand();
                    }
                }
            });
        }
    }

    private String bondStateToString(int state) {
        switch (state) {
            case 10: {
                return "BOND_NONE";
            }
            case 11: {
                return "BOND_BONDING";
            }
            case 12: {
                return "BOND_BONDED";
            }
        }
        return "UNKNOWN";
    }

    private String stateToString(int state) {
        switch (state) {
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
        }
        return "DISCONNECTED";
    }

    private String writeTypeToString(int writeType) {
        switch (writeType) {
            case 2: {
                return "WRITE_TYPE_DEFAULT";
            }
            case 1: {
                return "WRITE_TYPE_NO_RESPONSE";
            }
            case 4: {
                return "WRITE_TYPE_SIGNED";
            }
        }
        return "unknown writeType";
    }

    private static String statusToString(int error) {
        switch (error) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "GATT CONN L2C FAILURE";
            }
            case 8: {
                return "GATT CONN TIMEOUT";
            }
            case 19: {
                return "GATT CONN TERMINATE PEER USER";
            }
            case 22: {
                return "GATT CONN TERMINATE LOCAL HOST";
            }
            case 61: {
                return "BLE HCI CONN TERMINATED DUE TO MIC FAILURE";
            }
            case 62: {
                return "GATT CONN FAIL ESTABLISH";
            }
            case 34: {
                return "GATT CONN LMP TIMEOUT";
            }
            case 256: {
                return "GATT CONN CANCEL ";
            }
            case 132: {
                return "GATT BUSY";
            }
            case 133: {
                return "GATT ERROR";
            }
            case 137: {
                return "GATT AUTH FAIL";
            }
            case 128: {
                return "GATT NO RESOURCES";
            }
            case 129: {
                return "GATT INTERNAL ERROR";
            }
        }
        return "UNKNOWN (" + error + ")";
    }

    private String pairingVariantToString(int variant) {
        switch (variant) {
            case 0: {
                return "PAIRING_VARIANT_PIN";
            }
            case 1: {
                return "PAIRING_VARIANT_PASSKEY";
            }
            case 2: {
                return "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            }
            case 3: {
                return "PAIRING_VARIANT_CONSENT";
            }
            case 4: {
                return "PAIRING_VARIANT_DISPLAY_PASSKEY";
            }
            case 5: {
                return "PAIRING_VARIANT_DISPLAY_PIN";
            }
            case 6: {
                return "PAIRING_VARIANT_OOB_CONSENT";
            }
        }
        return "UNKNOWN";
    }

    private static String bytes2String(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private BluetoothGatt connectGattHelper(BluetoothDevice remoteDevice, boolean autoConnect, BluetoothGattCallback bluetoothGattCallback) {
        if (remoteDevice == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 24 || !autoConnect) {
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, autoConnect);
        }
        try {
            Object iBluetoothGatt = this.getIBluetoothGatt(this.getIBluetoothManager());
            if (iBluetoothGatt == null) {
                Timber.e((String)"could not get iBluetoothGatt object", (Object[])new Object[0]);
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            BluetoothGatt bluetoothGatt = this.createBluetoothGatt(iBluetoothGatt, remoteDevice);
            if (bluetoothGatt == null) {
                Timber.e((String)"could not create BluetoothGatt object", (Object[])new Object[0]);
                return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
            }
            boolean connectedSuccessfully = this.connectUsingReflection(remoteDevice, bluetoothGatt, bluetoothGattCallback, true);
            if (!connectedSuccessfully) {
                Timber.i((String)"connection using reflection failed, closing gatt", (Object[])new Object[0]);
                bluetoothGatt.close();
            }
            return bluetoothGatt;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException exception) {
            Timber.e((String)"error during reflection", (Object[])new Object[0]);
            return this.connectGattCompat(bluetoothGattCallback, remoteDevice, true);
        }
    }

    private BluetoothGatt connectGattCompat(BluetoothGattCallback bluetoothGattCallback, BluetoothDevice device, boolean autoConnect) {
        if (Build.VERSION.SDK_INT >= 23) {
            return device.connectGatt(this.context, autoConnect, bluetoothGattCallback, 2);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Method connectGattMethod = device.getClass().getMethod("connectGatt", Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE);
                try {
                    return (BluetoothGatt)connectGattMethod.invoke((Object)device, this.context, autoConnect, bluetoothGattCallback, 2);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return device.connectGatt(this.context, autoConnect, bluetoothGattCallback);
    }

    private boolean connectUsingReflection(BluetoothDevice device, BluetoothGatt bluetoothGatt, BluetoothGattCallback bluetoothGattCallback, boolean autoConnect) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        this.setAutoConnectValue(bluetoothGatt, autoConnect);
        Method connectMethod = bluetoothGatt.getClass().getDeclaredMethod("connect", Boolean.class, BluetoothGattCallback.class);
        connectMethod.setAccessible(true);
        return (Boolean)connectMethod.invoke((Object)bluetoothGatt, true, bluetoothGattCallback);
    }

    private BluetoothGatt createBluetoothGatt(Object iBluetoothGatt, BluetoothDevice remoteDevice) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> bluetoothGattConstructor = BluetoothGatt.class.getDeclaredConstructors()[0];
        bluetoothGattConstructor.setAccessible(true);
        if (bluetoothGattConstructor.getParameterTypes().length == 4) {
            return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice, 2);
        }
        return (BluetoothGatt)bluetoothGattConstructor.newInstance(this.context, iBluetoothGatt, remoteDevice);
    }

    private Object getIBluetoothGatt(Object iBluetoothManager) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (iBluetoothManager == null) {
            return null;
        }
        Method getBluetoothGattMethod = this.getMethodFromClass(iBluetoothManager.getClass(), "getBluetoothGatt");
        return getBluetoothGattMethod.invoke(iBluetoothManager, new Object[0]);
    }

    private Object getIBluetoothManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            return null;
        }
        Method getBluetoothManagerMethod = this.getMethodFromClass(bluetoothAdapter.getClass(), "getBluetoothManager");
        return getBluetoothManagerMethod.invoke((Object)bluetoothAdapter, new Object[0]);
    }

    private Method getMethodFromClass(Class<?> cls, String methodName) throws NoSuchMethodException {
        Method method = cls.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method;
    }

    private void setAutoConnectValue(BluetoothGatt bluetoothGatt, boolean autoConnect) throws NoSuchFieldException, IllegalAccessException {
        Field autoConnectField = bluetoothGatt.getClass().getDeclaredField("mAutoConnect");
        autoConnectField.setAccessible(true);
        autoConnectField.setBoolean(bluetoothGatt, autoConnect);
    }

    private void startConnectionTimer(final BluetoothPeripheral peripheral) {
        this.cancelConnectionTimer();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Timber.e((String)"connection timout, disconnecting '%s'", (Object[])new Object[]{peripheral.getName()});
                BluetoothPeripheral.this.disconnect();
                BluetoothPeripheral.this.completeDisconnect(true, 8);
                BluetoothPeripheral.this.timeoutRunnable = null;
            }
        };
        this.mainHandler.postDelayed(this.timeoutRunnable, 35000L);
    }

    private void cancelConnectionTimer() {
        if (this.timeoutRunnable != null) {
            this.mainHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private int getTimoutThreshold() {
        String manufacturer = Build.MANUFACTURER;
        if (manufacturer.equals("samsung")) {
            return 4500;
        }
        return 25000;
    }

    private byte[] copyOf(byte[] source) {
        if (source == null) {
            return new byte[0];
        }
        int sourceLength = source.length;
        byte[] copy = new byte[sourceLength];
        System.arraycopy(source, 0, copy, 0, sourceLength);
        return copy;
    }

    static /* synthetic */ byte[] access$1202(BluetoothPeripheral x0, byte[] x1) {
        x0.currentWriteBytes = x1;
        return x1;
    }

    static interface InternalCallback {
        public void connected(BluetoothPeripheral var1);

        public void connectFailed(BluetoothPeripheral var1, int var2);

        public void disconnected(BluetoothPeripheral var1, int var2);

        public String getPincode(BluetoothPeripheral var1);
    }
}

