/*
 * Decompiled with CFR 0.152.
 */
package com.welie.blessed;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.ParcelUuid;
import android.util.Log;
import com.welie.blessed.BluetoothCentralCallback;
import com.welie.blessed.BluetoothPeripheral;
import com.welie.blessed.BluetoothPeripheralCallback;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class BluetoothCentral {
    private final String TAG = BluetoothCentral.class.getSimpleName();
    private static final long SCAN_TIMEOUT = 180000L;
    private static final int MAX_CONNECTION_RETRIES = 1;
    private final Context context;
    private final Handler callBackHandler;
    private final BluetoothAdapter bluetoothAdapter;
    private BluetoothLeScanner bluetoothScanner;
    private BluetoothLeScanner autoConnectScanner;
    private final BluetoothCentralCallback bluetoothCentralCallback;
    private final Map<String, BluetoothPeripheral> connectedPeripheral;
    private final Map<String, BluetoothPeripheral> unconnectedPeripherals;
    private BluetoothCentralMode mode = BluetoothCentralMode.IDLE;
    private final List<String> reconnectPeripheralAddresses;
    private final Map<String, BluetoothPeripheralCallback> reconnectCallbacks;
    private String[] scanPeripheralNames;
    private final Handler timeoutHandler;
    private Runnable timeoutRunnable;
    private final Handler autoConnectHandler;
    private Runnable autoConnectRunnable;
    private final Object connectLock = new Object();
    private ScanCallback currentCallback;
    private List<ScanFilter> currentFilters;
    private ScanSettings scanSettings;
    private final ScanSettings autoConnectScanSettings;
    private final Map<String, Integer> connectionRetries = new HashMap<String, Integer>();
    private final ScanCallback scanByNameCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, final ScanResult result) {
            1 var3_3 = this;
            synchronized (var3_3) {
                String deviceName = result.getDevice().getName();
                if (deviceName != null) {
                    for (String name : BluetoothCentral.this.scanPeripheralNames) {
                        if (!deviceName.contains(name)) continue;
                        BluetoothCentral.this.callBackHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (BluetoothCentral.this.currentCallback != null) {
                                    BluetoothPeripheral peripheral = new BluetoothPeripheral(BluetoothCentral.this.context, result.getDevice(), BluetoothCentral.this.internalCallback, null, BluetoothCentral.this.callBackHandler);
                                    BluetoothCentral.this.bluetoothCentralCallback.onDiscoveredPeripheral(peripheral, result);
                                }
                            }
                        });
                        return;
                    }
                }
            }
        }
    };
    private final ScanCallback scanByServiceUUIDCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, final ScanResult result) {
            2 var3_3 = this;
            synchronized (var3_3) {
                BluetoothCentral.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (BluetoothCentral.this.currentCallback != null) {
                            BluetoothPeripheral peripheral = new BluetoothPeripheral(BluetoothCentral.this.context, result.getDevice(), BluetoothCentral.this.internalCallback, null, BluetoothCentral.this.callBackHandler);
                            BluetoothCentral.this.bluetoothCentralCallback.onDiscoveredPeripheral(peripheral, result);
                        }
                    }
                });
            }
        }

        public void onBatchScanResults(List<ScanResult> results) {
            Log.i((String)BluetoothCentral.this.TAG, (String)"onBatchScanResults");
        }

        public void onScanFailed(int errorCode) {
            Log.e((String)BluetoothCentral.this.TAG, (String)String.format("scan failed with error code %d", errorCode));
        }
    };
    private final ScanCallback autoConnectScanCallback = new ScanCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScanResult(int callbackType, ScanResult result) {
            3 var3_3 = this;
            synchronized (var3_3) {
                String deviceAddress = result.getDevice().getAddress();
                BluetoothPeripheralCallback callback = (BluetoothPeripheralCallback)BluetoothCentral.this.reconnectCallbacks.get(deviceAddress);
                BluetoothCentral.this.reconnectPeripheralAddresses.remove(deviceAddress);
                BluetoothCentral.this.reconnectCallbacks.remove(deviceAddress);
                if (BluetoothCentral.this.reconnectPeripheralAddresses.size() == 0) {
                    Log.d((String)BluetoothCentral.this.TAG, (String)String.format("Peripheral with address '%s' found, stopping autoconnect scan", deviceAddress));
                    BluetoothCentral.this.autoConnectScanner.stopScan(BluetoothCentral.this.autoConnectScanCallback);
                    BluetoothCentral.this.autoConnectScanner = null;
                    BluetoothCentral.this.cancelAutoConnectTimer();
                }
                BluetoothCentral.this.connectPeripheral(BluetoothCentral.this.getPeripheral(deviceAddress), callback);
                if (BluetoothCentral.this.reconnectPeripheralAddresses.size() > 0) {
                    BluetoothCentral.this.scanForAutoConnectPeripherals();
                }
            }
        }

        public void onScanFailed(int errorCode) {
            Log.e((String)BluetoothCentral.this.TAG, (String)String.format("scan failed with error code %d", errorCode));
        }
    };
    private final BluetoothPeripheral.InternalCallback internalCallback = new BluetoothPeripheral.InternalCallback(){

        @Override
        public void connected(final BluetoothPeripheral peripheral) {
            Log.i((String)BluetoothCentral.this.TAG, (String)String.format("connected to '%s' (%s)", peripheral.getName(), peripheral.getAddress()));
            BluetoothCentral.this.updateMode(BluetoothCentralMode.IDLE, null);
            BluetoothCentral.this.connectionRetries.remove(peripheral.getAddress());
            BluetoothCentral.this.connectedPeripheral.put(peripheral.getAddress(), peripheral);
            if (BluetoothCentral.this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                BluetoothCentral.this.unconnectedPeripherals.remove(peripheral.getAddress());
            }
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onConnectedPeripheral(peripheral);
                }
            });
        }

        @Override
        public void connectFailed(final BluetoothPeripheral peripheral, final int status) {
            Integer retries;
            Log.e((String)BluetoothCentral.this.TAG, (String)String.format("ERROR: Connection to %s failed", peripheral.getAddress()));
            BluetoothCentral.this.updateMode(BluetoothCentralMode.IDLE, null);
            if (BluetoothCentral.this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                BluetoothCentral.this.unconnectedPeripherals.remove(peripheral.getAddress());
            }
            int nrRetries = 0;
            if (BluetoothCentral.this.connectionRetries.get(peripheral.getAddress()) != null && (retries = (Integer)BluetoothCentral.this.connectionRetries.get(peripheral.getAddress())) != null) {
                nrRetries = retries;
            }
            if (nrRetries < 1) {
                Log.d((String)BluetoothCentral.this.TAG, (String)String.format("retrying connection to '%s'", peripheral.getAddress()));
                BluetoothCentral.this.connectionRetries.put(peripheral.getAddress(), ++nrRetries);
                BluetoothCentral.this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                peripheral.autoConnect();
            } else {
                BluetoothCentral.this.callBackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.bluetoothCentralCallback.onConnectionFailed(peripheral, status);
                    }
                });
            }
        }

        @Override
        public void disconnected(final BluetoothPeripheral peripheral, final int status) {
            BluetoothCentral.this.connectedPeripheral.remove(peripheral.getAddress());
            if (BluetoothCentral.this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                BluetoothCentral.this.unconnectedPeripherals.remove(peripheral.getAddress());
            }
            if (BluetoothCentral.this.mode == BluetoothCentralMode.CONNECTING) {
                BluetoothCentral.this.mode = BluetoothCentralMode.IDLE;
            }
            BluetoothCentral.this.callBackHandler.post(new Runnable(){

                @Override
                public void run() {
                    BluetoothCentral.this.bluetoothCentralCallback.onDisconnectedPeripheral(peripheral, status);
                }
            });
        }
    };

    public BluetoothCentral(Context context, BluetoothCentralCallback bluetoothCentralCallback, Handler handler) {
        if (context == null) {
            Log.e((String)this.TAG, (String)"context is 'null', cannot create BluetoothCentral");
        }
        if (bluetoothCentralCallback == null) {
            Log.e((String)this.TAG, (String)"callback is 'null', cannot create BluetoothCentral");
        }
        this.context = context;
        this.bluetoothCentralCallback = bluetoothCentralCallback;
        this.callBackHandler = handler != null ? handler : new Handler();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.connectedPeripheral = new HashMap<String, BluetoothPeripheral>();
        this.unconnectedPeripherals = new HashMap<String, BluetoothPeripheral>();
        this.reconnectCallbacks = new HashMap<String, BluetoothPeripheralCallback>();
        this.timeoutHandler = new Handler();
        this.autoConnectHandler = new Handler();
        this.reconnectPeripheralAddresses = new ArrayList<String>();
        this.autoConnectScanSettings = new ScanSettings.Builder().setScanMode(0).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build();
        this.setScanMode(2);
    }

    public boolean setScanMode(int scanMode) {
        if (scanMode == 0 || scanMode == 2 || scanMode == 1 || scanMode == -1) {
            this.scanSettings = new ScanSettings.Builder().setScanMode(scanMode).setCallbackType(1).setMatchMode(1).setNumOfMatches(1).setReportDelay(0L).build();
            return true;
        }
        return false;
    }

    private void startScan(List<ScanFilter> filters, ScanSettings scanSettings, ScanCallback scanCallback) {
        if (!this.isBleReady()) {
            return;
        }
        if (this.currentCallback != null) {
            Log.e((String)this.TAG, (String)"ERROR: Other scan still active, please stop other scan first");
            return;
        }
        if (this.bluetoothScanner == null) {
            this.bluetoothScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        }
        if (this.bluetoothScanner != null) {
            this.updateMode(BluetoothCentralMode.SCANNING, this.scanByServiceUUIDCallback);
            this.bluetoothScanner.startScan(filters, scanSettings, scanCallback);
            Log.d((String)this.TAG, (String)"scan started");
        } else {
            Log.e((String)this.TAG, (String)"ERROR: Start scanning failed");
            this.updateMode(BluetoothCentralMode.IDLE, null);
        }
    }

    public void scanForPeripheralsWithServices(UUID[] serviceUUIDs) {
        this.currentFilters = null;
        if (serviceUUIDs != null) {
            this.currentFilters = new ArrayList<ScanFilter>();
            for (UUID serviceUUID : serviceUUIDs) {
                ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUUID)).build();
                this.currentFilters.add(filter);
            }
        }
        this.startScan(this.currentFilters, this.scanSettings, this.scanByServiceUUIDCallback);
    }

    public void scanForPeripheralsWithNames(String[] peripheralNames) {
        this.scanPeripheralNames = peripheralNames;
        this.startScan(null, this.scanSettings, this.scanByNameCallback);
    }

    public void scanForPeripheralsWithAddresses(String[] peripheralAddresses) {
        ArrayList<ScanFilter> filters = null;
        if (peripheralAddresses != null) {
            filters = new ArrayList<ScanFilter>();
            for (String address : peripheralAddresses) {
                ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                filters.add(filter);
            }
        }
        this.startScan(filters, this.scanSettings, this.scanByServiceUUIDCallback);
    }

    private void scanForAutoConnectPeripherals() {
        if (!this.isBleReady()) {
            return;
        }
        if (this.autoConnectScanner != null) {
            this.autoConnectScanner.stopScan(this.autoConnectScanCallback);
            this.autoConnectScanner = null;
            this.cancelAutoConnectTimer();
        }
        this.autoConnectScanner = this.bluetoothAdapter.getBluetoothLeScanner();
        if (this.autoConnectScanner != null) {
            ArrayList<ScanFilter> filters = null;
            if (this.reconnectPeripheralAddresses != null) {
                filters = new ArrayList<ScanFilter>();
                for (String address : this.reconnectPeripheralAddresses) {
                    ScanFilter filter = new ScanFilter.Builder().setDeviceAddress(address).build();
                    filters.add(filter);
                }
            }
            this.autoConnectScanner.startScan(filters, this.autoConnectScanSettings, this.autoConnectScanCallback);
            this.setAutoConnectTimer();
        } else {
            Log.e((String)this.TAG, (String)"ERROR: Start scanning failed");
        }
    }

    public void stopScan() {
        if (this.mode == BluetoothCentralMode.SCANNING) {
            Log.i((String)this.TAG, (String)"Stop scanning");
            this.cancelTimeoutTimer();
            if (this.bluetoothScanner != null) {
                this.bluetoothScanner.stopScan(this.currentCallback);
                this.updateMode(BluetoothCentralMode.IDLE, null);
            }
            this.currentCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectPeripheral(BluetoothPeripheral peripheral, BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.unconnectedPeripherals.containsKey(peripheral.getAddress())) {
                Log.d((String)this.TAG, (String)String.format("WARNING: Already connecting to %s'", peripheral.getAddress()));
                return;
            }
            if (!this.connectedPeripheral.containsKey(peripheral.getAddress())) {
                peripheral.setPeripheralCallback(peripheralCallback);
                this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
                this.updateMode(BluetoothCentralMode.CONNECTING, null);
                peripheral.connect();
            } else {
                Log.i((String)this.TAG, (String)String.format("WARNING: Already connected with %s", peripheral.getAddress()));
                this.updateMode(BluetoothCentralMode.IDLE, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoConnectPeripheral(BluetoothPeripheral peripheral, BluetoothPeripheralCallback peripheralCallback) {
        Object object = this.connectLock;
        synchronized (object) {
            if (this.unconnectedPeripherals.get(peripheral.getAddress()) != null) {
                Log.d((String)this.TAG, (String)String.format("WARNING: Already issued autoconnect for '%s' ", peripheral.getAddress()));
                return;
            }
            int deviceType = peripheral.getType();
            if (deviceType == 0) {
                Log.d((String)this.TAG, (String)String.format("peripheral with address '%s' not in Bluetooth cache, autoconnecting by scanning", peripheral.getAddress()));
                this.autoConnectPeripheralByScan(peripheral.getAddress(), peripheralCallback);
                return;
            }
            if (deviceType != 2 && deviceType != 3) {
                Log.e((String)this.TAG, (String)"peripheral does not support Bluetooth LE");
                return;
            }
            peripheral.setPeripheralCallback(peripheralCallback);
            this.unconnectedPeripherals.put(peripheral.getAddress(), peripheral);
            peripheral.autoConnect();
        }
    }

    private void autoConnectPeripheralByScan(String peripheralAddress, BluetoothPeripheralCallback peripheralCallback) {
        if (this.reconnectPeripheralAddresses.contains(peripheralAddress)) {
            Log.w((String)this.TAG, (String)"WARNING: Peripheral already on list for reconnection");
            return;
        }
        this.reconnectPeripheralAddresses.add(peripheralAddress);
        this.reconnectCallbacks.put(peripheralAddress, peripheralCallback);
        this.scanForAutoConnectPeripherals();
    }

    public void cancelAutoConnectPeripheral(String peripheralAddress) {
        BluetoothPeripheral peripheral = this.unconnectedPeripherals.get(peripheralAddress);
        if (peripheral != null) {
            peripheral.cancelAutoConnect();
            this.unconnectedPeripherals.remove(peripheralAddress);
        } else {
            this.autoConnectScanner.stopScan(this.autoConnectScanCallback);
            this.autoConnectScanner = null;
            this.reconnectPeripheralAddresses.remove(peripheralAddress);
            this.reconnectCallbacks.remove(peripheralAddress);
            if (this.reconnectPeripheralAddresses.size() > 0) {
                this.scanForAutoConnectPeripherals();
            }
        }
    }

    public void disconnectPeripheral(BluetoothPeripheral peripheral) {
        if (peripheral != null) {
            peripheral.disconnect();
        }
    }

    public BluetoothPeripheral getPeripheral(String peripheralAddress) {
        if (this.connectedPeripheral.containsKey(peripheralAddress)) {
            return this.connectedPeripheral.get(peripheralAddress);
        }
        if (this.unconnectedPeripherals.containsKey(peripheralAddress)) {
            return this.unconnectedPeripherals.get(peripheralAddress);
        }
        return new BluetoothPeripheral(this.context, this.bluetoothAdapter.getRemoteDevice(peripheralAddress), this.internalCallback, null, this.callBackHandler);
    }

    public List<BluetoothPeripheral> getConnectedPeripherals() {
        return new ArrayList<BluetoothPeripheral>(this.connectedPeripheral.values());
    }

    private boolean isBleReady() {
        if (this.isBleSupported() && this.isBleEnabled()) {
            return this.permissionsGranted();
        }
        return false;
    }

    private boolean isBleSupported() {
        if (this.bluetoothAdapter != null && this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return true;
        }
        Log.e((String)this.TAG, (String)"ERROR: BLE not supported");
        return false;
    }

    private boolean isBleEnabled() {
        if (this.bluetoothAdapter.isEnabled()) {
            return true;
        }
        Log.e((String)this.TAG, (String)"ERROR: Bluetooth disabled");
        return false;
    }

    private boolean permissionsGranted() {
        if (Build.VERSION.SDK_INT >= 23 && this.context.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0) {
            Log.e((String)this.TAG, (String)"ERROR: No location permission, cannot scan");
            return false;
        }
        return true;
    }

    private void setScanTimer() {
        if (this.timeoutRunnable != null) {
            this.timeoutHandler.removeCallbacks(this.timeoutRunnable);
        }
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                Log.d((String)BluetoothCentral.this.TAG, (String)"scanning timeout, restarting scan");
                final ScanCallback callback = BluetoothCentral.this.currentCallback;
                BluetoothCentral.this.stopScan();
                BluetoothCentral.this.callBackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.startScan(BluetoothCentral.this.currentFilters, BluetoothCentral.this.scanSettings, callback);
                    }
                }, 5000L);
            }
        };
        this.timeoutHandler.postDelayed(this.timeoutRunnable, 180000L);
    }

    private void cancelTimeoutTimer() {
        if (this.timeoutRunnable != null) {
            this.timeoutHandler.removeCallbacks(this.timeoutRunnable);
            this.timeoutRunnable = null;
        }
    }

    private void setAutoConnectTimer() {
        if (this.autoConnectRunnable != null) {
            this.autoConnectHandler.removeCallbacks(this.autoConnectRunnable);
        }
        this.autoConnectRunnable = new Runnable(){

            @Override
            public void run() {
                Log.d((String)BluetoothCentral.this.TAG, (String)"autoconnect timeout, restarting scan");
                if (BluetoothCentral.this.autoConnectScanner != null) {
                    BluetoothCentral.this.autoConnectScanner.stopScan(BluetoothCentral.this.autoConnectScanCallback);
                    BluetoothCentral.this.autoConnectScanner = null;
                }
                BluetoothCentral.this.callBackHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        BluetoothCentral.this.scanForAutoConnectPeripherals();
                    }
                }, 2000L);
            }
        };
        this.autoConnectHandler.postDelayed(this.autoConnectRunnable, 180000L);
    }

    private void cancelAutoConnectTimer() {
        if (this.autoConnectRunnable != null) {
            this.autoConnectHandler.removeCallbacks(this.autoConnectRunnable);
            this.autoConnectRunnable = null;
        }
    }

    private void updateMode(BluetoothCentralMode newMode, ScanCallback callback) {
        this.mode = newMode;
        this.currentCallback = callback;
        switch (newMode) {
            case IDLE: {
                break;
            }
            case SCANNING: {
                this.setScanTimer();
                break;
            }
        }
    }

    public boolean removeBond(String peripheralAddress) {
        Object peripheralToUnBond = null;
        Set bondedDevices = this.bluetoothAdapter.getBondedDevices();
        if (bondedDevices.size() > 0) {
            for (BluetoothDevice device : bondedDevices) {
                if (!device.getAddress().equals(peripheralAddress)) continue;
                peripheralToUnBond = device;
            }
        } else {
            return true;
        }
        if (peripheralToUnBond != null) {
            try {
                Method method = peripheralToUnBond.getClass().getMethod("removeBond", null);
                boolean result = (Boolean)method.invoke(peripheralToUnBond, (Object[])null);
                if (result) {
                    Log.i((String)this.TAG, (String)String.format("Succesfully removed bond for '%s'", peripheralToUnBond.getName()));
                }
                return result;
            }
            catch (Exception e) {
                Log.i((String)this.TAG, (String)"ERROR: could not remove bond");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static enum BluetoothCentralMode {
        IDLE,
        SCANNING,
        CONNECTING;

    }
}

