/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.payments.app;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.cipher.Signer;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.util.NonceUtil;
import com.wechat.pay.java.service.payments.app.AppService;
import com.wechat.pay.java.service.payments.app.model.CloseOrderRequest;
import com.wechat.pay.java.service.payments.app.model.PrepayRequest;
import com.wechat.pay.java.service.payments.app.model.PrepayWithRequestPaymentResponse;
import com.wechat.pay.java.service.payments.app.model.QueryOrderByIdRequest;
import com.wechat.pay.java.service.payments.app.model.QueryOrderByOutTradeNoRequest;
import com.wechat.pay.java.service.payments.model.Transaction;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServiceExtension {
    private final Signer signer;
    private final AppService appService;
    private static final Logger logger = LoggerFactory.getLogger(AppServiceExtension.class);

    private AppServiceExtension(Config config, HttpClient httpClient, HostName hostName) {
        this.signer = config.createSigner();
        AppService.Builder builder = new AppService.Builder().config(config);
        if (httpClient != null) {
            builder.httpClient(httpClient);
        }
        if (hostName != null) {
            builder.hostName(hostName);
        }
        this.appService = builder.build();
    }

    public PrepayWithRequestPaymentResponse prepayWithRequestPayment(PrepayRequest request) {
        String prepayId = this.appService.prepay(request).getPrepayId();
        long timestamp = Instant.now().getEpochSecond();
        String nonceStr = NonceUtil.createNonce((int)32);
        String message = request.getAppid() + "\n" + timestamp + "\n" + nonceStr + "\n" + prepayId + "\n";
        logger.debug("Message for RequestPayment signatures is[{}]", (Object)message);
        String sign = this.signer.sign(message).getSign();
        PrepayWithRequestPaymentResponse response = new PrepayWithRequestPaymentResponse();
        response.setAppid(request.getAppid());
        response.setPartnerId(request.getMchid());
        response.setPrepayId(prepayId);
        response.setPackageVal("Sign=WXPay");
        response.setNonceStr(nonceStr);
        response.setTimestamp(String.valueOf(timestamp));
        response.setSign(sign);
        return response;
    }

    public Transaction queryOrderById(QueryOrderByIdRequest request) {
        return this.appService.queryOrderById(request);
    }

    public Transaction queryOrderByOutTradeNo(QueryOrderByOutTradeNoRequest request) {
        return this.appService.queryOrderByOutTradeNo(request);
    }

    public void closeOrder(CloseOrderRequest request) {
        this.appService.closeOrder(request);
    }

    public static class Builder {
        private Config config;
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public AppServiceExtension build() {
            return new AppServiceExtension(this.config, this.httpClient, this.hostName);
        }
    }
}

