/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.file;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.FileRequestBody;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.util.IOUtil;
import com.wechat.pay.java.service.file.model.FileUploadResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class FileUploadService {
    private final HttpClient httpClient;

    private FileUploadService(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileUploadResponse uploadVideo(String uploadPath, String meta, String videoPath) throws IOException {
        File file = new File(videoPath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            FileUploadResponse fileUploadResponse = this.uploadFile(uploadPath, meta, file.getName(), IOUtil.toByteArray((InputStream)inputStream));
            return fileUploadResponse;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Upload video, file not found in videoPath:" + videoPath);
        }
    }

    public FileUploadResponse uploadVideo(String uploadPath, String meta, String fileName, byte[] video) {
        return this.uploadFile(uploadPath, meta, fileName, video);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileUploadResponse uploadImage(String uploadPath, String meta, String imagePath) throws IOException {
        File file = new File(imagePath);
        try (FileInputStream inputStream = new FileInputStream(file);){
            FileUploadResponse fileUploadResponse = this.uploadFile(uploadPath, meta, file.getName(), IOUtil.toByteArray((InputStream)inputStream));
            return fileUploadResponse;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Upload image, file not found in imagePath:" + imagePath);
        }
    }

    public FileUploadResponse uploadImage(String uploadPath, String meta, String fileName, byte[] image) {
        return this.uploadFile(uploadPath, meta, fileName, image);
    }

    private FileUploadResponse uploadFile(String uploadPath, String meta, String fileName, byte[] file) {
        HttpRequest request = new HttpRequest.Builder().addHeader("Accept", " */*").addHeader("Content-Type", MediaType.MULTIPART_FORM_DATA.getValue()).httpMethod(HttpMethod.POST).url(uploadPath).body((RequestBody)new FileRequestBody.Builder().meta(meta).fileName(fileName).file(file).build()).build();
        return (FileUploadResponse)this.httpClient.execute(request, FileUploadResponse.class).getServiceResponse();
    }

    public static class Builder {
        private HttpClient httpClient;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient);
            return this;
        }

        public FileUploadService build() {
            return new FileUploadService(this.httpClient);
        }
    }
}

