/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.auth;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wechat.pay.contrib.apache.httpclient.Credentials;
import com.wechat.pay.contrib.apache.httpclient.WechatPayHttpClientBuilder;
import com.wechat.pay.contrib.apache.httpclient.auth.CertificatesVerifier;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.auth.WechatPay2Validator;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import com.wechat.pay.contrib.apache.httpclient.util.PemUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdateCertificatesVerifier
implements Verifier {
    private static final Logger log = LoggerFactory.getLogger(AutoUpdateCertificatesVerifier.class);
    private static final String CertDownloadPath = "https://api.mch.weixin.qq.com/v3/certificates";
    private volatile Instant instant;
    private int minutesInterval;
    private CertificatesVerifier verifier;
    private Credentials credentials;
    private byte[] apiV3Key;
    private ReentrantLock lock = new ReentrantLock();

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key) {
        this(credentials, apiV3Key, TimeInterval.OneHour.getMinutes());
    }

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key, int minutesInterval) {
        this.credentials = credentials;
        this.apiV3Key = apiV3Key;
        this.minutesInterval = minutesInterval;
        try {
            this.autoUpdateCert();
            this.instant = Instant.now();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        if ((this.instant == null || Duration.between(this.instant, Instant.now()).toMinutes() >= (long)this.minutesInterval) && this.lock.tryLock()) {
            try {
                this.autoUpdateCert();
                this.instant = Instant.now();
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Auto update cert failed, exception = " + e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.verifier.verify(serialNumber, message, signature);
    }

    private void autoUpdateCert() throws IOException, GeneralSecurityException {
        CloseableHttpClient httpClient = WechatPayHttpClientBuilder.create().withCredentials(this.credentials).withValidator(this.verifier == null ? response -> true : new WechatPay2Validator(this.verifier)).build();
        HttpGet httpGet = new HttpGet(CertDownloadPath);
        httpGet.addHeader("Accept", "application/json");
        CloseableHttpResponse response2 = httpClient.execute((HttpUriRequest)httpGet);
        int statusCode = response2.getStatusLine().getStatusCode();
        String body = EntityUtils.toString((HttpEntity)response2.getEntity());
        if (statusCode == 200) {
            List<X509Certificate> newCertList = this.deserializeToCerts(this.apiV3Key, body);
            if (newCertList.isEmpty()) {
                log.warn("Cert list is empty");
                return;
            }
            this.verifier = new CertificatesVerifier(newCertList);
        } else {
            log.warn("Auto update cert failed, statusCode = " + statusCode + ",body = " + body);
        }
    }

    private List<X509Certificate> deserializeToCerts(byte[] apiV3Key, String body) throws GeneralSecurityException, IOException {
        AesUtil decryptor = new AesUtil(apiV3Key);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode dataNode = mapper.readTree(body).get("data");
        ArrayList<X509Certificate> newCertList = new ArrayList<X509Certificate>();
        if (dataNode != null) {
            int count = dataNode.size();
            for (int i = 0; i < count; ++i) {
                JsonNode encryptCertificateNode = dataNode.get(i).get("encrypt_certificate");
                String cert = decryptor.decryptToString(encryptCertificateNode.get("associated_data").toString().replaceAll("\"", "").getBytes("utf-8"), encryptCertificateNode.get("nonce").toString().replaceAll("\"", "").getBytes("utf-8"), encryptCertificateNode.get("ciphertext").toString().replaceAll("\"", ""));
                X509Certificate x509Cert = PemUtil.loadCertificate(new ByteArrayInputStream(cert.getBytes("utf-8")));
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    continue;
                }
                newCertList.add(x509Cert);
            }
        }
        return newCertList;
    }

    public static enum TimeInterval {
        OneHour(60),
        SixHours(360),
        TwelveHours(720);

        private int minutes;

        private TimeInterval(int minutes) {
            this.minutes = minutes;
        }

        public int getMinutes() {
            return this.minutes;
        }
    }
}

