/*
 * Decompiled with CFR 0.152.
 */
package com.rbrooks.indefinitepagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager.widget.ViewPager;
import androidx.viewpager2.widget.ViewPager2;
import com.rbrooks.indefinitepagerindicator.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\u0018\u0000 [2\u00020\u00012\u00020\u0002:\u0003[\\]B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010'\u001a\u00020(2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010)\u001a\u00020(2\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010*\u001a\u00020(2\u0006\u0010%\u001a\u00020&J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0019H\u0002J\b\u0010-\u001a\u00020\bH\u0002J&\u0010.\u001a\u00020\r2\b\b\u0002\u0010/\u001a\u0002002\b\b\u0002\u00101\u001a\u00020!2\b\b\u0001\u00102\u001a\u00020\bH\u0002J\b\u00103\u001a\u00020\bH\u0002J\u0010\u00104\u001a\u00020\u00192\u0006\u00105\u001a\u00020\bH\u0002J\b\u00106\u001a\u00020\bH\u0002J\b\u00107\u001a\u00020\bH\u0002J\u0010\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\u0019H\u0002J\u0010\u0010:\u001a\u00020\b2\u0006\u00105\u001a\u00020\bH\u0002J\u0010\u0010;\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u0019H\u0002J\u001c\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190=2\u0006\u00109\u001a\u00020\u0019H\u0002J\b\u0010>\u001a\u00020!H\u0002J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AH\u0014J\u0018\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020\b2\u0006\u0010D\u001a\u00020\bH\u0014J\u0010\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020\bH\u0016J \u0010G\u001a\u00020(2\u0006\u00105\u001a\u00020\b2\u0006\u0010H\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\bH\u0016J\u0010\u0010J\u001a\u00020(2\u0006\u00105\u001a\u00020\bH\u0016J\b\u0010K\u001a\u00020(H\u0002J\u0010\u0010L\u001a\u00020(2\b\b\u0001\u0010M\u001a\u00020\bJ\u000e\u0010N\u001a\u00020(2\u0006\u0010O\u001a\u00020\bJ\u000e\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u00020\bJ\u000e\u0010R\u001a\u00020(2\u0006\u0010S\u001a\u00020\bJ\u000e\u0010T\u001a\u00020(2\u0006\u0010O\u001a\u00020\bJ\u000e\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u00020!J\u0010\u0010W\u001a\u00020(2\b\b\u0001\u0010X\u001a\u00020\bJ\u000e\u0010Y\u001a\u00020(2\u0006\u0010Q\u001a\u00020\bJ\u000e\u0010Z\u001a\u00020(2\u0006\u0010\"\u001a\u00020!R\u0012\u0010\n\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator;", "Landroid/view/View;", "Landroidx/viewpager/widget/ViewPager$OnPageChangeListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dotColor", "dotCount", "dotPaint", "Landroid/graphics/Paint;", "dotRadiusPx", "dotSeparationDistancePx", "fadingDotCount", "intermediateSelectedItemPosition", "internalPageChangeCallback", "Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$InternalPageChangeCallback;", "internalRecyclerScrollListener", "Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$InternalRecyclerScrollListener;", "interpolator", "Landroid/view/animation/DecelerateInterpolator;", "offsetPercent", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "selectedDotColor", "selectedDotPaint", "selectedDotRadiusPx", "selectedItemPosition", "supportRtl", "", "verticalSupport", "viewPager", "Landroidx/viewpager/widget/ViewPager;", "viewPager2", "Landroidx/viewpager2/widget/ViewPager2;", "attachToRecyclerView", "", "attachToViewPager", "attachToViewPager2", "dpToPx", "dp", "getCalculatedWidth", "getDefaultPaintConfig", "defaultStyle", "Landroid/graphics/Paint$Style;", "isAntiAliasDefault", "defaultColor", "getDistanceBetweenTheCenterOfTwoDots", "getDotCoordinate", "position", "getDotYCoordinate", "getItemCount", "getPaint", "coordinate", "getRTLPosition", "getRadius", "getXYPositionsByCoordinate", "Lkotlin/Pair;", "isRtl", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onPageScrollStateChanged", "state", "onPageScrolled", "positionOffset", "positionOffsetPixels", "onPageSelected", "removeAllSources", "setDotColor", "newDotColor", "setDotCount", "count", "setDotRadius", "radius", "setDotSeparationDistance", "distance", "setFadingDotCount", "setRTLSupport", "supportRTL", "setSelectedDotColor", "newSelectedDotColor", "setSelectedDotRadius", "setVerticalSupport", "Companion", "InternalPageChangeCallback", "InternalRecyclerScrollListener", "indefinitepagerindicator_release"})
public final class IndefinitePagerIndicator
extends View
implements ViewPager.OnPageChangeListener {
    private RecyclerView recyclerView;
    private ViewPager viewPager;
    private ViewPager2 viewPager2;
    private InternalRecyclerScrollListener internalRecyclerScrollListener;
    private InternalPageChangeCallback internalPageChangeCallback;
    private final DecelerateInterpolator interpolator;
    private int dotCount;
    private int fadingDotCount;
    private int selectedDotRadiusPx;
    private int dotRadiusPx;
    private int dotSeparationDistancePx;
    private boolean supportRtl;
    private boolean verticalSupport;
    @ColorInt
    private int dotColor;
    @ColorInt
    private int selectedDotColor;
    private Paint selectedDotPaint;
    private Paint dotPaint;
    private int selectedItemPosition;
    private int intermediateSelectedItemPosition;
    private float offsetPercent;
    private static final int DEFAULT_DOT_COUNT = 5;
    private static final int DEFAULT_FADING_DOT_COUNT = 1;
    private static final int DEFAULT_DOT_RADIUS_DP = 4;
    private static final float DEFAULT_SELECTED_DOT_RADIUS_DP = 5.5f;
    private static final int DEFAULT_DOT_SEPARATION_DISTANCE_DP = 10;
    private static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this.getItemCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void position;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Float f = Float.valueOf(this.getDotCoordinate((int)position));
            collection.add(f);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void xPosition;
            float coordinate = ((Number)element$iv).floatValue();
            boolean bl = false;
            Pair<Float, Float> pair = this.getXYPositionsByCoordinate(coordinate);
            float position = ((Number)pair.component1()).floatValue();
            float yPosition = ((Number)pair.component2()).floatValue();
            canvas.drawCircle((float)xPosition, yPosition, this.getRadius(coordinate), this.getPaint(coordinate));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumViewSize = 2 * this.selectedDotRadiusPx;
        if (this.verticalSupport) {
            this.setMeasuredDimension(minimumViewSize, this.getCalculatedWidth());
        } else {
            this.setMeasuredDimension(this.getCalculatedWidth(), minimumViewSize);
        }
    }

    public final void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        block0: {
            this.removeAllSources();
            this.recyclerView = recyclerView;
            InternalRecyclerScrollListener internalRecyclerScrollListener = new InternalRecyclerScrollListener();
            boolean bl = false;
            boolean bl2 = false;
            InternalRecyclerScrollListener newScrollListener = internalRecyclerScrollListener;
            boolean bl3 = false;
            this.internalRecyclerScrollListener = newScrollListener;
            RecyclerView recyclerView2 = this.recyclerView;
            if (recyclerView2 == null) break block0;
            recyclerView2.addOnScrollListener((RecyclerView.OnScrollListener)newScrollListener);
        }
    }

    public final void attachToViewPager(@Nullable ViewPager viewPager) {
        this.removeAllSources();
        ViewPager viewPager2 = this.viewPager = viewPager;
        if (viewPager2 != null) {
            viewPager2.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        ViewPager viewPager3 = viewPager;
        this.selectedItemPosition = viewPager3 != null ? viewPager3.getCurrentItem() : 0;
    }

    public final void attachToViewPager2(@NotNull ViewPager2 viewPager2) {
        Intrinsics.checkNotNullParameter((Object)viewPager2, (String)"viewPager2");
        this.removeAllSources();
        this.viewPager2 = viewPager2;
        InternalPageChangeCallback internalPageChangeCallback = new InternalPageChangeCallback();
        boolean bl = false;
        boolean bl2 = false;
        InternalPageChangeCallback it = internalPageChangeCallback;
        boolean bl3 = false;
        this.internalPageChangeCallback = it;
        ViewPager2 viewPager22 = this.viewPager2;
        if (viewPager22 != null) {
            viewPager22.registerOnPageChangeCallback((ViewPager2.OnPageChangeCallback)it);
        }
        ViewPager2 viewPager23 = this.viewPager2;
        this.selectedItemPosition = viewPager23 != null ? viewPager23.getCurrentItem() : 0;
    }

    public final void setDotCount(int count) {
        this.dotCount = count;
        this.invalidate();
    }

    public final void setFadingDotCount(int count) {
        this.fadingDotCount = count;
        this.invalidate();
    }

    public final void setSelectedDotRadius(int radius) {
        this.selectedDotRadiusPx = this.dpToPx(radius);
        this.invalidate();
    }

    public final void setDotRadius(int radius) {
        this.dotRadiusPx = this.dpToPx(radius);
        this.invalidate();
    }

    public final void setDotSeparationDistance(int distance) {
        this.dotSeparationDistancePx = this.dpToPx(distance);
        this.invalidate();
    }

    public final void setRTLSupport(boolean supportRTL) {
        this.supportRtl = supportRTL;
        this.invalidate();
    }

    public final void setVerticalSupport(boolean verticalSupport) {
        this.verticalSupport = verticalSupport;
        this.invalidate();
    }

    public final void setDotColor(@ColorInt int newDotColor) {
        this.dotColor = newDotColor;
        this.dotPaint.setColor(this.dotColor);
        this.invalidate();
    }

    public final void setSelectedDotColor(@ColorInt int newSelectedDotColor) {
        this.selectedDotColor = newSelectedDotColor;
        this.selectedDotPaint.setColor(this.selectedDotColor);
        this.invalidate();
    }

    private final Paint getDefaultPaintConfig(Paint.Style defaultStyle, boolean isAntiAliasDefault, @ColorInt int defaultColor) {
        Paint paint = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$apply = paint;
        boolean bl3 = false;
        $this$apply.setStyle(defaultStyle);
        $this$apply.setAntiAlias(isAntiAliasDefault);
        $this$apply.setColor(defaultColor);
        return paint;
    }

    static /* synthetic */ Paint getDefaultPaintConfig$default(IndefinitePagerIndicator indefinitePagerIndicator, Paint.Style style, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            style = Paint.Style.FILL;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return indefinitePagerIndicator.getDefaultPaintConfig(style, bl, n);
    }

    private final Pair<Float, Float> getXYPositionsByCoordinate(float coordinate) {
        float xPosition = 0.0f;
        float yPosition = 0.0f;
        if (this.verticalSupport) {
            xPosition = this.getDotYCoordinate();
            yPosition = (float)(this.getHeight() / 2) + coordinate;
        } else {
            xPosition = (float)(this.getWidth() / 2) + coordinate;
            yPosition = this.getDotYCoordinate();
        }
        return new Pair((Object)Float.valueOf(xPosition), (Object)Float.valueOf(yPosition));
    }

    private final float getDotCoordinate(int position) {
        return (float)((position - this.intermediateSelectedItemPosition) * this.getDistanceBetweenTheCenterOfTwoDots()) + (float)this.getDistanceBetweenTheCenterOfTwoDots() * this.offsetPercent;
    }

    private final int getDotYCoordinate() {
        return this.selectedDotRadiusPx;
    }

    private final int getDistanceBetweenTheCenterOfTwoDots() {
        return 2 * this.dotRadiusPx + this.dotSeparationDistancePx;
    }

    private final float getRadius(float coordinate) {
        float f;
        boolean bl = false;
        float coordinateAbs = Math.abs(coordinate);
        float largeDotThreshold = (float)this.dotCount / (float)2 * (float)this.getDistanceBetweenTheCenterOfTwoDots();
        if (coordinateAbs < (float)(this.getDistanceBetweenTheCenterOfTwoDots() / 2)) {
            f = this.selectedDotRadiusPx;
        } else if (coordinateAbs <= largeDotThreshold) {
            f = this.dotRadiusPx;
        } else {
            float percentTowardsEdge = (coordinateAbs - largeDotThreshold) / ((float)this.getCalculatedWidth() / 2.01f - largeDotThreshold);
            f = this.interpolator.getInterpolation(1.0f - percentTowardsEdge) * (float)this.dotRadiusPx;
        }
        return f;
    }

    private final Paint getPaint(float coordinate) {
        boolean bl = false;
        return Math.abs(coordinate) < (float)(this.getDistanceBetweenTheCenterOfTwoDots() / 2) ? this.selectedDotPaint : this.dotPaint;
    }

    private final int getCalculatedWidth() {
        int maxNumVisibleDots = this.dotCount + 2 * this.fadingDotCount;
        return (maxNumVisibleDots - 1) * this.getDistanceBetweenTheCenterOfTwoDots() + 2 * this.dotRadiusPx;
    }

    private final int dpToPx(float dp) {
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        return (int)(dp * (float)(resources.getDisplayMetrics().densityDpi / 160));
    }

    private final void removeAllSources() {
        InternalRecyclerScrollListener it;
        boolean bl;
        boolean bl2;
        Object object;
        InternalRecyclerScrollListener internalRecyclerScrollListener = this.internalRecyclerScrollListener;
        if (internalRecyclerScrollListener != null) {
            object = internalRecyclerScrollListener;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)it);
            }
        }
        ViewPager viewPager = this.viewPager;
        if (viewPager != null) {
            viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        InternalPageChangeCallback internalPageChangeCallback = this.internalPageChangeCallback;
        if (internalPageChangeCallback != null) {
            object = internalPageChangeCallback;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            ViewPager2 viewPager2 = this.viewPager2;
            if (viewPager2 != null) {
                viewPager2.unregisterOnPageChangeCallback((ViewPager2.OnPageChangeCallback)it);
            }
        }
        this.recyclerView = null;
        this.viewPager = null;
        this.viewPager2 = null;
    }

    private final int getItemCount() {
        ViewPager2 viewPager2;
        ViewPager viewPager;
        RecyclerView recyclerView;
        return this.recyclerView != null ? ((recyclerView = this.recyclerView) != null && (recyclerView = recyclerView.getAdapter()) != null ? recyclerView.getItemCount() : 0) : (this.viewPager != null ? ((viewPager = this.viewPager) != null && (viewPager = viewPager.getAdapter()) != null ? viewPager.getCount() : 0) : (this.viewPager2 != null ? ((viewPager2 = this.viewPager2) != null && (viewPager2 = viewPager2.getAdapter()) != null ? viewPager2.getItemCount() : 0) : 0));
    }

    private final boolean isRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    private final int getRTLPosition(int position) {
        return this.getItemCount() - position - 1;
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.supportRtl && this.isRtl()) {
            int currentPosition;
            this.selectedItemPosition = currentPosition = this.getRTLPosition(position);
            this.intermediateSelectedItemPosition = currentPosition;
            this.offsetPercent = positionOffset * 1.0f;
        } else {
            this.selectedItemPosition = position;
            this.intermediateSelectedItemPosition = position;
            this.offsetPercent = positionOffset * (float)-1;
        }
        this.invalidate();
    }

    public void onPageSelected(int position) {
        this.intermediateSelectedItemPosition = this.selectedItemPosition;
        this.selectedItemPosition = this.supportRtl && this.isRtl() ? this.getRTLPosition(position) : position;
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
    }

    @JvmOverloads
    public IndefinitePagerIndicator(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.interpolator = new DecelerateInterpolator();
        this.dotCount = 5;
        this.fadingDotCount = 1;
        this.selectedDotRadiusPx = this.dpToPx(5.5f);
        this.dotRadiusPx = this.dpToPx(4);
        this.dotSeparationDistancePx = this.dpToPx(10);
        this.dotColor = ContextCompat.getColor((Context)context, (int)R.color.default_dot_color);
        this.selectedDotColor = ContextCompat.getColor((Context)context, (int)R.color.default_selected_dot_color);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IndefinitePagerIndicator, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026          0\n            )");
            TypedArray typedArray2 = typedArray;
            this.dotCount = typedArray2.getInteger(R.styleable.IndefinitePagerIndicator_dotCount, 5);
            this.fadingDotCount = typedArray2.getInt(R.styleable.IndefinitePagerIndicator_fadingDotCount, 1);
            this.dotRadiusPx = typedArray2.getDimensionPixelSize(R.styleable.IndefinitePagerIndicator_dotRadius, this.dotRadiusPx);
            this.selectedDotRadiusPx = typedArray2.getDimensionPixelSize(R.styleable.IndefinitePagerIndicator_selectedDotRadius, this.selectedDotRadiusPx);
            this.dotColor = typedArray2.getColor(R.styleable.IndefinitePagerIndicator_dotColor, this.dotColor);
            this.selectedDotColor = typedArray2.getColor(R.styleable.IndefinitePagerIndicator_selectedDotColor, this.selectedDotColor);
            this.dotSeparationDistancePx = typedArray2.getDimensionPixelSize(R.styleable.IndefinitePagerIndicator_dotSeparation, this.dotSeparationDistancePx);
            this.supportRtl = typedArray2.getBoolean(R.styleable.IndefinitePagerIndicator_supportRTL, false);
            this.verticalSupport = typedArray2.getBoolean(R.styleable.IndefinitePagerIndicator_verticalSupport, false);
            typedArray2.recycle();
        }
        this.selectedDotPaint = IndefinitePagerIndicator.getDefaultPaintConfig$default(this, null, false, this.selectedDotColor, 3, null);
        this.dotPaint = IndefinitePagerIndicator.getDefaultPaintConfig$default(this, null, false, this.dotColor, 3, null);
    }

    public /* synthetic */ IndefinitePagerIndicator(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public IndefinitePagerIndicator(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public IndefinitePagerIndicator(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getOffsetPercent$p(IndefinitePagerIndicator $this) {
        return $this.offsetPercent;
    }

    public static final /* synthetic */ int access$getSelectedItemPosition$p(IndefinitePagerIndicator $this) {
        return $this.selectedItemPosition;
    }

    public static final /* synthetic */ void access$setRecyclerView$p(IndefinitePagerIndicator $this, RecyclerView recyclerView) {
        $this.recyclerView = recyclerView;
    }

    public static final /* synthetic */ void access$setVerticalSupport$p(IndefinitePagerIndicator $this, boolean bl) {
        $this.verticalSupport = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\n\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$InternalRecyclerScrollListener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "(Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator;)V", "previousMostVisibleChild", "Landroid/view/View;", "calculatePercentVisible", "", "child", "getMostVisibleChild", "onScrolled", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "dx", "", "dy", "setIntermediateSelectedItemPosition", "mostVisibleChild", "indefinitepagerindicator_release"})
    public final class InternalRecyclerScrollListener
    extends RecyclerView.OnScrollListener {
        private View previousMostVisibleChild;

        public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
            int visibleItemPosition;
            Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
            View view = this.getMostVisibleChild();
            if (view != null) {
                this.setIntermediateSelectedItemPosition(view);
                IndefinitePagerIndicator.this.offsetPercent = (float)view.getLeft() / (float)view.getMeasuredWidth();
            }
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
            }
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            boolean bl = false;
            boolean bl2 = false;
            LinearLayoutManager $this$with = linearLayoutManager;
            boolean bl3 = false;
            int n = visibleItemPosition = dx >= 0 ? $this$with.findLastVisibleItemPosition() : $this$with.findFirstVisibleItemPosition();
            if (this.previousMostVisibleChild != $this$with.findViewByPosition(visibleItemPosition)) {
                IndefinitePagerIndicator.this.selectedItemPosition = IndefinitePagerIndicator.this.intermediateSelectedItemPosition;
            }
            this.previousMostVisibleChild = view;
            IndefinitePagerIndicator.this.invalidate();
        }

        /*
         * WARNING - void declaration
         */
        private final View getMostVisibleChild() {
            View mostVisibleChild = null;
            float mostVisibleChildPercent = 0.0f;
            RecyclerView recyclerView = IndefinitePagerIndicator.this.recyclerView;
            Integer n = recyclerView != null && (recyclerView = recyclerView.getLayoutManager()) != null ? Integer.valueOf(recyclerView.getChildCount()) : null;
            Intrinsics.checkNotNull(n);
            int n2 = n - 1;
            boolean bl = false;
            while (n2 >= 0) {
                float percentVisible;
                View child;
                void i;
                RecyclerView recyclerView2 = IndefinitePagerIndicator.this.recyclerView;
                View view = recyclerView2 != null && (recyclerView2 = recyclerView2.getLayoutManager()) != null ? recyclerView2.getChildAt((int)i) : (child = null);
                if (child != null && (percentVisible = this.calculatePercentVisible(child)) >= mostVisibleChildPercent) {
                    mostVisibleChildPercent = percentVisible;
                    mostVisibleChild = child;
                }
                --i;
            }
            return mostVisibleChild;
        }

        private final float calculatePercentVisible(View child) {
            int left = child.getLeft();
            int right = child.getRight();
            int width = child.getWidth();
            return left < 0 ? (float)right / (float)width : (right > IndefinitePagerIndicator.this.getWidth() ? (float)(IndefinitePagerIndicator.this.getWidth() - left) / (float)width : 1.0f);
        }

        private final void setIntermediateSelectedItemPosition(View mostVisibleChild) {
            block0: {
                RecyclerView recyclerView = IndefinitePagerIndicator.this.recyclerView;
                if (recyclerView == null || (recyclerView = recyclerView.findContainingViewHolder(mostVisibleChild)) == null) break block0;
                int n = recyclerView.getAdapterPosition();
                boolean bl = false;
                boolean bl2 = false;
                int position = n;
                boolean bl3 = false;
                IndefinitePagerIndicator.this.intermediateSelectedItemPosition = IndefinitePagerIndicator.this.isRtl() && !IndefinitePagerIndicator.this.verticalSupport ? IndefinitePagerIndicator.this.getRTLPosition(position) : position;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$InternalPageChangeCallback;", "Landroidx/viewpager2/widget/ViewPager2$OnPageChangeCallback;", "(Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator;)V", "onPageScrolled", "", "position", "", "positionOffset", "", "positionOffsetPixels", "onPageSelected", "indefinitepagerindicator_release"})
    public final class InternalPageChangeCallback
    extends ViewPager2.OnPageChangeCallback {
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            IndefinitePagerIndicator.this.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }

        public void onPageSelected(int position) {
            IndefinitePagerIndicator.this.onPageSelected(position);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/rbrooks/indefinitepagerindicator/IndefinitePagerIndicator$Companion;", "", "()V", "DEFAULT_DOT_COUNT", "", "DEFAULT_DOT_RADIUS_DP", "DEFAULT_DOT_SEPARATION_DISTANCE_DP", "DEFAULT_FADING_DOT_COUNT", "DEFAULT_SELECTED_DOT_RADIUS_DP", "", "indefinitepagerindicator_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

