/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class TimeUtils {
    public static String getFormatTime(long millTime, String format) {
        String formatTime = "";
        if (millTime > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date date = new Date();
            date.setTime(millTime);
            formatTime = sdf.format(date);
        }
        return formatTime;
    }

    public static String getFormatTime(long millTime) {
        return TimeUtils.getFormatTime(millTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatTime(String millTime) {
        return TimeUtils.getFormatTime(Long.parseLong(millTime), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getFormatTime2(String millTime) {
        return TimeUtils.getFormatTime(Long.parseLong(millTime), "yyyy-MM-dd HH:mm");
    }

    public static String getFormatTime4(String millTime) {
        return TimeUtils.getFormatTime(Long.parseLong(millTime), "MM-dd HH:mm:ss");
    }

    public static String getCurrentDate() {
        return TimeUtils.getFormatTime(System.currentTimeMillis(), "yyyy-MM-dd HH:mm:ss");
    }

    public static String getCurrentDate2() {
        return TimeUtils.getFormatTime(System.currentTimeMillis(), "yyyy-MM-dd");
    }

    public static String getCurrentDate3() {
        String date = TimeUtils.getFormatTime(System.currentTimeMillis(), "yyyy-MM-dd");
        String time = "23:59:59";
        return date + " " + time;
    }

    public static String getDate(int i) {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, i);
        date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd ");
        String dateString = formatter.format(date);
        return dateString + "00:00:00";
    }

    public static void setSystemTime(Context cxt, String datetimes) {
        try {
            Process process = Runtime.getRuntime().exec("su");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd.HHmmss");
            String datetime = formatter.format(datetimes);
            DataOutputStream os = new DataOutputStream(process.getOutputStream());
            os.writeBytes("setprop persist.sys.timezone GMT\n");
            os.writeBytes("/system/bin/date -s " + datetime + "\n");
            os.writeBytes("clock -w\n");
            os.writeBytes("exit\n");
            os.flush();
            Toast.makeText((Context)cxt, (CharSequence)"\u8bbe\u7f6e\u65f6\u95f4\u6210\u529f", (int)0).show();
        }
        catch (IOException e) {
            Toast.makeText((Context)cxt, (CharSequence)"\u8bf7\u83b7\u53d6Root\u6743\u9650", (int)0).show();
        }
    }

    public static void setCustomSystemTime(Context context, String longTime) {
        Map<String, String> map = TimeUtils.getFormatTime3(longTime);
        if (map.size() == 0) {
            return;
        }
        Intent mIntent = new Intent("android.action.concox.ACTION_CHANGE_SYSTIME");
        Bundle mBundle = new Bundle();
        mBundle.putInt("KEY_YEAR", Integer.parseInt(map.get("KEY_YEAR")));
        mBundle.putInt("KEY_MONTH", Integer.parseInt(map.get("KEY_MONTH")) - 1);
        mBundle.putInt("KEY_DAY", Integer.parseInt(map.get("KEY_DAY")));
        mBundle.putInt("KEY_HOUR", Integer.parseInt(map.get("KEY_HOUR")));
        mBundle.putInt("KEY_MINUTE", Integer.parseInt(map.get("KEY_MINUTE")));
        mIntent.putExtras(mBundle);
        context.sendBroadcast(mIntent);
    }

    public static Map<String, String> getFormatTime3(String millTime) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("KEY_YEAR", TimeUtils.getFormatTime(Long.parseLong(millTime), "yyyy"));
        map.put("KEY_MONTH", TimeUtils.getFormatTime(Long.parseLong(millTime), "MM"));
        map.put("KEY_DAY", TimeUtils.getFormatTime(Long.parseLong(millTime), "dd"));
        map.put("KEY_HOUR", TimeUtils.getFormatTime(Long.parseLong(millTime), "HH"));
        map.put("KEY_MINUTE", TimeUtils.getFormatTime(Long.parseLong(millTime), "mm"));
        return map;
    }

    public static String getFormatTime_Worksheet(String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sDateFormat = new SimpleDateFormat("MM-dd HH:mm");
        try {
            Date date = simpleDateFormat.parse(str);
            return sDateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

