/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.utils;

import android.os.Environment;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class SDCardUtils {
    private SDCardUtils() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static List<String> getExtSDCardPathList() {
        ArrayList<String> paths = new ArrayList<String>();
        String extFileStatus = Environment.getExternalStorageState();
        File extFile = Environment.getExternalStorageDirectory();
        if (extFileStatus.equals("mounted") && extFile.exists() && extFile.isDirectory() && extFile.canWrite()) {
            paths.add(extFile.getAbsolutePath());
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("mount");
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            int mountPathIndex = 1;
            while ((line = br.readLine()) != null) {
                boolean equalsToPrimarySD;
                File mountRoot;
                String mountPath;
                String[] parts;
                int length;
                if (!line.contains("fat") && !line.contains("fuse") && !line.contains("storage") || line.contains("secure") || line.contains("asec") || line.contains("firmware") || line.contains("shell") || line.contains("obb") || line.contains("legacy") || line.contains("data") || mountPathIndex >= (length = (parts = line.split(" ")).length) || !(mountPath = parts[mountPathIndex]).contains("/") || mountPath.contains("data") || mountPath.contains("Data") || !(mountRoot = new File(mountPath)).exists() || !mountRoot.isDirectory() || !mountRoot.canWrite() || (equalsToPrimarySD = mountPath.equals(extFile.getAbsolutePath()))) continue;
                paths.add(mountPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return paths;
    }

    public static boolean isSDCardEnable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getSDCardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator;
    }

    public static long getSDCardAllSize() {
        if (SDCardUtils.isSDCardEnable()) {
            StatFs stat = new StatFs(SDCardUtils.getSDCardPath());
            long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
            long freeBlocks = stat.getAvailableBlocks();
            return freeBlocks * availableBlocks;
        }
        return 0L;
    }

    public static long getFreeBytes(String filePath) {
        filePath = filePath.startsWith(SDCardUtils.getSDCardPath()) ? SDCardUtils.getSDCardPath() : Environment.getDataDirectory().getAbsolutePath();
        StatFs stat = new StatFs(filePath);
        long availableBlocks = (long)stat.getAvailableBlocks() - 4L;
        return (long)stat.getBlockSize() * availableBlocks;
    }

    public static String getRootDirectoryPath() {
        return Environment.getRootDirectory().getAbsolutePath();
    }
}

