/*
 * Decompiled with CFR 0.152.
 */
package cn.mrlong.basicframework.base;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public abstract class BaseFragment
extends Fragment {
    protected Activity mActivity;
    protected View parentView;
    protected boolean mIsVisible;
    protected boolean mIsPrepare;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mActivity = this.getActivity();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.parentView = inflater.inflate(this.setLayoutResouceId(), container, false);
        return this.parentView;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initData(this.getArguments());
        this.initView();
        this.mIsPrepare = true;
        this.onLazyLoad();
        this.initListener();
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        this.mIsVisible = isVisibleToUser;
        if (isVisibleToUser) {
            this.onVisibleToUser();
        }
    }

    protected void onVisibleToUser() {
        if (this.mIsPrepare && this.mIsVisible) {
            this.onLazyLoad();
        }
    }

    protected void onLazyLoad() {
    }

    protected <T extends View> T findViewById(int id) {
        if (this.parentView == null) {
            return null;
        }
        return (T)this.parentView.findViewById(id);
    }

    protected abstract int setLayoutResouceId();

    public abstract void initView();

    public abstract void initData(Bundle var1);

    public abstract void initListener();
}

