/*
 * Decompiled with CFR 0.152.
 */
package wrm;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Output;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import wrm.libsass.SassCompiler;

public class CompilationMojo
extends AbstractMojo {
    private File outputPath;
    private String inputPath;
    private String includePath;
    private SassCompiler.OutputStyle outputStyle;
    private boolean generateSourceComments;
    private boolean generateSourceMap;
    private String sourceMapOutputPath;
    private boolean omitSourceMapingURL;
    private boolean embedSourceMapInCSS;
    private boolean embedSourceContentsInSourceMap;
    private SassCompiler.InputSyntax inputSyntax;
    private int precision;
    private boolean failOnError;
    protected MavenProject project;
    private SassCompiler compiler;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfig();
        this.compiler = this.initCompiler();
        this.inputPath = this.inputPath.replaceAll("\\\\", "/");
        this.getLog().debug((CharSequence)("Input Path=" + this.inputPath));
        this.getLog().debug((CharSequence)("Output Path=" + this.outputPath));
        final Path root = this.project.getBasedir().toPath().resolve(Paths.get(this.inputPath, new String[0]));
        String fileExt = this.getFileExtension();
        String globPattern = "glob:{**/,}*." + fileExt;
        this.getLog().debug((CharSequence)("Glob = " + globPattern));
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(globPattern);
        final AtomicInteger errorCount = new AtomicInteger(0);
        final AtomicInteger fileCount = new AtomicInteger(0);
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file) && !file.getFileName().toString().startsWith("_")) {
                        fileCount.incrementAndGet();
                        if (!CompilationMojo.this.processFile(root, file)) {
                            errorCount.incrementAndGet();
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed", (Exception)e);
        }
        this.getLog().info((CharSequence)("Compiled " + fileCount + " files"));
        if (errorCount.get() > 0) {
            if (this.failOnError) {
                throw new MojoExecutionException("Failed with " + errorCount.get() + " errors");
            }
            this.getLog().error((CharSequence)("Failed with " + errorCount.get() + " errors. Continuing due to failOnError=false."));
        }
    }

    private String getFileExtension() {
        return this.inputSyntax.toString();
    }

    private void validateConfig() {
        if (!this.generateSourceMap) {
            if (this.embedSourceMapInCSS) {
                this.getLog().warn((CharSequence)"embedSourceMapInCSS=true is ignored. Cause: generateSourceMap=false");
            }
            if (this.embedSourceContentsInSourceMap) {
                this.getLog().warn((CharSequence)"embedSourceContentsInSourceMap=true is ignored. Cause: generateSourceMap=false");
            }
        }
        if (this.outputStyle != SassCompiler.OutputStyle.compressed && this.outputStyle != SassCompiler.OutputStyle.nested) {
            this.getLog().warn((CharSequence)("outputStyle=" + (Object)((Object)this.outputStyle) + " is replaced by nested. Cause: libsass 3.1 only supports compressed and nested"));
        }
    }

    private SassCompiler initCompiler() {
        SassCompiler compiler = new SassCompiler();
        compiler.setEmbedSourceMapInCSS(this.embedSourceMapInCSS);
        compiler.setEmbedSourceContentsInSourceMap(this.embedSourceContentsInSourceMap);
        compiler.setGenerateSourceComments(this.generateSourceComments);
        compiler.setGenerateSourceMap(this.generateSourceMap);
        compiler.setIncludePaths(this.includePath);
        compiler.setInputSyntax(this.inputSyntax);
        compiler.setOmitSourceMappingURL(this.omitSourceMapingURL);
        compiler.setOutputStyle(this.outputStyle);
        compiler.setPrecision(this.precision);
        return compiler;
    }

    private boolean processFile(Path inputRootPath, Path inputFilePath) throws IOException {
        Output out;
        this.getLog().debug((CharSequence)("Processing File " + inputFilePath));
        Path relativeInputPath = inputRootPath.relativize(inputFilePath);
        Path outputRootPath = this.outputPath.toPath();
        Path outputFilePath = outputRootPath.resolve(relativeInputPath);
        String fileExtension = this.getFileExtension();
        outputFilePath = Paths.get(outputFilePath.toAbsolutePath().toString().replaceFirst("\\." + fileExtension + "$", ".css"), new String[0]);
        Path sourceMapRootPath = Paths.get(this.sourceMapOutputPath, new String[0]);
        Path sourceMapOutputPath = sourceMapRootPath.resolve(relativeInputPath);
        sourceMapOutputPath = Paths.get(sourceMapOutputPath.toAbsolutePath().toString().replaceFirst("\\.scss$", ".css.map"), new String[0]);
        try {
            out = this.compiler.compileFile(inputFilePath.toAbsolutePath().toString(), outputFilePath.toAbsolutePath().toString(), sourceMapOutputPath.toAbsolutePath().toString());
        }
        catch (CompilationException e) {
            this.getLog().error((CharSequence)e.getMessage());
            this.getLog().debug((Throwable)e);
            return false;
        }
        if (out.getErrorStatus() != 0) {
            this.getLog().error((CharSequence)out.getErrorMessage());
            this.getLog().debug((CharSequence)("ErrorText: " + out.getErrorText()));
            this.getLog().debug((CharSequence)("ErrorFile: " + out.getErrorFile()));
            this.getLog().debug((CharSequence)("ErrorJson: " + out.getErrorJson()));
            return false;
        }
        this.getLog().debug((CharSequence)"Compilation finished.");
        this.writeContentToFile(outputFilePath, out.getCss());
        if (out.getSourceMap() != null) {
            this.writeContentToFile(sourceMapOutputPath, out.getSourceMap());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeContentToFile(Path outputFilePath, String content) throws IOException {
        File f = outputFilePath.toFile();
        f.getParentFile().mkdirs();
        f.createNewFile();
        try (OutputStreamWriter os = null;){
            os = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            os.write(content);
            os.flush();
        }
        this.getLog().debug((CharSequence)("Written to: " + f));
    }
}

